package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.kontrakt.kontraktItem;
import de.lunqual.rzpro.items.kontrakt.kontraktStatistikZeilenItem;
import de.lunqual.rzpro.log.LogFactory;

public class DBKontrakte {

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    PreparedStatement				getListeAlle;
    PreparedStatement				getListeAktive;
    
    PreparedStatement				getListeAlleMuster;
    PreparedStatement				getListeAktiveMuster;
    PreparedStatement				getListeAlleMusterAdresse;
    PreparedStatement				getListeAktiveMusterAddresse;
    
    PreparedStatement				getKontrakt;
    PreparedStatement				saveKontrakt;
    PreparedStatement				updateKontrakt;
    PreparedStatement				getAbgerufenLiter;
    PreparedStatement				getAbgerufenKg;  
    PreparedStatement				getAbgerufenLA;
    PreparedStatement				getAbgerufenLiterVerkauf;
    PreparedStatement				getAbgerufenKgVerkauf;  
    
    PreparedStatement				getAbgerufenLiterStatistik;
    PreparedStatement				getAbgerufenKgStatistik;  
    PreparedStatement				getAbgerufenLAStatistik;
    PreparedStatement				getAbgerufenLiterVerkaufStatistik;
    PreparedStatement				getAbgerufenKgVerkaufStatistik;
    
    PreparedStatement				getAbgerufenLAVerkauf;
    PreparedStatement				getAbgerufenLAVerkaufStatistik;
    
    PreparedStatement				deleteKontrakt;
    PreparedStatement				getKontraktRezeptur;
    
    PreparedStatement				getStatistik;
    
    public static final int				KONTRAKT_EINKAUF = 0;
    public static final int				KONTRAKT_VERKAUF	= 1;
    
    public DBKontrakte(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }
    private void setStatements(){
        try{
            getListeAlle = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE  +" order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeAktive = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE + " WHERE start <= now() and ende >= now() order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
            getListeAlleMuster = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE  +" where name regexp ?  order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeAktiveMuster = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE + " WHERE name regexp ? and  start <= now() and ende >= now() order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeAlleMusterAdresse = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE  +" where name regexp ? and adresse_id=? order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeAktiveMusterAddresse = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE + " WHERE name regexp ? and  adresse_id=? and start <= now() and ende >= now() order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
 
            
            getKontrakt = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE + " where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveKontrakt     = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_KONTRAKTE + " (typ,name,rezeptur,adresse_id,adresse_text, bemerkungen,menge,einheit,start,ende,geaendert,user2,erstellt,user1) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateKontrakt   = con.prepareStatement("UPDATE " + DBFactory.TABLE_KONTRAKTE + " set typ=?,name=?,rezeptur=?,adresse_id=?,adresse_text=?, bemerkungen=?,menge=?,einheit=?,start=?,ende=?,geaendert=?,user2=?  WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
		
            getAbgerufenLiter  = con.prepareStatement("SELECT sum(liter) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenKg  = con.prepareStatement("SELECT sum(kg) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenLA  = con.prepareStatement("SELECT sum(la) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

			getAbgerufenLiterVerkauf  = con.prepareStatement("SELECT abs(sum(liter)) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenKgVerkauf  = con.prepareStatement("SELECT abs(sum(kg)) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenLAVerkauf  = con.prepareStatement("SELECT abs(sum(la)) as value FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

			
			deleteKontrakt     = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_KONTRAKTE + " where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
			getKontraktRezeptur = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_KONTRAKTE + " WHERE rezeptur=? and start <= now() and ende >= now() order by name asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAbgerufenLiterStatistik  = con.prepareStatement("SELECT sum(liter) as value ,MONTH(datum) as monat, YEAR(datum) as jahr FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenKgStatistik  = con.prepareStatement("SELECT sum(kg) as value, MONTH(datum) as monat, YEAR(datum) as jahr FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenLAStatistik  = con.prepareStatement("SELECT sum(la) as value, MONTH(datum as monat, YEAR(datum) as jahr FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ZUGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

			getAbgerufenLiterVerkaufStatistik  = con.prepareStatement("SELECT abs(sum(liter)) as value , MONTH(datum) as monat, YEAR(datum) as jahr FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenKgVerkaufStatistik  = con.prepareStatement("SELECT abs(sum(kg)) as value, MONTH(datum) as monat, YEAR(datum) as jahr FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
			getAbgerufenLAVerkaufStatistik  = con.prepareStatement("SELECT abs(sum(la)) as value, MONTH(datum) as monat, YEAR(datum) as jahr  FROM " +DBFactory.TABLE_BUCHUNG  +" where rezeptur_id=? and typ=" + DBBuchung.TYP_ABGANG + " AND datum between ? and ? group by jahr,monat",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);


			
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontraktesetStatements", e.getLocalizedMessage());
        }
    }
	
    public ArrayList<kontraktItem> getKontrakte(boolean mode){
    	ArrayList<kontraktItem> liste = new ArrayList<kontraktItem>();
    	PreparedStatement stm;
    	if (mode) {
    		stm = getListeAktive; 
    	} else {
    		stm = getListeAlle;    		
    	}
    	try { 
    	ResultSet rs = stm.executeQuery();
    		while(rs.next()) {
    			kontraktItem ki = getKontraktByRS(rs);
    			if(ki != null) {
    				liste.add(ki);
    			}
    		}
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getKontrakte", e.getLocalizedMessage());
        }
    	return liste;
    }
	
    private kontraktItem getKontraktByRS(ResultSet rs) {
    	try {
    		return  new kontraktItem(
    		  rz,
    		  rs.getInt("id"),
    		  rs.getInt("typ"),
              rs.getInt("aktiv")==1?true:false,
    		  rs.getString("name"),
    		  rs.getString("adresse_text"),
    		  rs.getInt("adresse_id"),
    		  rs.getInt("rezeptur"),
    		  rs.getDouble("menge"),
    		  rs.getInt("einheit"),
    		  rs.getString("bemerkungen"),
              db.getDateFromString(rs.getString("start")),
              db.getDateFromString(rs.getString("ende")),
              db.getDateFromString(rs.getString("erstellt")),
              db.getDateFromString(rs.getString("geaendert")),
              rs.getString("user1"),
              rs.getString("user2")
    		  );
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getKontraktByRS", e.getLocalizedMessage());
            return null;
    	}
    }
    
    public kontraktItem getKontrakt(int id) {
    	kontraktItem ret = null;
    	try {
    		if(id == 0) {
    			ret=new kontraktItem(rz);
    		} else {
    			getKontrakt.setInt(1, id);
    			ResultSet rs = getKontrakt.executeQuery();
    			if(rs.next()) {
    				ret = new kontraktItem(rz,
    						rs.getInt("id"),
    						rs.getInt("typ"),
    						rs.getInt("aktiv") == 0?false:true,
    						rs.getString("name"),
    						rs.getString("adresse_text"),
    						rs.getInt("adresse_id"),
    						rs.getInt("rezeptur"),
    						rs.getDouble("menge"),
    						rs.getInt("einheit"),
    						rs.getString("bemerkungen"),
    					    db.getDateFromString(rs.getString("start")),
    					    db.getDateFromString(rs.getString("ende")),
    					    db.getDateFromString(rs.getString("erstellt")),
    					    db.getDateFromString(rs.getString("geaendert")),
    					    rs.getString("user1"),
    					    rs.getString("user2"));
    			}
    		}
       	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getKontrakt", e.getLocalizedMessage());
            return null;
    	}
    	return ret;
    }
    
    public int saveKontrakt(kontraktItem ki) {
    	int ret;
    	try {
    		PreparedStatement stm = null;
    		if(ki.getId() == 0) {
    			stm=saveKontrakt;
        		stm.setString(13, db.dbGetDateFormatString(db.getServerTimestamp()));
        		stm.setString(14,db.dbGetUser());
    		} else {
    			stm=updateKontrakt;
    			stm.setInt(13,ki.getId());
    		}
    		stm.setInt(1, ki.getTyp());
    		stm.setString(2,ki.getName());
    		stm.setInt(3, ki.getRezeptur());
    		stm.setInt(4, ki.getAdresse_id());
    		stm.setString(5, ki.getAdresseText());
    		stm.setString(6, ki.getBemerkungen());
    		stm.setDouble(7, ki.getMenge());
    		stm.setInt(8 ,ki.getEinheit());
    		stm.setString(9, db.dbGetDateFormatString(ki.getStartDate()));
    		stm.setString(10, db.dbGetDateFormatString(ki.getEndDate()));
    		stm.setString(11, db.dbGetDateFormatString(db.getServerTimestamp()));
    		stm.setString(12,db.dbGetUser());
    		stm.executeUpdate();
    		if(ki.getId()==0) {
    			ret=db.dbGetLastInsertID(DBFactory.TABLE_KONTRAKTE);
    			ki.setId(ret);
    		}else {
    			ret=ki.getId();
    		}
    	}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.saveKontrakt", e.getLocalizedMessage());
            return -1;
    	}
    	return ret;
    }
    
    public double getAbgerufen(kontraktItem ki) {
    	double ret = 0.0;
    	PreparedStatement stm = null;
    	try {
    		switch (ki.getEinheit()) {
    			case RzPro.EINHEIT_LITER:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenLiter : getAbgerufenLiterVerkauf;
    				break; 
    			case RzPro.EINHEIT_KG:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenKg : getAbgerufenKgVerkauf;
    				break;
    			case RzPro.EINHEIT_LA:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenLA : getAbgerufenLAVerkauf;
    				break; 
    		}
    		if(stm != null) {
    			stm.setInt(1, ki.getRezeptur());
        		stm.setString(2, db.dbGetDateFormatString(ki.getStartDate()));
        		stm.setString(3, db.dbGetDateFormatString(ki.getEndDate()));
        		ResultSet rs = stm.executeQuery();
        		if(rs.next()) {
        			ret = rs.getDouble("value");
        		}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getAbgerufen", e.getLocalizedMessage());
    		return 0.0;
    	}
    	return ret;
    }
    
    public ArrayList<kontraktStatistikZeilenItem> getAbgerufenStatistik(kontraktItem ki) {
    	ArrayList<kontraktStatistikZeilenItem> ret = new ArrayList<kontraktStatistikZeilenItem>();
    	PreparedStatement stm = null;
    	try {
    		switch (ki.getEinheit()) {
    			case RzPro.EINHEIT_LITER:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenLiterStatistik : getAbgerufenLiterVerkaufStatistik;
    				break; 
    			case RzPro.EINHEIT_KG:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenKgStatistik : getAbgerufenKgVerkaufStatistik;
    				break;
    			case RzPro.EINHEIT_LA:
    				stm = ki.getTyp() == KONTRAKT_EINKAUF ? getAbgerufenLAStatistik : getAbgerufenLAVerkaufStatistik;
    				break; 
    		}
    		if(stm != null) {
    			stm.setInt(1, ki.getRezeptur());
        		stm.setString(2, db.dbGetDateFormatString(ki.getStartDate()));
        		stm.setString(3, db.dbGetDateFormatString(ki.getEndDate()));
        		ResultSet rs = stm.executeQuery();
        		while(rs.next()) {
        			ret.add(new kontraktStatistikZeilenItem(rs.getDouble("value"),rs.getInt("monat"),rs.getInt("jahr")));
        		}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getAbgerufen", e.getLocalizedMessage());
    		return null;
    	}
    	return ret;
    }
    
    
    
    
    public void deleteKontrakt(kontraktItem ki) {
    	try {
    		deleteKontrakt.setInt(1, ki.getId());
    		deleteKontrakt.executeUpdate();
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.deleteKontrakt", e.getLocalizedMessage());
    	}
    }
    
    public ArrayList<kontraktItem> getKontraktRezeptur(int id) {
    	ArrayList<kontraktItem> ret = new ArrayList<kontraktItem>();
    	try {
    		getKontraktRezeptur.setInt(1, id);
    		final ResultSet rs = getKontraktRezeptur.executeQuery();
    		while(rs.next()) {
    			ret.add(getKontraktByRS(rs));
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getKontraktRezeptur", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public int hasKontrakt(int rezeptur) {
    	int ret = 0;
    	try {
    		getKontraktRezeptur.setInt(1, rezeptur);
    		final ResultSet rs = getKontraktRezeptur.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.hasKontrakt", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public ArrayList<kontraktItem> getKontrakte(String muster, boolean mode,AdressItem ai){
    	ArrayList<kontraktItem> liste = new  ArrayList<kontraktItem>();
    	try {
    		if(muster.trim().equals("")) {
    			muster=".*";
    		}
    		
    		PreparedStatement stm;
        	if (mode) {
        		if(ai != null) {
        			stm = getListeAktiveMusterAddresse;
        			stm.setInt(2, ai.getID());
        		} else {
        			stm = getListeAktiveMuster;
        		}
        	} else {
        		if(ai != null) {
        			stm = getListeAlleMusterAdresse;
        			stm.setInt(2, ai.getID());
        		} else {
        			stm = getListeAlleMuster;
        		}
        	}
        	stm.setString(1, muster.trim());
        	ResultSet rs = stm.executeQuery();
    		while(rs.next()) {
    			kontraktItem ki = getKontraktByRS(rs);
    			if(ki != null) {
    				liste.add(ki);
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBKontrakte.getMuster", e.getLocalizedMessage());
    	}
    	return liste;
    }
    
    /*
     * Tooltip für Rezeptur mit aktivem Kontrakt
     * 
     */
    public String getToolTipString(int id) {
    	String ret = "";
    	ArrayList<kontraktItem>  liste = getKontraktRezeptur(id);
    	if(liste != null && liste.size() > 0) {
    		ret = "<br>";
    		for(kontraktItem ki:liste) {
    			ret +=  ki.getKontraktAusgabeString() + "<br>";
    		}
    	}
    	return ret;
    }
    
}

