package de.lunqual.rzpro.database;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.log.LogFactory;

import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import de.lunqual.rzpro.items.icons.*;

public class DBIcons {


    RzPro           rz;
    Connection      con;
    DBFactory       db;

    PreparedStatement getListe;
    PreparedStatement saveIcon;
    PreparedStatement deleteIcon;
 
    ArrayList<IconItem>		liste;
    
    ImageIcon 					not_found;
    
    /** Creates a new instance of DBBestellung */
    public DBIcons(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        not_found = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tanklagericon.not_found.png"));
        setStatements();
    }

    private void setStatements(){
        try{
            getListe   	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_ICONS + " order by filename asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveIcon  = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_ICONS  + "  (filename,icon)  VALUES (?,?) ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteIcon =  con.prepareStatement("DELETE FROM " + DBFactory.TABLE_ICONS  + "  where id=? ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            liste = getListe();
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBIcons.setStatements", e.getLocalizedMessage());
        }
    }

    public ImageIcon getIcon(String filename,int width) {
    	if(!filename.trim().equals("")) {
    		if(!liste.isEmpty()) {
    			for(IconItem im:liste) {
    				if(filename.equals(im.getFilename())) {
    					return im.getIcon(width);
    				}
    			}
    		}
    	}
    	return not_found;
    }

    public void deleteIcon(IconItem im) {
	    try {
	    	if(im.getId() != 0) {
	    		deleteIcon.setInt(1,im.getId());
	    		deleteIcon.executeUpdate();
	    		liste = getListe();
	    	}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBIcons.deleteIcon", e.getLocalizedMessage());
		}
    }
    
    public int saveIcon(IconItem im) {
    	int ret = 0;
    	try{
    		ByteArrayOutputStream baos = new ByteArrayOutputStream();
    		ImageIO.write(im.getImage(), "png", baos );
    		baos.flush();
    		byte[] imageInByte = baos.toByteArray();
    		baos.close();
    		saveIcon.setString(1,im.getFilename());
    		saveIcon.setBytes(2, imageInByte);
    		saveIcon.executeUpdate();
    		ret = db.dbGetLastInsertID(DBFactory.TABLE_ICONS);
    		im.setId(ret);
    	} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBIcons.saveIcon", e.getLocalizedMessage());
		}
    	liste = getListe();
    	return ret;
    }

    public ArrayList<IconItem> getListe() {
    	ArrayList<IconItem> ret = new ArrayList<IconItem>();
    	try {
           final ResultSet rs = getListe.executeQuery();
           while(rs.next()) {
        	   Blob aBlob = rs.getBlob("icon");
               byte[] imageByte = aBlob.getBytes(1, (int) aBlob.length());
               InputStream is=new ByteArrayInputStream(imageByte);
               BufferedImage image=ImageIO.read(is);
        	   IconItem im = new IconItem(
        			   rz,
        			   rs.getInt("id"),
        			   rs.getString("filename"),
        			   image
        			   );
        	   ret.add(im);
           }
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBIcons.getIcons", e.getLocalizedMessage());
		}
    	return ret;
    }

}
