/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.util.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBDM{
	
	public static final int DM_ALLE = 0;
	public static final int DM_CONNECTED = 1;
	public static final int DM_UNCONNECTED = 2;

    RzPro           		rz;
    Connection      	con;
    DBFactory       	db;
    boolean			connected = false;
    
    PreparedStatement   getListeAlle;
    PreparedStatement   getListeConnected;
    PreparedStatement   getListeUnConnected;
    PreparedStatement	setFelder;

    PreparedStatement	connect;
    PreparedStatement	disconnect;
    PreparedStatement	deleteDM;
    
    PreparedStatement getListeBezeichnung;
    PreparedStatement	getListeLosnummer;
    PreparedStatement	getListeBL;
   
    PreparedStatement getMessung;
    PreparedStatement cloneItem;
    PreparedStatement cloneItem2;
    
    
    /** Creates a new instance of DBLager */
    public DBDM(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        setStatus();
    }

    private void setStatements(){
        try{
            getListeAlle    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE  ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeConnected    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE connected <> 0 AND  ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeUnConnected    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE connected = 0 AND  ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            connect    = con.prepareStatement("UPDATE  " +DBFactory.TABLE_DM + " set bezeichnung=?,losnummer=?,connected_user=?,connected=1,connected_date=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            setFelder    = con.prepareStatement("UPDATE  " +DBFactory.TABLE_DM + " set feld1=?,feld2=?,feld3=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeBezeichnung    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE connected <> 0 AND bezeichnung regexp ? AND ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeLosnummer    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE connected <> 0 AND losnummer regexp ? AND ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getListeBL	   = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE connected <> 0 AND bezeichnung regexp ? AND losnummer regexp ? AND ( datum_zeit between ? AND ? ) ORDER BY datum_zeit asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            disconnect    = con.prepareStatement("UPDATE  " +DBFactory.TABLE_DM + " set bezeichnung='',losnummer='',connected_user='',connected=0,connected_date='2013-01-01' WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteDM    = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_DM + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getMessung    = con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_DM + " WHERE losnummer=? order by datum_zeit ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            cloneItem    = con.prepareStatement("insert into dm "  + 
            		"(bezeichnung,losnummer,datum,zeit,datum_zeit,buchung,herstellung,connected,proben_id," +
            		"dma_seriennummer,xsample_seriennummer,firmware,feld1,feld2,feld3,"+
            		"staerke,dichte,rel_dichte,dichte_temperatur,connected_user,connected_date,status,zucker,extrakt) "+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) "   
            		,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);  
            cloneItem2    = con.prepareStatement("update dm set losnummer='',status=0,connected=0,connected_user='' where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);  
            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.setStatements", e.getLocalizedMessage());
        }
    }

	public boolean isConnected() {
		return connected;
	}

	public ArrayList<DMItem> getMessung(String losnummer) {
		ArrayList <DMItem> ret = new ArrayList<DMItem>();
		if(isConnected()) {
			try {
				getMessung.setString(1, losnummer);
				ResultSet rs = getMessung.executeQuery();
				while(rs.next()) {
					ret.add(getItemFromRS(rs));
				}
			}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.getMessung", e.getLocalizedMessage());
			}
		}
		return ret;
	}
	
	public void setFelder(DMItem di) {
		try {
			setFelder.setString(1, di.getFeld1());
			setFelder.setString(2, di.getFeld2());
			setFelder.setString(3, di.getFeld3());
			setFelder.setInt(4, di.getId());
			setFelder.executeUpdate();
		}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.setFelder", e.getLocalizedMessage());
		}
	}
	
	public void deleteDM(DMItem di) {
		if(isConnected()) {
			try {
				deleteDM.setInt(1, di.getId());
				deleteDM.executeUpdate();
			}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.deleteDM", e.getLocalizedMessage());
			}
		}
	}
	
	public void disconnect(DMItem di) {
		try {
			disconnect.setInt(1, di.getId());
			disconnect.executeUpdate();
		}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.disconnect", e.getLocalizedMessage());
		}
	}
	
	public void connect(DMItem di) {
		try {
			connect.setString(1, di.getBezeichnung());
			connect.setString(2, di.getLosnummer());
			connect.setString(3, db.dbGetUser());
			connect.setString(4,db.dbGetDateFormatString(new Date()));
			connect.setInt(5, di.getId());
			connect.executeUpdate();
		}catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.connect", e.getLocalizedMessage());
		}
	}
	
	private DMItem getItemFromRS(ResultSet rs) {
		DMItem ret = null;
		if(isConnected()) {
		try {
			ret = new DMItem(
					rs.getInt("id"),
					rs.getString("bezeichnung"),
					rs.getString("losnummer"),
					rs.getString("datum"),
					rs.getString("zeit"),
 	                db.getDateFromString(rs.getString("datum_zeit")),
					rs.getInt("buchung"),
					rs.getInt("herstellung"),
					rs.getInt("connected") == 0?false:true,
					rs.getString("proben_id"),
					rs.getString("dma_seriennummer"),
					rs.getString("xsample_seriennummer"),
					rs.getString("firmware"),
					rs.getString("feld1"),
					rs.getString("feld2"),
					rs.getString("feld3"),
					rs.getString("staerke"),
					rs.getString("dichte"),
					rs.getString("rel_dichte"),
					rs.getString("dichte_temperatur"),
					rs.getString("connected_user"),
 	                db.getDateFromString(rs.getString("connected_date")),
 	                rs.getString("status"),
 	                rs.getString("zucker"),
 	                rs.getString("extrakt")
					);
		}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.getItemFromRs", e.getLocalizedMessage());
	    }
		}
		return ret;
	}
	
	public void duplicate(DMItem dmi) {
		if(isConnected()) {
			try {
				if(dmi.getId()!= 0) {
					cloneItem.setString(1, dmi.getBezeichnung());
					cloneItem.setString(2, "");
					cloneItem.setString(3,dmi.getDatum());
					cloneItem.setString(4, dmi.getZeit());
					cloneItem.setString(5, db.dbGetDateFormatString(dmi.getDatum_zeit()));
					cloneItem.setInt(6, dmi.getBuchung());
					cloneItem.setInt(7, dmi.getHerstellung());
					cloneItem.setInt(8, 0);
					cloneItem.setString(9,dmi.getProben_id());
					cloneItem.setString(10, dmi.getDma_seriennummer());
					cloneItem.setString(11, dmi.getXsample_seriennummer());
					cloneItem.setString(12, dmi.getFirmware());
					cloneItem.setString(13, dmi.getFeld1());
					cloneItem.setString(14, dmi.getFeld2());
					cloneItem.setString(15, dmi.getFeld3());
					cloneItem.setString(16, dmi.getStaerke());
					cloneItem.setString(17, dmi.getDichte());
					cloneItem.setString(18, dmi.getRel_dichte());
					cloneItem.setString(19, dmi.getDichte_temperatur());
					cloneItem.setString(20, db.dbGetUser());
					cloneItem.setString(21,  db.dbGetDateFormatString(db.getServerTimestamp()));
					cloneItem.setString(22, dmi.getStatus());
					cloneItem.setString(23, dmi.getZucker());
					cloneItem.setString(24, dmi.getExtrakt());
					cloneItem.executeUpdate();
					
					
				}
				
			}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.duplicate", e.getLocalizedMessage());
			}
		}
	}
	
 	public ArrayList<DMItem> getListeText(String bezeichnung,String losnummer,Date von, Date bis){
 		ArrayList<DMItem> ret = new ArrayList<DMItem>();
 		if(isConnected()) {
	 		try {
	 			ResultSet rs;
	 			PreparedStatement stm=null;
	 			if(!bezeichnung.equals("") && !losnummer.equals("")) {
	 				stm = getListeBL;
	 				stm.setString(1, bezeichnung);
	 				stm.setString(2, losnummer);
	 				stm.setString(3,db.dbGetDateFormatString(von));
	 				stm.setString(4, db.dbGetDateFormatString(bis));
	 			} else if (!bezeichnung.equals("")) {
	 				stm = getListeBezeichnung;
	 				stm.setString(1, bezeichnung);
	 				stm.setString(2,db.dbGetDateFormatString(von));
	 				stm.setString(3, db.dbGetDateFormatString(bis));
	 			} else if(!losnummer.equals("")) {
	 				stm = getListeLosnummer;
	 				stm.setString(1, losnummer);
	 				stm.setString(2,db.dbGetDateFormatString(von));
	 				stm.setString(3, db.dbGetDateFormatString(bis));
	 			}
	 			if(stm != null && connected == true) {
	 				rs = stm.executeQuery();
	 				while(rs.next()) {
	 					ret.add(getItemFromRS(rs));
	 				}
	 			}
			}catch (final Exception e){
		        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.getItemFromRs", e.getLocalizedMessage());
			}
 		}
 		return ret;
 	}
	
 	public ArrayList<DMItem> getListe(int what, Date von, Date bis){
 		ArrayList<DMItem> ret = new ArrayList<DMItem>();
 		if(isConnected()) {
	 		try {
	 			ResultSet rs;
	 			PreparedStatement stm=null;
	 			switch(what) {
	 				case DM_ALLE:stm = getListeAlle;
	 					break;
	 				case DM_CONNECTED: stm = getListeConnected;
	 					break;
	 				case DM_UNCONNECTED: stm = getListeUnConnected;
	 					break;
	 			}
				stm.setString(1,db.dbGetDateFormatString(von));
				stm.setString(2, db.dbGetDateFormatString(bis));
	 			if(stm != null && connected == true) {
	 				rs = stm.executeQuery();
	 				while(rs.next()) {
	 					ret.add(getItemFromRS(rs));
	 				}
	 			}
			}catch (final Exception e){
		        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.getItemFromRs", e.getLocalizedMessage());
			}
 		}
 		return ret;
 	}
	
	public void setStatus() {
		ResultSet rs;
		try {
			rs = con.getMetaData().getTables(null, null, DBFactory.TABLE_DM, null);
			if(rs.next()) {
				connected=true;
			} else {
				connected=false;
			}
		}catch (final Exception e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBDM.setStatus", e.getLocalizedMessage());
	    }
	}
   
	public String getDMListeTrace(ArrayList<DMItem> dmliste) {
		final SimpleDateFormat df1=new SimpleDateFormat("dd. MMMM yyyy");
		String ret = "";
		if(isConnected()) {
			if(dmliste != null && !dmliste.isEmpty()) {
				for(DMItem dm:dmliste) {
	        			if(dm.getStaerke().length() > 2){
	        			ret += rz.getLocale().getString("trace.dma")
	        					.replaceAll("%n",dm.getProben_id())
	        					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
	        					.replaceAll("%s",dm.getStaerke())
	        					.replaceAll("%g",dm.getDichte())
	        					.replaceAll("%1", dm.getFeld1())
	        					;
	        			} else {
	            			ret += rz.getLocale().getString("trace.dmz")
	            					.replaceAll("%n",dm.getProben_id())
	            					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
	            					.replaceAll("%z",dm.getZucker())
	            					.replaceAll("%e",dm.getExtrakt())
	            					.replaceAll("%g", dm.getDichte())
	            					.replaceAll("%r", dm.getRel_dichte())
	            					.replaceAll("%1", dm.getFeld1())
	            					;
	        			}
	        		}
			}
		}
		return ret;
	}
	
	public String getDMListeHtml(ArrayList<DMItem> dmliste,boolean color) {
		final SimpleDateFormat df1=new SimpleDateFormat("EEEE, dd. MMMM yyyy  H:mm");
		String ret = "";
		if(isConnected()) {
			if(dmliste != null && !dmliste.isEmpty()) {
				for(DMItem dm:dmliste) {
	        		ret +="<div style=\"" + (color?"background-color:ddffdd;" : "") + "\"><br><center>";
	        			if(dm.getStaerke().length() > 2){
	        			ret += rz.getLocale().getString("ausgabe.herstellung.dma")
	        					.replaceAll("%n",dm.getProben_id())
	        					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
	        					.replaceAll("%s",dm.getStaerke())
	        					.replaceAll("%g",dm.getDichte())
	        					.replaceAll("%1", dm.getFeld1())
	        					;
	        			} else {
	            			ret += rz.getLocale().getString("ausgabe.herstellung.dmz")
	            					.replaceAll("%n",dm.getProben_id())
	            					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
	            					.replaceAll("%z",dm.getZucker())
	            					.replaceAll("%e",dm.getExtrakt())
	            					.replaceAll("%g", dm.getDichte())
	            					.replaceAll("%r", dm.getRel_dichte())
	            					.replaceAll("%1", dm.getFeld1())
	            					;
	        			}
	        		ret +="&nbsp;<br>&nbsp;<br></center></div>";
	        	}
	    	}
		}
		return ret;
	}
}
