/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class DBAusstattung  {


    RzPro           rz;
    Connection      con;
    DBFactory       db;
    DialogItem		dlgItem;

    PreparedStatement   getAusstattung;
    PreparedStatement   saveAusstattung;
    PreparedStatement   updateAusstattung;
    PreparedStatement   deleteAusstattung;
    PreparedStatement	 	getAusstattungKey;
    PreparedStatement	 	updatePreis;
    PreparedStatement	 	checkAusstattung;
    PreparedStatement 	getAusstattungReport;
    PreparedStatement		getAusstattungsListe;

    /** Creates a new instance of DBAbfrage */
    public DBAusstattung(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        setStatements();
    }

    private void setStatements(){
        try{
            getAusstattung       = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE id=? and typ=4" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAusstattung      = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_REZEPTLISTE + " (name,typ,comment,adressen,stichworte,basismenge,litergewicht,artikelnummer,preis,waehrung,extraktfrei,erstellt,geaendert,user_1,user_2,hinweis,deklarationen,deklarationen_alle,spezifikation,spezifikation_text,ean) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'','','')",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateAusstattung    = con.prepareStatement("UPDATE " + DBFactory.TABLE_REZEPTLISTE + " SET name=?,typ=?,comment=?,adressen=?,stichworte=?,basismenge=?,litergewicht=?,artikelnummer=?,preis=?,waehrung=?,extraktfrei=?,erstellt=?,geaendert=?,user_1=?,user_2=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteAusstattung    = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE id=? and typ=4",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getAusstattungKey   = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE name=? and typ=" + RzPro.TYP_ID_AUSSTATTUNG,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            updatePreis            = con.prepareStatement("UPDATE " + DBFactory.TABLE_REZEPTLISTE + " set preis=?,geaendert=?,user_2=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkAusstattung     	= con.prepareStatement("SELECT id,typ,comment FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE comment REGEXP ? and typ=4",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAusstattungReport   = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_FORMULARE + " WHERE typ=?" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAusstattungsListe       = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_REZEPTLISTE + " WHERE  typ=4 and extraktfrei <> 0" ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.setStatements", e.getLocalizedMessage());
        }
    }



    /**---------------------------------------------------------------------
     *  Funktionen für Ausstattungen
     *  Ausstattungen werden als Rezeptur gespeichernt
     *----------------------------------------------------------------------
     */

    /**
     * Reports Typ Ausstattung und Ausstattung_raw holen
     */
    public ArrayList<Integer> getAusstattungsReportFormular(int typ) {
    	final ArrayList<Integer>ret = new ArrayList<Integer>();
    	try {
    		getAusstattungReport.setInt(1, typ);
    		final ResultSet rs = getAusstattungReport.executeQuery();
    		while(rs.next()) {
    			ret.add(rs.getInt("id"));
    		}
	    } catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.getAUsstattungsReportFormular", e.getLocalizedMessage());
	    }
    	return ret;
    }

    /**
     * Ausstattung aus der Datenbank entfernen
     * Diese funktion prüft NICHT, ob die Ausstattung auch
     * gelöscht werden darf !
     * siehe checkAusstattungUsed
     *
     */
    public int deleteAusstattung(int aID){
        final int ret = 0;
        try {
            deleteAusstattung.setInt(1,aID);
            if (deleteAusstattung.executeUpdate() == 0){
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("ausstattung.key_not_found"));
                dlgItem.setTitel(rz.getLocale().getString("ausstattung.key_not_found"));
                dlgItem.setMessage(rz.getLocale().getString("ausstattung.key_not_found"));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
            }
        }
        catch(final Exception e){
        	rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.deleteAusstattung:", e.getLocalizedMessage());
        }
        return ret;
    }

    /**
     * prüft, ob die Ausstattung irgendwo gebraucht wird
     * @return true, wenn gebraucht, false wenn nicht
     *
     */
    public boolean checkAusstattungUsed(int id,String name){
        boolean ret = true;
        ResultSet rs;
        try{
            //prüfen, ob die Ausstattung irgendwo verwendet wird
            checkAusstattung.setString(1,"\\[\\[" + id+ "\\]\\]");
            rs = checkAusstattung.executeQuery();
            if(rs.next()){
                // rezeptur wird gebraucht und kann nicht gelöscht werden
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("database.ausstattung_loeschen"));
                dlgItem.setTitel(rz.getLocale().getString("database.ausstattung_loeschen"));
                dlgItem.setMessage(rz.getLocale().getString("database.error_ausstattung_wird_verwendet").replaceAll("%s",name));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
                ret =  true;
            }  else {
                ret = false;
            	}
            } catch (final SQLException e) {
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.checkAusstattungUsed", e.getLocalizedMessage());
            }
            return ret;
        }
    /**
     * Ausstattung duplizieren
     */
    public int duplicateAusstattung(int id,String name) {
    	int ret = 0;
    	if(!name.equals("")) {
    		final AusstattungsItem ai = this.getAusstattung(id);
	    		if(ai != null) {
	    		ai.setID(0);
	    		ai.setTitel(name);
	    		ai.setGeaendert(db.getServerTimestamp());
	    		ai.setUser_2(db.user);
	    		ret = this.saveAusstattung(ai);
    		}
    	}
    	return ret;
    }
    /**
     * Preis updaten
     */
    public void updatePreis(AusstattungsItem ai) {
    	try {
    		if(ai != null) {
    			ai.rechnen(ai.getGebindegroesse(),rz.getDatabase().getCurrency().dbGetCurrency( ai.getWaehrung(),true));
    			updatePreis.setBigDecimal(1,ai.getGesamtPreis());
    			updatePreis.setString(2,db.dbGetDateFormatString(db.getServerTimestamp()));
    			updatePreis.setString(3,db.dbGetUser());
    			updatePreis.setInt(4,ai.getID());
    			updatePreis.executeUpdate();
    		}
    	} catch (final SQLException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.updatePreis", e.getLocalizedMessage());
    	}
    }
    /**
     * holt die ID zu einem Namen
     */
    public int getAusstattungID(String name) {
    	int ret = 0;
    	try {
    		getAusstattungKey.setString(1,name);
    		final ResultSet rs = getAusstattungKey.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
    		}
    	} catch (final SQLException e) {
    		ret = 0;
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.getAusstattungKey", e.getLocalizedMessage());
    	}
    	return ret;
    }
    /**
     * eine Auisstattung aus der Datenbank holen
     */
    public AusstattungsItem getAusstattung(int dbKey) {
    	AusstattungsItem ai = null;
    	if(dbKey == 0) {
	    	ai = new AusstattungsItem(
	    			rz,
	    			0,
	    			rz.getLocale().getString("auswahl.neue_ausstattung"),
	    			"",
	                new StichwortListe(),
	                new StichwortListe(),
	    			1,
	    			0,
	    			"",
	    			new BigDecimal(0.0),
	    			1,
	    			false,
	    			db.getServerTimestamp(),
	    			db.getServerTimestamp(),
	    			db.dbGetUser(),
	    			db.dbGetUser()
	    			);
    	} else {
	    	try {
	    		getAusstattung.setInt(1,dbKey);
	    		final ResultSet rs = getAusstattung.executeQuery();
	    		if(rs.next()) {
	    			ai = new AusstattungsItem(
	    				rz,
	    				rs.getInt("id"),
	    				rs.getString("name"),
	    				rs.getString("comment"),
	                    db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
	                    db.getSTW().dbGetStichwortListe(rs.getString("stichworte")),
	    				rs.getDouble("litergewicht"),
	    				rs.getDouble("basismenge"),
	    				rs.getString("artikelnummer"),
	                    rs.getBigDecimal("preis"),
	                    rs.getInt("waehrung"),
	                    rs.getInt("extraktfrei")==0?false:true,
	                    db.getDateFromString(rs.getString("erstellt")),
	                    db.getDateFromString(rs.getString("geaendert")),
	                    rs.getString("user_1"),
	                    rs.getString("user_2")
	    			);
	    		}
	    	}catch(final SQLException e) {
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.getAusstattung", e.getLocalizedMessage());
	    	}
    	}
    	return ai;
    }

    /**
     * Eine Ausstattung speichern/updaten
     */
    public int saveAusstattung(AusstattungsItem ai) {
    	int ret =-1;
    	PreparedStatement stm;
    	try {
	    	if(ai.getID()==0) {
	    		stm=saveAusstattung;
	            stm.setString(16,"");
	            stm.setString(17,"");
	            stm.setString(18,"");
	    	} else {
	    		stm = updateAusstattung;
	    		ai.setGeaendert(db.getServerTimestamp());
	    		stm.setInt(16,ai.getID());
	    	}
	    	stm.setString(1,ai.getTitel());
	    	stm.setInt(2,RzPro.TYP_ID_AUSSTATTUNG);
	    	stm.setString(3,ai.getRaw());
            stm.setString(4, ai.getAdressListe().toString());
            stm.setString(5, ai.getStichwortListe().toString());
            stm.setDouble(6,ai.getGebindegroesse());
            stm.setDouble(7,ai.getGebindeGewicht());
            stm.setString(8,ai.getArtikelnummer());
            stm.setBigDecimal(9, ai.getPreis());
	        stm.setInt(10, ai.getWaehrung());
	        stm.setInt(11,ai.getListe()==true?1:0);
            stm.setString(12,db.dbGetDateFormatString(ai.getErstellt()));
            stm.setString(13,db.dbGetDateFormatString(ai.getGeaendert()));
            stm.setString(14,ai.getUser1());
            stm.setString(15,ai.getUser2());

            if(stm.executeUpdate() != 0){
                if(ai.getID() == 0){
                    ret = db.dbGetLastInsertID("" + DBFactory.TABLE_REZEPTLISTE + "");
                }
                else {
                    ret = ai.getID();
                }
            }
    	} 	catch(final SQLException e) {
    		ret = -1;
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.saveAusstattung", e.getLocalizedMessage());
    	}
    	return ret;
    }

    /**
     * Eine Combobox mit Ausstattungen füllen
     */
    public void getAusstattungsListeCombo(JComboBox cmb,int aDefault) {
    	try {
    		int sel ;
    		cmb.removeAllItems();
    		final ResultSet rs = getAusstattungsListe.executeQuery();
    		while(rs.next()) {
    			cmb.addItem(getAusstattung(rs.getInt("id")));
    		}
            sel =  rz.getOptionFactory().getOption("kalkulation.ausstattung",-1);
            if(sel != -1) {
	            for(int i = 0 ;i < cmb.getModel().getSize();i++){
	                if(((AusstattungsItem)cmb.getModel().getElementAt(i)).getID() == sel){
	               		cmb.setSelectedIndex(i);
	                    break;
	                }
	            }
            }
		}catch(final SQLException e) {
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.getAusstattungsListe", e.getLocalizedMessage());
		}
    }

    public AusstattungsItem getDefaultAusstattung() {
    		try {
	    		final ResultSet rs = getAusstattungsListe.executeQuery();
	    		while(rs.next()) {
	    			if(	rs.getInt("id") ==  rz.getOptionFactory().getOption("kalkulation.ausstattung",-1)){
	    				return (getAusstattung(rs.getInt("id")));
	    			}
	    		}
			}catch(final SQLException e) {
		        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusstattung.getDefaultAusstattung", e.getLocalizedMessage());
			}
			return null;
    		}
}
