/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.ausbeute.AusbeuteItem;
import de.lunqual.rzpro.items.ausbeute.AusbeuteListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBAusbeute {

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    PreparedStatement		getListe;
    PreparedStatement 	getAusbeute;
    PreparedStatement		saveAusbeute;
    PreparedStatement		updateAusbeute;
    PreparedStatement 	deleteAusbeute;

    /** Creates a new instance of DBAbfrage */
    public DBAusbeute(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getListe   			= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUSBEUTE + " ORDER BY name ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAusbeute   	= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_AUSBEUTE + " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAusbeute   	= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_AUSBEUTE + " (`system`,name,nichtzucker,trester_min,trester_max) values (?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateAusbeute   	= con.prepareStatement("UPDATE " + DBFactory.TABLE_AUSBEUTE + " set `system`=?,name=?,nichtzucker=?,trester_min=?,trester_max=? where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteAusbeute   	= con.prepareStatement("DELETE FROM " + DBFactory.TABLE_AUSBEUTE + " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusbeute.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     * einen Ausbeutesatz löschen
     * @param id id des zu löschenden datensatzes
     */
    public void deleteAusbeuteSatz(int id) {
    	try {
    		if(id != 0) {
    			deleteAusbeute.setInt(1,id);
    			deleteAusbeute.executeUpdate();
    		}
    	} catch (final SQLException e) {
 	          rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusbeute.deleteAusbeuteSatz", e.getLocalizedMessage());
    	}
    }

    /**
     * einen Ausbeutesatz speichern oder updaten
     * @param ausbeuteItem
     * @return id des Datensatzes
     */
    public int saveAusbeuteSatz(AusbeuteItem ai) {
    	int id =0;
    	try {
    		PreparedStatement stm;
    		if(ai.getId()== 0) {
    			stm=saveAusbeute;
    		} else {
    			stm=updateAusbeute;
    			stm.setInt(6,ai.getId());
    		}
    		stm.setBoolean(1,false);
    		stm.setString(2,ai.getName());
    		stm.setDouble(3,ai.getNichtzucker());
    		stm.setDouble(4,ai.getTrester_min());
    		stm.setDouble(5,ai.getTrester_max());
    		stm.executeUpdate();
    		id = db.dbGetLastInsertID(DBFactory.TABLE_AUSBEUTE);
    	} catch (final SQLException e) {
 	          rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusbeute.saveAusbeuteSatz", e.getLocalizedMessage());
    	}
    	return id;
    }

    /**
     * einen einzelnen Ausbeutsatz holen
     * @param id  id des Satzes oder 0 für neuen Ausbeutesatz
     * @return AusbeuteItem
     */
    public AusbeuteItem getAusbeuteSatz(int id) {
    	AusbeuteItem ai=null;
    	if (id== 0) {
    		ai = new AusbeuteItem();
    	} else {
    		try {
    			getAusbeute.setInt(1,id);
    			ResultSet rs = getAusbeute.executeQuery();
        		while(rs.next()) {
        				ai = new AusbeuteItem(
        					rs.getInt("id"),
        					rs.getBoolean("system"),
        					rs.getString("name"),
        					rs.getDouble("nichtzucker"),
        					rs.getDouble("trester_min"),
        					rs.getDouble("trester_max")
        			);
        		}
        		rs.close();
        		rs=null;
    		}
    		catch (final SQLException e) {
    	          rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusbeute.getAusbeuteSatz", e.getLocalizedMessage());
    		}
    	}
    	return ai;
    }

    /**
     * Die Liste aller Ausbeutesätze holen...
     * @return Ausbeuteliste
     */
    public AusbeuteListe getAusbeuteListe() {
    	final AusbeuteListe al = new AusbeuteListe();
    	try {
    		ResultSet rs = getListe.executeQuery();
    		while(rs.next()) {
    			al.addItem(new AusbeuteItem(
    					rs.getInt("id"),
    					rs.getBoolean("system"),
    					rs.getString("name"),
    					rs.getDouble("nichtzucker"),
    					rs.getDouble("trester_min"),
    					rs.getDouble("trester_max")
    			));
    		}
    		rs.close();
    		rs=null;
    	} catch (final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAusbeute.getAusbeuteListe", e.getLocalizedMessage());
    	}
    	return al;
    }

}
