/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.adressen.AdressListe;
import de.lunqual.rzpro.items.adressen.AdressenRezepturenlisteItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBAdressen {

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    public static final int TYP_NULL=0;
    public static final int TYP_KUNDE=1;
    public static final int TYP_LIEFERANT=2;
    public static final int TYP_BEIDE=3;    

    public static final String COLOR_KUNDE			=	"ffaa00";
    public static final String COLOR_LIEFERANT	=	"00aaff";
    
    PreparedStatement   getAdressListe;
    PreparedStatement   getAdressListeInt;
    PreparedStatement   getAdressListeTyp;
    PreparedStatement   getAdresse;
    PreparedStatement   getAdresseString;
    PreparedStatement   saveAdresse;
    PreparedStatement   updateAdresse;
    PreparedStatement   getAdresseID;
    PreparedStatement   useAdresse;
    PreparedStatement   deleteAdresse;
    PreparedStatement	  getAdressenRezepturenliste;
    PreparedStatement   getAdressListeListe;


    /** Creates a new instance of DBAbfrage */
    public DBAdressen(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getAdressListe  = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ADRESSEN + " WHERE firma REGEXP ? ORDER BY firma",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAdressListeListe  = con.prepareStatement("SELECT id,firma FROM " + DBFactory.TABLE_ADRESSEN + " WHERE id IN (?) ORDER BY firma",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAdressListeTyp  = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ADRESSEN + " WHERE firma REGEXP ? and(typ=3 or  typ=?) ORDER BY firma",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getAdresse      = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ADRESSEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAdresseString      = con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ADRESSEN + " WHERE LOWER(firma)=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAdresse     = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_ADRESSEN + " (firma,vorname,nachname,strasse,plz,ort,fon,mobil,fax,mail,erstellt,geaendert,user_1,user_2,kdnummer_1,kdnummer_2,comment,typ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateAdresse   = con.prepareStatement("UPDATE " + DBFactory.TABLE_ADRESSEN + " SET firma=?,vorname=?,nachname=?,strasse=?,plz=?,ort=?,fon=?,mobil=?,fax=?,mail=?,erstellt=?,geaendert =?,user_1=?,user_2=?,kdnummer_1=?,kdnummer_2=?,comment=?,typ=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteAdresse   = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_ADRESSEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            useAdresse      = con.prepareStatement("SELECT id," + DBFactory.TABLE_ADRESSEN + "  FROM rezeptliste WHERE " + DBFactory.TABLE_ADRESSEN + " LIKE ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAdressenRezepturenliste =  con.prepareStatement("SELECT id,name,artikelnummer  FROM rezeptliste WHERE " + DBFactory.TABLE_ADRESSEN + " LIKE ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".setStatements", e.getLocalizedMessage());
        }
    }

    public ArrayList<AdressenRezepturenlisteItem>  getAdressenRezepturenliste(AdressListe liste) {
    	ArrayList <AdressenRezepturenlisteItem> ret=new ArrayList<AdressenRezepturenlisteItem>();
	    try {
	    	ResultSet rs = null;
	    	for(int i=0;i<liste.size();i++) {
	    		AdressItem ai=liste.getItem(i);
	    		AdressenRezepturenlisteItem l=new AdressenRezepturenlisteItem(ai.getFirma()+" (" +ai.getVorname()+" "+ai.getNachname()+") "+ai.getStrasse()+", "+ai.getPLZ()+" "+ai.getOrt() );
	    		ret.add(l);
	    		getAdressenRezepturenliste.setString(1,"%<" + String.valueOf(liste.getItem(i).getID())+ ">%");
	    		rs = getAdressenRezepturenliste.executeQuery();
	    		while (rs.next()) {
	    			l.getListe().add(rs.getString("name") + " ("+rs.getString("artikelnummer")+")");
	    		}
	    		
	    		rs.close();
	    	}
	    }    catch (final SQLException e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdressenRezepturen",e.getLocalizedMessage());
	    }
	    return ret;
    }
    public String   getAdressenRezepturenliste(AdressItem ai) {
    	String ret = "";
	    try {
	    	ResultSet rs = null;
	    		getAdressenRezepturenliste.setString(1,"%<" + String.valueOf(ai.getID())+ ">%");
	    		rs = getAdressenRezepturenliste.executeQuery();
	    		while (rs.next()) {
	    			ret += rs.getInt("id") + ",";
	    		}
	    		rs.close();
	    		if(ret.endsWith(",")) {
	    			ret = ret.substring(0,ret.length()-1);
	    		}
	    }    catch (final SQLException e){
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdressenRezepturenString",e.getLocalizedMessage());
	    }
	    return ret;
    }
    
    
    
    /**
     * dbGetAdressListe(String)holt die gesamte Adressliste aus der Datenbank,
     * mit aFilter als String-Filter "%" holt alle Einträge
     *
     */
    public  AdressListe dbGetAdressListe(String aFilter,int typ){
        aFilter = aFilter.replaceAll("[ ]+", ".*").replaceAll("\\(",".").replaceAll("\\)",".");
        if (aFilter.equals("")) {
			aFilter = ".*";
		}
        final AdressListe al = new AdressListe();
        ResultSet rs;
        try {
        	PreparedStatement stm;
        	if(typ==-1) {
        		stm=getAdressListe;
        	}else {
        		stm=getAdressListeTyp;
                stm.setInt(2,typ);
        	}
            stm.setString(1,aFilter);

            stm.executeQuery();
            rs = stm.getResultSet();
            while (rs.next()){
                al.addItem( new AdressItem(
                			rz,
                            rs.getInt("id"),
                            rs.getString("firma"),
                            rs.getString("vorname"),
                            rs.getString("nachname"),
                            rs.getString("strasse"),
                            rs.getString("plz"),
                            rs.getString("ort"),
                            rs.getString("fon"),
                            rs.getString("mobil"),
                            rs.getString("fax"),
                            rs.getString("mail"),
                            db.getDateFromString(rs.getString("erstellt")),
                            db.getDateFromString(rs.getString("geaendert")),
                            rs.getString("user_1"),
                            rs.getString("user_2"),
                            rs.getString("kdnummer_1"),
                            rs.getString("kdnummer_2"),
                            rs.getString("comment"),
                            rs.getInt("typ")
                            )
                          );
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdressListe",e.getLocalizedMessage());
        }
        return al;
    }

    public  String dbGetAdressListeSuchString(String liste){
        String ret = "";
        try {
        	Statement stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	final ResultSet rs = stm.executeQuery("select id,firma from adressen where id in ("+liste+")order by firma");
        	while (rs.next()){
        		if(rs.getString("firma") != null && !rs.getString("firma").equals("")) {
        			ret += rs.getString("firma") + "|";
        		}
        	}
            if(rs != null) {
				rs.close();
			}
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdressListe",e.getLocalizedMessage());
        }
    	ret = ret.replaceAll("\\s",".*");
    	if(ret.endsWith("|"))ret = ret.substring(0,ret.length()-1);
        return ret;
    }

    
    /**
     * dbGetAdresse(int) holt eine bestimmte Adresse aus der Datenbank,
     * Auswahl nach der Datenbank-ID
     *
     */
    public AdressItem dbGetAdresse(int aKey,boolean quiet){
        ResultSet rs;
        try {
            if (aKey == 0) {
             return new AdressItem(
            		 	rz,
                        0,
                        rz.getLocale().getString("database.neue_firma"),
                        "","","","","","","","","",
                        db.getServerTimestamp(),
                        db.getServerTimestamp(),
                        rz.getDatabase().dbGetUser(),
                        rz.getDatabase().dbGetUser(),
                        "","","",0
                        );
            }
            else if(db.idExists(DBFactory.TABLE_ADRESSEN,aKey,quiet)) {
		            getAdresse.setInt(1,aKey);
		            getAdresse.executeQuery();
		            rs = getAdresse.getResultSet();
		            if (rs.next()){
		                 return new AdressItem(
		                		 	rz,
		                            rs.getInt("id"),
		                            rs.getString("firma"),
		                            rs.getString("vorname"),
		                            rs.getString("nachname"),
		                            rs.getString("strasse"),
		                            rs.getString("plz"),
		                            rs.getString("ort"),
		                            rs.getString("fon"),
		                            rs.getString("mobil"),
		                            rs.getString("fax"),
		                            rs.getString("mail"),
		                            db.getDateFromString(rs.getString("erstellt")),
		                            db.getDateFromString(rs.getString("geaendert")),
		                            rs.getString("user_1"),
		                            rs.getString("user_2"),
		                            rs.getString("kdnummer_1"),
		                            rs.getString("kdnummer_2"),
		                            rs.getString("comment"),
		                            rs.getInt("typ")
		                            );
		            }
		            if(rs != null) {
						rs.close();
					}
            	}
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdresse",e.getLocalizedMessage());
        }
        return null;
    }

    public AdressItem dbGetAdresse(String aKey){
        ResultSet rs;
        try {
            getAdresseString.setString(1,aKey.toLowerCase().trim());
            getAdresseString.executeQuery();
            rs = getAdresseString.getResultSet();
            if (rs.next()){
                 return new AdressItem(
                		 	rz,
                            rs.getInt("id"),
                            rs.getString("firma"),
                            rs.getString("vorname"),
                            rs.getString("nachname"),
                            rs.getString("strasse"),
                            rs.getString("plz"),
                            rs.getString("ort"),
                            rs.getString("fon"),
                            rs.getString("mobil"),
                            rs.getString("fax"),
                            rs.getString("mail"),
                            db.getDateFromString(rs.getString("erstellt")),
                            db.getDateFromString(rs.getString("geaendert")),
                            rs.getString("user_1"),
                            rs.getString("user_2"),
                            rs.getString("kdnummer_1"),
                            rs.getString("kdnummer_2"),
                            rs.getString("comment"),
                            rs.getInt("typ")
                            );
            }
            if(rs != null) {
				rs.close();
			}
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbGetAdresseString",e.getLocalizedMessage());
        }
        return null;
    }
    /**
     * dbSaveAdresse(AdressItem) speichert eine neue Adresse in der Datenbank
     * oder macht ein Update auf eine existierende Adresse, wenn im AdressItem
     * die ID != 0 (neu) ist
     *
     */
    public int dbSaveAdresse(AdressItem ai){
        int id;
        PreparedStatement save;
        try{
            if(ai.getID() == 0){
                id = 0;
                save = saveAdresse;
            }
            else {
                id = ai.getID();
                save = updateAdresse;
                save.setInt(19,id);
                if(!db.idExists(DBFactory.TABLE_ADRESSEN,ai.getID(),true)) {
                	save = saveAdresse;
                	ai.setID(0);
                }
            }
            save.setString(1, ai.getFirma());
            save.setString(2, ai.getVorname());
            save.setString(3, ai.getNachname());
            save.setString(4, ai.getStrasse());
            save.setString(5, ai.getPLZ());
            save.setString(6, ai.getOrt());
            save.setString(7, ai.getFon());
            save.setString(8, ai.getMobil());
            save.setString(9, ai.getFax());
            save.setString(10, ai.getMail());
            save.setString(11, db.dbGetDateFormatString(ai.getErstellt()));
            save.setString(12, db.dbGetDateFormatString( ai.getGeaendert()));
            save.setString(13, ai.getUser1());
            save.setString(14, ai.getUser2());
            save.setString(15, ai.getKdnummer1());
            save.setString(16, ai.getKdnummer2());
            save.setString(17, ai.getComment());
            save.setInt(18,ai.getTyp());
            save.executeUpdate();
            if (id == 0){
                id = db.dbGetLastInsertID("" + DBFactory.TABLE_ADRESSEN + "");
            }
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbSaveAdresse", e.getLocalizedMessage());
            id = -1;
        }
        return id;
   }

    /**
     *
     * dbDeleteAdresse(AdressItem) l�scht eine Adresse aus der Datenbank
     *
     */
    public void dbDeleteAdresse(AdressItem ai){
        try{
            deleteAdresse.setInt(1,ai.getID());
            deleteAdresse.executeUpdate();
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbDeleteAdresse" ,e.getLocalizedMessage());
        }
    }

   /**
    * dbCheckAdresseUsed bigt true zur�ck, wenn eine Adresse in der REzeptliste
    * verwendet wird und false, wenn nicht
    * nur nicht verwendete " + DbControl.TABLE_ADRESSEN + " k�nnen gel�scht werden !
    */
    public boolean dbCheckAdresseUsed(int aKey){
        boolean ret = true; // sicherheitshalber ;)
        ResultSet rs;
        try{
            useAdresse.setString(1, "%<" + String.valueOf(aKey) + ">%");
            useAdresse.executeQuery();
            rs = useAdresse.getResultSet();
            if (rs.next()) {
				ret = true;
			} else {
				ret = false;
			}
            if(rs != null) {
				rs.close();
			}
        }
        catch (final SQLException e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_ADRESSEN + ".dbCheckAdresseUsed", e.getLocalizedMessage());
            ret = true;
        }
        return ret;
    }
}
