/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.abfrage.AbfrageListeEinfach;
import de.lunqual.rzpro.items.abfrage.AbfrageListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DBAbfrage {

    RzPro           rz;
    Connection      con;
    DBFactory       db;

    // Statements
    PreparedStatement   getAbfrageListe;
    PreparedStatement   getAbfrage;
    PreparedStatement   saveAbfrage;
    PreparedStatement   checkAbfrageExists;
    PreparedStatement   deleteAbfrage;
    PreparedStatement	saveHistory;
    PreparedStatement	deleteHistory;
    PreparedStatement	updateHistory;
    PreparedStatement	getHistory;
    PreparedStatement   	getHistoryRecords;
    PreparedStatement	getLast;
    PreparedStatement	saveLast;
    PreparedStatement	updateLast;
    PreparedStatement	updateAbfrageStatus;
    

    // Abfragen

    public static final int         ABFRAGE_ORDER_AA    = 0; //alpha ascending
    public static final int         ABFRAGE_ORDER_AD    = 1; //alpha descending
    public static final int         ABFRAGE_ORDER_DA    = 2; //date ascending
    public static final int         ABFRAGE_ORDER_DD    = 3; //date descending
    public static final int         ABFRAGE_MODE_AND    = 0;
    public static final int         ABFRAGE_MODE_OR     = 1;

    public static final int		 ABFRAGE_TYP_INVALID = 0;		
    public static final int         ABFRAGE_TYP_NORMAL  = 1;
    public static final int         ABFRAGE_TYP_SQL     = 2;
    public static final int		 ABFRAGE_TYP_BESTANDSWARNUNG=3;
    public static final int		ABFRAGE_TYP_TANK = 4;

    public static final int			ABFRAGE_MODE_MUSTER = 0;
    public static final int 			ABFRAGE_MODE_VERWENDUNG = 1;
    public static final int			ABFRAGE_MODE_TANK = 3;
    public static final int			ABFRAGE_MODE_EAN = 4;
    public static final int			ABFRAGE_MODE_ARTIKEL = 5;

    /** Creates a new instance of DBAbfrage */
    public DBAbfrage(RzPro r,DBFactory aDb,Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
    }

    private void setStatements(){
        try{
            getAbfrage          		= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ABFRAGEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAbfrageListe     		= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_ABFRAGEN + " ORDER BY name",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveAbfrage        		= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_ABFRAGEN + " (typ,ordering,a_mode,s_mode,name,muster,mode,stichworte,adressen,erstellt,user_1,ablage,privat) values (?,?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            checkAbfrageExists 	= con.prepareStatement("SELECT name FROM " + DBFactory.TABLE_ABFRAGEN + " WHERE name=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteAbfrage       		= con.prepareStatement("DELETE FROM " + DBFactory.TABLE_ABFRAGEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveHistory    	       	= con.prepareStatement("INSERT INTO " + DBFactory.TABLE_HISTORY + " (typ,ordering,a_mode,s_mode,name,muster,mode,stichworte,adressen,`rank`,user_1,ablage) values (?,?,?,?,?,?,?,?,?,?,?,?)",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateHistory           	= con.prepareStatement("UPDATE " + DBFactory.TABLE_HISTORY + " set typ=?,ordering=?,a_mode=?,s_mode=?,name=?,muster=?,mode=?,stichworte=?,adressen=?,`rank`=?,user_1=?,ablage=? WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteHistory     	    = con.prepareStatement("UPDATE " + DBFactory.TABLE_HISTORY + " SET typ=" + ABFRAGE_TYP_INVALID + ",name='', muster='',stichworte='',adressen='',`rank`=0,ablage=0 WHERE user_1=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getHistory 					= con.prepareStatement("SELECT * FROM " + DBFactory.TABLE_HISTORY + " WHERE user_1=? AND typ <> " + ABFRAGE_TYP_INVALID +  " order by `rank` asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getHistoryRecords		= con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_HISTORY + " WHERE user_1=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getLast          			= con.prepareStatement("SELECT value FROM " + DBFactory.TABLE_LAST_ACTIVE + " WHERE user=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveLast        			= con.prepareStatement("INSERT INTO  " + DBFactory.TABLE_LAST_ACTIVE + " (value,user) values (?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateLast        		= con.prepareStatement("UPDATE  " + DBFactory.TABLE_LAST_ACTIVE + " set value=? where user=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateAbfrageStatus	= con.prepareStatement("UPDATE  " + DBFactory.TABLE_ABFRAGEN + " set privat=?,user_1=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.setStatements", e.getLocalizedMessage());
        }
    }

    /**
     */
    public void updateAbfrageStatus(int id,boolean status){
        try {
        	if(id!=0) {
	            updateAbfrageStatus.setInt(1, (status)?1:0);
	            updateAbfrageStatus.setString(2,db.dbGetUser());
	            updateAbfrageStatus.setInt(3,id);
	            updateAbfrageStatus.executeUpdate();
	        }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.UpdateAbfrageStatus:", e.getLocalizedMessage());
        }
    }
    
    /**
     * dbDeleteAbfrage (AbfrageItem) l�scht eine Abfrage aus der DAtenbank
     */
    public void dbDeleteAbfrage(AbfrageItem ai){
        try {
            deleteAbfrage.setInt(1, ai.getID());
            deleteAbfrage.executeUpdate();
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.dbDeleteAbfrage:", e.getLocalizedMessage());
        }
    }

    /**
     * boolean dbGheckAbfrageExists(String) pr�ft ob eine Abfrage dieses
     * Namens bereits vorhanden ist
     */
    public boolean dbCheckAbfrageExists(String aName){
//        boolean ret = true;
//        ResultSet rs;
//        try {
//            checkAbfrageExists.setString(1, aName.trim());
//            checkAbfrageExists.executeQuery();
//            rs = checkAbfrageExists.getResultSet();
//            ret = rs.next();
//            rs.close();
//        }
//        catch (final Exception e){
//            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "db.dbCheckAbfrageExists:", e.getLocalizedMessage());
//        }
//        return ret;
    	return false;//Ab Version 1.8.8 gibt es auch private Abfragen, die den gleichen Namen haben können wie öffentliche Abfragen
    }

     /**
      * dbGetAbfrageListe() holt die Liste aller " + DbControl.TABLE_ABFRAGEN + "
      */

     public AbfrageListeEinfach dbGetAbfrageListe(){
         final AbfrageListeEinfach al = new AbfrageListeEinfach();
         ResultSet rs;
         try{
             getAbfrageListe.executeQuery();
             rs = getAbfrageListe.getResultSet();
             while(rs.next()){
            	 if((rs.getInt("privat")==0)||(rs.getInt("privat")==1 && rs.getString("user_1").equals(db.dbGetUser()))) {
	                 al.addItem(new AbfrageItem(
	                    rs.getInt("id"),
	                    rs.getInt("typ"),
	                    rs.getInt("ordering"),
	                    rs.getInt("a_mode"),
	                    rs.getInt("s_mode"),
	                    rs.getString("name"),
	                    rs.getString("muster"),
						rs.getInt("mode"),
	                    db.getSTW().dbGetStichwortListe(rs.getString("adressen")),
	                    db.getSTW().dbGetStichwortListe(rs.getString("stichworte")),
	                    db.getDateFromString(rs.getString("erstellt")),
	                    rs.getString("user_1"),
	                    rs.getInt("ablage") != 0?true:false,
	                    rs.getInt("privat") != 0?true:false
	                    )
	                 );
	             }
             }
             if(rs != null) {
				rs.close();
			}
         }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.dbGetAbfrageListe", e.getLocalizedMessage());
        }
        return al;
     }

     /**
      * dbGetAbfrage(int) holt eine bestimmte Abfrage aus der Datenbank
      * wenn aID == 0 wird einfach eine neue Abfrage zur�ckgegeben
      */
     public AbfrageItem dbGetAbfrage(int aID){
         AbfrageItem ret = new AbfrageItem();
         ResultSet rs;
         try{
             if (aID != 0){
             	if(db.idExists(DBFactory.TABLE_ABFRAGEN,aID,false)) {
	                getAbfrage.setInt(1, aID);
	                getAbfrage.executeQuery();
	                rs = getAbfrage.getResultSet();
	                if(rs.next()){
	                    ret.setID(aID);
	                    ret.setTyp(rs.getInt("typ"));
	                    ret.setOrder(rs.getInt("ordering"));
	                    ret.setAMode(rs.getInt("a_mode"));
	                    ret.setSMode(rs.getInt("s_mode"));
	                    ret.setName(rs.getString("name"));
	                    ret.setMuster(rs.getString("muster"));
	                    ret.setMode(rs.getInt("mode"));
	                    ret.setErstellt(db.getDateFromString(rs.getString("erstellt")));
	                    ret.setUser1(rs.getString("user_1"));
	                    ret.setAdressListe(db.getSTW().dbGetAdressenListe(rs.getString("adressen")));
	                    ret.setStichwortListe(db.getSTW().dbGetStichwortListe(rs.getString("stichworte")));
	                    ret.setAblage(rs.getInt("ablage")!= 0?true:false);
	                    ret.setPrivat(rs.getInt("privat")!=0?true:false);
	                }
	                if(rs != null) {
						rs.close();
					}
	             }
             }
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBABfrage.dbGetAbfrage", e.getLocalizedMessage());
            ret = null;
        }
        return ret;
     }

     /**
      * int dbSaveAbfrage(AbfrageItem) speichert eine Abfrage und gibt die
      * ID zurück
      */
     public int dbSaveAbfrage(AbfrageItem ai){
         int ret = 0;
         try{
             saveAbfrage.setInt(1, ai.getTyp());
             saveAbfrage.setInt(2, ai.getOrder());
             saveAbfrage.setInt(3, ai.getAMode());
             saveAbfrage.setInt(4, ai.getSMode());
             saveAbfrage.setString(5, ai.getName());
             saveAbfrage.setString(6,ai.getMuster());
             saveAbfrage.setInt(7,ai.getMode());
             saveAbfrage.setString(8, ai.getStichwortListe().toString());
             saveAbfrage.setString(9, ai.getAdressListe().toString());
             saveAbfrage.setString(10, db.dbGetDateFormatString(db.getServerTimestamp()));
             saveAbfrage.setString(11, db.dbGetUser());
             saveAbfrage.setInt(12,ai.isAblage()?1:0);
             saveAbfrage.setInt(13,ai.isPrivat()?1:0);
             saveAbfrage.executeUpdate();
             ret = db.dbGetLastInsertID("" + DBFactory.TABLE_ABFRAGEN + "");
         }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.dbSaveAbfrage", e.getLocalizedMessage());
        }
        return ret;
     }

     private ArrayList<Integer> getHistoryRecords(String user){
    	 ArrayList<Integer> liste = new ArrayList<Integer>();
    	 try {
    		 getHistoryRecords.setString(1,user);
    		 ResultSet rs=getHistoryRecords.executeQuery();
    		 while(rs.next()) {
    			 liste.add(Integer.valueOf(rs.getInt("id")));
    		 }
    		 rs.close();
         } catch (final Exception e){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.dbGetHistoryRecords", e.getLocalizedMessage());
         }
         
    	 return liste;
     }
     
     
     public void deleteHistory(String user) {
    	 try {
    		 deleteHistory.setString(1,user);
    		 deleteHistory.executeUpdate();
    	 }
    	 catch (final Exception e){
    	 		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.deleteHistory", e.getLocalizedMessage());
         }
     }
     /**
      *
      */
     
     public void saveHistory(AbfrageListe al) {
    	 try {
    		 deleteHistory(db.dbGetUser());
    		 ArrayList<Integer> liste = getHistoryRecords(db.dbGetUser());
    		 int i;
    		 if(al.size() <= liste.size()) {
    			 // updates only
    			 for(i=0;i < al.size();i++) {
        			 AbfrageItem ai=al.getItem(i);
		             updateHistory.setInt(1, ai.getTyp());
		             updateHistory.setInt(2, ai.getOrder());
		             updateHistory.setInt(3, ai.getAMode());
		             updateHistory.setInt(4, ai.getSMode());
		             updateHistory.setString(5, ai.getName());
		             updateHistory.setString(6, ai.getMuster());
		             updateHistory.setInt(7,ai.getMode());
		             updateHistory.setString(8, ai.getStichwortListe().toString());
		             updateHistory.setString(9, ai.getAdressListe().toString());
		             updateHistory.setInt(10,i );
		             updateHistory.setString(11,db.dbGetUser());
		             updateHistory.setInt(12,ai.isAblage()?1:0);
		             updateHistory.setInt(13,liste.get(i));
		             updateHistory.executeUpdate();
    			 }
    		 }else {
    			 // updates UND inserts
    			 for(i=0;i < al.size();i++) {
        			 AbfrageItem ai=al.getItem(i);
        			 if(i < liste.size()) {
        				 //update, solange existierende Records da sind
    		             updateHistory.setInt(1, ai.getTyp());
    		             updateHistory.setInt(2, ai.getOrder());
    		             updateHistory.setInt(3, ai.getAMode());
    		             updateHistory.setInt(4, ai.getSMode());
    		             updateHistory.setString(5, ai.getName());
    		             updateHistory.setString(6, ai.getMuster());
    		             updateHistory.setInt(7,ai.getMode());
    		             updateHistory.setString(8, ai.getStichwortListe().toString());
    		             updateHistory.setString(9, ai.getAdressListe().toString());
    		             updateHistory.setInt(10,i );
    		             updateHistory.setString(11,db.dbGetUser());
    		             updateHistory.setInt(12,liste.get(i));
    		             updateHistory.setInt(13,ai.isAblage()?1:0);
    		             updateHistory.executeUpdate();
        			 } else {
        				 //danach nur noch inserts
    		             saveHistory.setInt(1, ai.getTyp());
    		             saveHistory.setInt(2, ai.getOrder());
    		             saveHistory.setInt(3, ai.getAMode());
    		             saveHistory.setInt(4, ai.getSMode());
    		             saveHistory.setString(5, ai.getName());
    		             saveHistory.setString(6, ai.getMuster());
    		             saveHistory.setInt(7,ai.getMode());
    		             saveHistory.setString(8, ai.getStichwortListe().toString());
    		             saveHistory.setString(9, ai.getAdressListe().toString());
    		             saveHistory.setInt(10,i );
    		             saveHistory.setString(11,db.dbGetUser());
    		             saveHistory.setInt(12,ai.isAblage()?1:0);
    		             saveHistory.executeUpdate();
        			 }
    			 }
    		 }
         }
         catch (final Exception e){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.saveHistory", e.getLocalizedMessage());
         }
     }
     
     public int saveHistoxry(AbfrageListe al){
         int ret = 0;
         try{
        	 deleteHistory(db.dbGetUser());
        	 if(al.size()>0) {
        		 for(int i=0;i < al.size();i++) {
        			 AbfrageItem ai=al.getItem(i);
		             saveHistory.setInt(1, ai.getTyp());
		             saveHistory.setInt(2, ai.getOrder());
		             saveHistory.setInt(3, ai.getAMode());
		             saveHistory.setInt(4, ai.getSMode());
		             saveHistory.setString(5, ai.getName());
		             saveHistory.setString(6, ai.getMuster());
		             saveHistory.setInt(7,ai.getMode());
		             saveHistory.setString(8, ai.getStichwortListe().toString());
		             saveHistory.setString(9, ai.getAdressListe().toString());
		             saveHistory.setInt(10,i );
		             saveHistory.setString(11,db.dbGetUser());
		             saveHistory.executeUpdate();
        		 }
        	 }
             ret = db.dbGetLastInsertID(DBFactory.TABLE_HISTORY);
         }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.saveHistory", e.getLocalizedMessage());
        }
        return ret;
     }
     
     public AbfrageListe gethistory() {
    	 AbfrageListe al=new AbfrageListe(rz.getOptionFactory().getOption("auswahl.abfrageliste_max", OptionFactory.AUSWAHL_ABFRAGELISTE_MAX));
    	 try {
    		getHistory.setString(1,db.dbGetUser());
    		ResultSet rs= getHistory.executeQuery();
    		while(rs.next()) {
    			al.addItem(new AbfrageItem(
    					rs.getInt("id"),
 	                    rs.getInt("typ"),
 	                    rs.getInt("ordering"),
 	                    rs.getInt("a_mode"),
 	                    rs.getInt("s_mode"),
 	                    rs.getString("name"),
 	                    rs.getString("muster"),
 	                    rs.getInt("mode"),
 	                    db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
 	                    db.getSTW().dbGetStichwortListe(rs.getString("stichworte")),
 	                    new java.util.Date(),
 	                    rs.getString("user_1"),
 	                    rs.getInt("ablage") != 0?true:false,
 	                    false
    			));
    		}
    	 }
         catch (final Exception e){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.getHistory", e.getLocalizedMessage());
         }
    	 return al;
     }
     
     public void saveLastActive(int value) {
    	 if(value >0) {
	    	 try {
	    		 String user = db.dbGetUser();
	    		 if(getLastActive() != 0) {
	    			 updateLast.setInt(1,value);
	    			 updateLast.setString(2,user);
	    			 updateLast.executeUpdate();
	    		 }else {
	    			 saveLast.setInt(1,value);
	    			 saveLast.setString(2,user);
	    			 saveLast.executeUpdate();
	    		 }
	    	 } catch (final Exception e){
	             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.getSaveActive", e.getLocalizedMessage());
	         }
    	 }
     }
     
     public int getLastActive() {
    	 int ret = 0;
    	 try {
    		 getLast.setString(1,db.dbGetUser());
    		 ResultSet rs = getLast.executeQuery();
    		 if(rs.next()) {
    			 ret=rs.getInt("value");
    		 }
    	 }catch (final Exception e){
             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBAbfrage.getLastActive", e.getLocalizedMessage());
         }

    	 return ret;
     }
}
