/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.jfree.org/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2004, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------------------------
 * TriggerNestedGroupFunction.java
 * ------------------------------
 * (C)opyright 2004, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: TriggerNestedGroupFunction.java,v 1.1.2.1 2004/04/27 15:02:06 taqua Exp $
 *
 * Changes
 * -------------------------
 * 10.09.2004 : changed by lunqual
 * 24.04.2004 : Initial version
 *
 */

package de.lunqual.rzpro.ausgabe;

import org.jfree.report.function.AbstractFunction;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.Element;


import de.lunqual.rzpro.RzPro;

public class VisibleBandFunction extends AbstractFunction
{
  /**
   * Creates an unnamed function. Make sure the name of the function is set using {@link
   * #setName} before the function is added to the report's function collection.
   */
  public VisibleBandFunction ()
  {
  }

  /**
   *
   * @param event the event.
   */

  @Override
public void itemsAdvanced (final ReportEvent event)
  {
    final Element literBand = event.getReport().getItemBand().getElement("liter");
    final Element kgBand = event.getReport().getItemBand().getElement("kg");
    final Element laBand = event.getReport().getItemBand().getElement("la");
    final Element commentBand = event.getReport().getItemBand().getElement("comment");
    final Element commentWarningBand = event.getReport().getItemBand().getElement("commentWarning");

    if ((literBand == null) || (kgBand == null) || (laBand == null) || (commentBand == null))
    {
      //Log.warn ("IllegalState: Child-Itembands not found.");
      return;
    }

    // and now apply the visiblity to all bands affected

    final int rechnen = ((Integer)(event.getDataRow().get("flag"))).intValue();

    switch(rechnen) {
    	case RzPro.EINHEIT_COMMENT_WARNING:
    	    if (commentWarningBand != null) commentWarningBand.setVisible(false);
    		literBand.setVisible(false);
    		kgBand.setVisible(false);
    		laBand.setVisible(false);
    		if(commentWarningBand != null) {
    			commentBand.setVisible(false);
    			commentWarningBand.setVisible(true);
    		} else {
    			commentBand.setVisible(true);    			
    		}
    		break;
    	case RzPro.EINHEIT_COMMENT:
    	    if (commentWarningBand != null) commentWarningBand.setVisible(false);
    		literBand.setVisible(false);
    		kgBand.setVisible(false);
    		laBand.setVisible(false);
    		commentBand.setVisible(true);
    		break;
    	case RzPro.EINHEIT_LITER:
    	    if (commentWarningBand != null) commentWarningBand.setVisible(false);
    		literBand.setVisible(true);
    		kgBand.setVisible(false);
    		laBand.setVisible(false);
    		commentBand.setVisible(false);
    		break;
    	case RzPro.EINHEIT_KG:
    	    if (commentWarningBand != null) commentWarningBand.setVisible(false);
    		literBand.setVisible(false);
    		kgBand.setVisible(true);
    		laBand.setVisible(false);
    		commentBand.setVisible(false);
    		break;
    	case RzPro.EINHEIT_LA:
    	    if (commentWarningBand != null) commentWarningBand.setVisible(false);
    		literBand.setVisible(false);
    		kgBand.setVisible(false);
    		laBand.setVisible(true);
    		commentBand.setVisible(false);
    		break;
    }
  }

  /**
   * Return the current expression value. <P> The value depends (obviously) on the
   * expression implementation.
   *
   * @return the value of the function.
   */
  public Object getValue ()
  {
    return null;
  }

}
