/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class VerlaufDrucken extends ReportAusgabe {

    BuchungsListe			bl;
    String						los;
    boolean					duplex=false;
    
    public static final String DEFAULT_ORIENTATION = "landscape";

    public VerlaufDrucken(RzPro r,Object reportData ,String optionKey,String los,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        bl = (BuchungsListe)reportData;
        this.los=los;
        this.optionKey=optionKey;
        this.duplex=duplex;
    }



    /** liefert ein TableModel
     *
     */
    @Override
	public void  createModel(){
        BuchungsItem bi;
        String codeString="";
        final tableModel modell = new tableModel();
        if (modell != null) {
            for(int i = 0;i < bl.size();i++) {
                bi = bl.getItem(i);
                switch(bi.getCode()) {
                	case DBBuchung.CODE_EINKAUF : codeString=rz.getLocale().getString("report.statistik.code_einkauf");break;
                	case DBBuchung.CODE_ENTNAHME : codeString=rz.getLocale().getString("report.statistik.code_entnahme");break;
                	case DBBuchung.CODE_HERSTELLUNG : codeString=rz.getLocale().getString("report.statistik.code_herstellung");break;
                	case DBBuchung.CODE_KORREKTUR_ZUGANG : codeString=rz.getLocale().getString("report.statistik.code_korrektur");break;
                	case DBBuchung.CODE_KORREKTUR_ABGANG : codeString=rz.getLocale().getString("report.statistik.code_korrektur");break;
                	case DBBuchung.CODE_SCHWUND : codeString=rz.getLocale().getString("report.statistik.code_schwund");break;
                	case DBBuchung.CODE_SCHWUNDAUSGLEICH : codeString=rz.getLocale().getString("report.statistik.code_schwundausgleich");break;
                }
                String r = ""; 
        		if(bi.getHerstellung() != 0) {
            		r=bi.getHerstellung_losnummer();
            		if(!bi.getHerstellung_bezeichnung().equals("")) {
            			r +=" [" + bi.getHerstellung_bezeichnung()+"]";
            		}
            		if(!bi.getHerstellungProbe().equals("")) {
            			r +=" [" + rz.getLocale().getString("statistik.probe") + ":" + bi.getHerstellungProbe()+"]";
            		}
        		}
                modell.addItem(
                        rz.getDatabase().dbGetUser(),
                        new Date(),
                        Integer.valueOf(bi.getTyp()),
                        bi.getDatum(),
                        bi.getTyp() == DBBuchung.TYP_ZUGANG ? rz.getLocale().getString("report.statistik.zugang") : rz.getLocale().getString("report.statistik.abgang"),
                        codeString,
                        //bi.getHerstellung_losnummer(),
                        r,
                        bi.getUser(),
                        bi.getBezeichnung(),
                        Double.valueOf(bi.getStaerke()),
                        Double.valueOf(bi.getLitergewicht()),
                        bi.getLosnummer(),
                        Double.valueOf(bi.getLiter()),
                        Double.valueOf(bi.getKg()),
                        Double.valueOf(bi.getLa()),
                        Double.valueOf(bi.getRest_liter()),
                        Double.valueOf(bi.getRest_kg()),
                        Double.valueOf(bi.getRest_la()),
                        bi.getComment(),
                        los);
            }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }
    public void printReport(){
    	try {
    	  if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
              final PreviewFrame frame = new PreviewFrame(report);
              frame.pack();
              frame.setVisible(true);
              frame.requestFocus();
          } else {
          		if(duplex) {
          			printDirectlyDuplex(report);
          		} else {
          			printDirectly(report);
          		}	
          }
        }
        catch (final Exception e){}
    }
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
               "user","datum","abgang",
               "buchungsdatum","typ","code","herstellung_losnummer",
               "benutzer","bezeichnung","staerke","litergewicht","losnummer",
               "liter","kg","la","rest_liter","rest_kg","rest_la",
               "bemerkungen","los"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,Integer.class,
                java.util.Date.class,String.class,String.class,String.class,
                String.class,String.class,Double.class,Double.class,String.class,
                Double.class,Double.class,Double.class,Double.class,Double.class,Double.class,
                String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final Integer abgang,
                final Date buchungsdatum,
                final String typ,
                final String code,
                final String herstellung_losnummer,
                final String benutzer,
                final String bezeichnung,
                final Double staerke,
                final Double litergewicht,
                final String losnummer,
                final Double liter,
                final Double kg,
                final Double la,
                final Double rest_liter,
                final Double rest_kg,
                final Double rest_la,
                final String bemerkungen,
                final String los
        		)

        {
            	liste.add (new Object[] {
            	        user,datum,abgang,
                          buchungsdatum,
                          typ,
                          code,
                          herstellung_losnummer,
                          benutzer,
                          bezeichnung,
                          staerke,
                          litergewicht,
                          losnummer,
                          liter,
                          kg,
                          la,
                          rest_liter,
                          rest_kg,
                          rest_la,
                          bemerkungen,
                          los
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}



