/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.items.trace.TraceLineItem;

/**
 * @author labor
 *
 */
public class TraceDrucken extends ReportAusgabe {

	TraceItem tri;
	boolean vorschau;
	boolean duplex=false;
	
    public static final 		String			DEFAULT_ORIENTATION="landscape";
    /**
     *
     */
    public TraceDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        this.vorschau = vorschau;
        rz = r;
        this.duplex=duplex;
        this.optionKey=optionKey;
        tri = (TraceItem)reportData;
    }



    /** liefert ein TableModel
     */
    @Override
	public void  createModel(){
    	if(tri != null) {
        tableModel modell = null;
        modell = new tableModel();
        		if(modell != null) {
        			for(TraceLineItem zeile:tri.getText().getZeilen()) {
        				modell.addItem(rz.getDatabase().dbGetUser(),
        						tri.getLabelTitel(), 
        						rz.getDatabase().getServerTimestamp(),
        						zeile.getTyp(),
        						zeile.getLevel(), 
        						zeile.toString()
        				);
        			}
	        		report = getReport();
	        		report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        		report.setQuery ("default");
        		}
    		}
    }
    
    @Override
    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
	    				printDirectly(report);
	                }
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","datum","typ","level","zeile"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, java.util.Date.class,Integer.class, Integer.class, String.class, 
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final Date datum,
                final int typ,
                final int level,
                final String zeile
                )
        {
            	liste.add (new Object[] {user,titel,datum,typ,level,zeile});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

