/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class TankbelegungDrucken extends ReportAusgabe {

	boolean								vorschau;
	boolean								alle;
	ArrayList<tankItem>		liste;
	boolean								lager = false;
	boolean					duplex=false;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public TankbelegungDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,boolean alle,boolean lager,java.awt.Window w,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        this.vorschau=vorschau;
        this.alle=alle;
        this.lager=lager;
        this.duplex=duplex;
        this.liste = (ArrayList<tankItem>)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        Date now = new Date();
        if(modell != null) {
        	if(liste != null && !liste.isEmpty()) {
        		for(tankItem ti:liste) {
        			boolean add = false;
        			if(alle){
        				add = true;
        			}else {
        				if(!rz.isZero(ti.getRestLiter())||ti.isMischung()) {
        					add = true;
        				}
        			}
        			if(add) {
        				String belegt = "";
        				if(rz.isZero(ti.getRestLiter())&&!ti.isMischung()) {
        					belegt = rz.getLocale().getString("tankbelegungdrucken.frei");
        				} else {
        					if(ti.isStellplatz()) {
            					belegt = rz.getLocale().getString("tankbelegungdrucken.stellplatz_belegt")
            							.replaceAll("%l",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE))
            							.replaceAll("%k",rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE));
        					} else {
        						if(ti.isMischung()) {
        							belegt = rz.getLocale().getString("tankbelegungdrucken.tank_belegt_mischung")
        									.replaceAll("%l",rz.getLocale().formatNumber(ti.getRestKg(),OptionFactory.NF_ONE));
        						}else {
        							belegt = rz.getLocale().getString("tankbelegungdrucken.tank_belegt")
        									.replaceAll("%l",rz.getLocale().formatNumber(ti.getRestLiter(),OptionFactory.NF_ONE));
        						}
        					}
        				}
        				String nummer = "";
        				if(!ti.isStellplatz()) {
        					nummer = rz.getLocale().getString("tankbelegungdrucken.tank_nummer")
        							.replaceAll("%n",ti.getNummer())
        							.replaceAll("%l", rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE));
        				}else {
        					if(ti.isMischung()) {
        						nummer = rz.getLocale().getString("tankbelegungdrucken.mischung_nummer")
            							.replaceAll("%n","XXXX");
        					} else {
        						nummer = rz.getLocale().getString("tankbelegungdrucken.stellplatz_nummer")
        							.replaceAll("%n",ti.getNummer());
        					}
        				}
        				modell.addItem(rz.getDatabase().dbGetUser(),
        						nummer,
        						belegt,
        						ti.getInhaltsListe().getInhaltBezeichnungMitMenge(lager), 
        						ti.getComment(),
        						now,
        						ti.isMischung()
        						);
        			}
        		}
        	}
	    }
        report = getReport();
        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
        report.setQuery ("default");
    }

    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
	    				printDirectly(report);
	                }
				}
            }
        }
        catch (final Exception e){}
    }
    
    
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","belegt","inhalt","bemerkungen","datum","mischung"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class,String.class,String.class,String.class,Date.class,Boolean.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final String belegt,
                final String inhalt,
                final String bemerkungen,
                final Date datum,
                final boolean mischung
                )
        {
            	liste.add (new Object[] {user,titel,belegt,inhalt,bemerkungen,datum,mischung});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

