/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class SpezifikationFormblattDrucken extends ReportAusgabe {

	SPFormblattItem						spf;
	RechenItem								ri;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public SpezifikationFormblattDrucken(RzPro r,Object reportData ,RechenItem ri,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.ri = ri;
        this.optionKey=optionKey;
        spf = (SPFormblattItem)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(spf != null){
	            final String titel = spf.getTitel();
	            final String zeilen[] = spf.getText().split("\\n");
	            final String user = rz.getDatabase().dbGetUser();
	            final Date datum = new Date();
	            Integer band = 0;
	            for (String element : zeilen) {
	            	if(ri != null) {
	            		element = element.replaceAll("\\$bezeichnung",ri.getRezeptur().getTitel()).
	            				replaceAll("\\$vol",rz.getLocale().formatNumber(ri.getStaerke(), OptionFactory.NF_TWO))
	            				.replaceAll("\\$ok","\u2611")
	            				.replaceAll("\\$leer","\u2610");
	            	}
	            	if(element.trim().startsWith("!")) {
	            		band = 1;
	            		element=element.substring(1);
	            	} else {
	            		band = 0;
	            	}
	                modell.addItem(datum,user,titel,band,element);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    public void printReport(){
        try{
        	if(ri != null && ri.isDuplex()) {
        		printDirectlyDuplex(report);
        	} else {
				printDirectly(report);
            }
		}
        catch (final Exception e){}
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "datum","user","titel","band","zeile"
              };

              private final Class[] COLUMN_TYPE = {
               Date.class,String.class,String.class,Integer.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		final Date datum,
        		final String user,
        		final String titel,
        		final Integer band,
        		final String zeile
                )
        {
            	liste.add (new Object[] {datum,user,titel,band,zeile});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

