/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class RezepturAusgabeDrucken extends ReportAusgabe {

    RzPro 					rz;
    int 						key;

    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public RezepturAusgabeDrucken(RzPro r,Object reportData,String optionKey, java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        key = ((Integer)reportData).intValue();
        this.optionKey = optionKey;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void createModel(){
        tableModel modell = null;
        RezepturItem ri = null;
        String[] zeilen;
        ri = rz.getDatabase().getRezeptur().dbGetRezeptur(key,false);
        modell = new tableModel();
        if(modell != null) {
	        if(ri != null){
	        	final String titel = ri.getTitel();
	            final String erstellt  = rz.getLocale().getString("string_erstellt").replaceAll("%s", ri.getErstelltToString()).replaceAll("%v",ri.getUser1());
	            final String geaendert = rz.getLocale().getString("string_geaendert").replaceAll("%s", ri.getGeaendertToString()).replaceAll("%v",ri.getUser2());
	            final String adressen = ri.getAdressListe().toVerboseString();
	            final String stichworte = ri.getStichwortListe().toVerboseString();
	            final String isVerweis = rz.getLocale().getString("rezeptur.label_verweis") + " :";
	            String verweisTo = "";
	            final String verweisListeLabel = rz.getLocale().getString("ausgabe.verweise") + " :";
	            final String verweisListe = rz.getDatabase().getRezeptur().dbGetVerweisListe(key);
	            final Date datum = new Date();
	            final String user = rz.getDatabase().dbGetUser();
	            // Verweis ?
	            if (ri.getVerweis() != 0) {
	                ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ri.getVerweis(),true);
	                verweisTo = ri.getTitel();
	            }
	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert, isVerweis, verweisTo, datum);
	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert, verweisListeLabel, verweisListe, datum);
	            //stärke
	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.staerke") + " :",
	                    rz.getLocale().formatNumber(ri.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol"),
	                    datum);
	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.extraktfrei") + " :",
	            		(ri.getExtraktfrei() == true) ? rz.getLocale().getString("string_ja") +"\n" : rz.getLocale().getString("string_nein") ,
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.extrakt") + " :",
	            	rz.getLocale().formatNumber(ri.getExtrakt(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentmas"),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.litergewicht") + " :",
	            		rz.getLocale().formatNumber(ri.getLitergewicht(), OptionFactory.NF_LITERGEWICHT) + " " + rz.getDatabase().getEinheiten().dbGetLitergewichtString(),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.basismenge") + " :",
	                    rz.getLocale().formatNumber(ri.getBasismenge(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBasiseinheit())),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.bestand") + " :",
	                    rz.getLocale().formatNumber(ri.getBestand(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBestandseinheit())),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.meldebestand") + " :",
	                    rz.getLocale().formatNumber(ri.getMeldebestand(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBestandseinheit())),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.preis") + " :",
			                rz.getLocale().formatNumber(ri.getPreisMenge(), OptionFactory.NF_NORMAL) + " " +
			                rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getPreisEinheit())) + " " +
			                rz.getLocale().getString("string.ist_gleich") + " " +
			                rz.getLocale().formatNumber(ri.getPreis(), OptionFactory.NF_NORMAL) + " "  +
			                rz.getDatabase().getCurrency().dbGetCurrency( ri.getWaehrung(),true).getName(),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.lager") + " :",
	            	rz.getDatabase().getLager().dbGetLager(ri.getLager(),true).getName(),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.schwundsatz") + " :",
	            		rz.getLocale().formatNumber(ri.getSchwundsatz(), OptionFactory.NF_NORMAL) + " %",
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.artikelnummer") + " :",
	            		ri.getArtikelnummer(),
	                    datum);

	            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
	                    rz.getLocale().getString("ausgabe.losnummer") + " :",
	            		ri.getLosnummer(),
	                    datum);

	            zeilen = ri.getComment().split("\\n");
	            for (final String element : zeilen) {
		            modell.addItem(user,titel, adressen, stichworte, erstellt, geaendert,
		                    "",
		                    element,
		                    datum);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","adressen","stichworte","erstellt","geaendert","zeile_1","zeile_2","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, String.class, String.class, String.class, String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final String adressen,
                final String stichworte,
                final String erstellt,
                final String geaendert,
                final String zeile_1,
                final String zeile_2,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,titel,adressen,stichworte,erstellt,geaendert,zeile_1,zeile_2,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}
