/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressListe;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.auftrag.BedarfsItem;
import de.lunqual.rzpro.items.bestellung.BestellungsListe;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.buchung.StatistikRezepturListe;
import de.lunqual.rzpro.items.container.ContainerListe;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.datenblatt.DatenblattItem;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.formulare.FormularTypItem;
import de.lunqual.rzpro.items.formulare.FormularTypListe;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.lager.LagerBestandsListe;
import de.lunqual.rzpro.items.lager.LagerDruckListe;
import de.lunqual.rzpro.items.lager.LagerListenItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.proben.ProbenListe;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.ChangesItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.items.tafel.TafelItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.temperaturzone.rezepturZonenListe;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;


/**
 * ReportControl ist ein Interface zum JFreeReport-Programm
 * XML-Templates eines Reports werden aus der Datenbank gelesen, Locale-spezifische
 * Strings ersetzt und ein Report ausgegeben
 * @author  lunqual
 */
public class ReportFactory {

    //report-engine
    public static final String      	REPORT_PRINTERCOMMAND = "printdirect";
    public static final String     	REPORT_FOLDER = "/de/lunqual/rzpro/gfx/";

    public static final int         	REPORT_TYPE_ADRESSEN = 0;
    public static final int         	REPORT_TYPE_NOTIZ = 1;
    public static final int         	REPORT_TYPE_REZEPTUR = 2;
    public static final int         	REPORT_TYPE_RECHNEN = 3;
    public static final int				REPORT_TYPE_STAERKE=4;
    public static final int	 			REPORT_TYPE_CONTAINERLISTE=5;
    public static final int				REPORT_TYPE_LIEFERSCHEIN=6;
    public static final int				REPORT_TYPE_ETIKETTEN=7;
    public static final int				REPORT_TYPE_TAFEL=8;
    public static final int				REPORT_TYPE_STATISTIK=9;
    public static final int				REPORT_TYPE_HERSTELLUNG=10;
    public static final int				REPORT_TYPE_LAGERLISTE = 11;
    public static final int				REPORT_TYPE_LAGERBESTAND=12;
    public static final int				REPORT_TYPE_VERLAUF=13;
    public static final int				REPORT_TYPE_INVENTUR=14;
    public static final int				REPORT_TYPE_SPEZIFIKATION_FORMBLATT=15;
    public static final int				REPORT_TYPE_AUSSTATTUNG_RAW=16;
    public static final int				REPORT_TYPE_AUSSTATTUNG_CALC=17;
    public static final int				REPORT_TYPE_DATENBLATT=18;
    public static final int				REPORT_TYPE_STATISTIKLISTE=19;
    public static final int				REPORT_TYPE_PROBE=20;
    public static final int				REPORT_TYPE_ZUTATENVERZEICHNIS=21;
    public static final int				REPORT_TYPE_ERGEBNISLISTE=22;
    public static final int				REPORT_TYPE_BESTANDSWARNUNGSLISTE=23;
    public static final int				REPORT_TYPE_ADRESSEN_REZEPTURENLISTE=24;
    public static final int				REPORT_TYPE_PROBENLISTE=25;
    public static final int				REPORT_TYPE_CHANGES=26;
    public static final int				REPORT_TYPE_CHANGESLISTE=27;
    public static final int				REPORT_TYPE_LABORWERT=28;
    public static final int				REPORT_TYPE_MHD=29;
    public static final int				REPORT_TYPE_ERGEBNISLISTE_BESTAND=30;
    public static final int				REPORT_TYPE_BESTELLUNGEN=31;
    public static final int				REPORT_TYPE_TEMPERATURZONEN=32;
    public static final int				REPORT_TYPE_AUFTRAGSLISTE=33;    		
    public static final int				REPORT_TYPE_DM = 34;
    public static final int				REPORT_TYPE_KONFORM = 35;
    public static final int				REPORT_TYPE_TANKBELEGUNG = 36;
    public static final int				REPORT_TYPE_BEWERTUNG = 37;
    public static final int				REPORT_TYPE_MISCHUNG = 38;
    public static final int				REPORT_TYPE_MISCHUNGSLISTE = 39;
    public static final int				REPORT_TYPE_ZUTATENLISTE = 40;
    public static final int				REPORT_TYPE_TRACE=41;
    public static final int				REPORT_TYPE_DEPENDENCY=42;
    
    public static final int      		REPORT_DEFAULT_ADRESSE = 1;
    public static final int      		REPORT_DEFAULT_NOTIZ  = 2;
    public static final int      		REPORT_DEFAULT_REZEPTUR = 3;
    public static final int				REPORT_DEFAULT_RECHNEN = 4;
    public static final int				REPORT_DEFAULT_CONTAINERLISTE = 10;
    public static final int				REPORT_DEFAULT_LIEFERSCHEIN = 11;
    public static final int				REPORT_DEFAULT_ETIKETTEN = 12;
    public static final int				REPORT_DEFAULT_TAFEL=13;
    public static final int				REPORT_DEFAULT_STATISTIK=14;
    public static final int				REPORT_DEFAULT_HERSTELLUNG=17;
    public static final int				REPORT_DEFAULT_LAGERLISTE=18;
    public static final int				REPORT_DEFAULT_LAGERBESTAND=21;
    public static final int				REPORT_DEFAULT_VERLAUF=23;



    public static final String		REPORT_DEFAULT_PAGEFORMAT="A4";
    public static final String		REPORT_DEFAULT_MARGIN_TOP="28";
    public static final String		REPORT_DEFAULT_MARGIN_BOTTOM="28";
    public static final String		REPORT_DEFAULT_MARGIN_LEFT="72";
    public static final String		REPORT_DEFAULT_MARGIN_RIGHT="28";

    public static final String		REPORT_DEFAULT_LANDSCAPE_MARGIN_TOP="72";
    public static final String		REPORT_DEFAULT_LANDSCAPE_MARGIN_BOTTOM="28";
    public static final String		REPORT_DEFAULT_LANDSCAPE_MARGIN_LEFT="28";
    public static final String		REPORT_DEFAULT_LANDSCAPE_MARGIN_RIGHT="28";


    public static final String		REPORT_DEFAULT_PAGEHEADER_BACKGROUND="#DFDFDF";
    public static final String		REPORT_DEFAULT_PAGEFOOTER_BACKGROUND="#DFDFDF";
    public static final String		REPORT_DEFAULT_REPORTHEADER_BACKGROUND="#DFDFDF";
    public static final String		REPORT_DEFAULT_REPORTFOOTER_BACKGROUND="#DFDFDF";
    public static final String		REPORT_DEFAULT_HIGHLIGHT_BACKGROUND="#DDDDFF";
    public static final String      	REPORT_DEFAULT_HIGHLIGHT_STATISTIK_ABGANG = "#EEEEEE";
    public static final String      	REPORT_DEFAULT_COLOR_STATISTIK_ABGANG = "#FF0000";
    public static final String      	REPORT_DEFAULT_COLOR_STATISTIK_ZUGANG = "#00FF00";
    public static final int				REPORT_DEFAULT_ETIKETTEN_FONTSIZE=8;

    RzPro                   rz;
    String[]				reportTypes;
    /** Creates a new instance of Report */
    public ReportFactory(RzPro r) {
        rz = r;
        reportTypes = new String[] {
        	    "Adresse","Notiz","Rezeptur","Rechnen","Alkoholstärke",
        	    "Containerliste","Lieferschein","Etiketten","Alkoholtafel","Statistik",
        	    "Herstellung","Lagerliste","Lagerbestand","Verlauf","Inventur","Spezifikation Formblatt",
        	    "Ausstattung","Ausstattung berechnet","Datenblatt","Statistikliste","Probe",
        	    "Zutatenverzeichnis","Ergebnisliste","Bestandswarnungsliste","Adressen/Rezepturen","Probenliste",
        	    "Änderungen","Änderungenliste","Laborwerte","MHD","Ergebnisliste-Bestand",
        	    "Bestellungen","Temperaturzonen","Auftragsliste","Dichtemessungen","Konformitätsliste",
        	    "Tankbelegungsliste","Bewertung","Mischung","Mischungsliste","Zutatenliste",
        	    "Rückverfolgung","Abhängige Rezepturen"
            };
    }

    public ArrayList<FormularTypItem> getReportTypes() {
    	FormularTypListe ret = new FormularTypListe();
    	for(int i=0;i<reportTypes.length;i++) {
    		ret.add(new FormularTypItem(i,reportTypes[i]));
    	}
    	ret.sort();
    	return ret;
    }
    
    
    public String getReportType(int id) {
    	String ret = "";
    	if(id >=0 && id <reportTypes.length) {
    		ret = reportTypes[id];
    	}
    	return ret;
    }
    
    
    private String safeFilename(String filename) {
    	return filename
    			.replaceAll("\\\\","_")
    			.replaceAll("\\[","_")
    			.replaceAll("\\]","_")
    			.replaceAll("\\{","_")
    			.replaceAll("\\}","_")
    			.replaceAll("\\(","_")
    			.replaceAll("\\)","_")
    			.replaceAll("\\|","_")
    			.replaceAll("/","_")
    			.replaceAll(" ","_")
    			.replaceAll(":","_")
    			.replaceAll("\"","_")
    			.replaceAll("\\s+","_")
    			.replaceAll("_+","_")
    			;
    }
    
    /** gibt einen Report mit der AdressenListe aus (Kann auch eine einzelne Adresse sein)
     * @param al Adressliste
     *
     */
    public void reportAdresse(AdressListe al,Window w){
        rz.setWaitCursor(w);
        new AdressenAusgabeDrucken(rz,al,"report.adresse",w).run();
    }

    
    /**
     * gibt die ID des ersten Reports eines typs zurück
     * @param typ
     * @return
     */
    public int getDefaultReport(int typ) {
    	final int ret = 0;

    	return ret;
    }
    /**
     * gibt einen Notiz-Report aus
     * @param aKey
     */
    public void notizReport(int aKey,Window w){
        rz.setWaitCursor(w);
       new NotizAusgabeDrucken(rz,Integer.valueOf(aKey),"report.notiz",w).run();
    }

    /**
     * gibt einen Rezeptur-Verweis-Report aus
     * @param aKey
     */
    public void rezepturReport(int aKey,Window w){
        rz.setWaitCursor(w);
        new RezepturAusgabeDrucken(rz,Integer.valueOf(aKey),"report.rezeptur",w).run();
    }

    /** gibt einen Rechen/Kalkulations-Report aus
     *
     * @param ri RechenItem, dass ausgegeben werden soll
     */
    public void rechenReport(RechenItem ri,boolean vorschau,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new RechenBlattDrucken(rz,ri,"report.rechnen",vorschau,w,duplex).run();
    }
    
    
    public void rechenAuswahlReport(RechenItem ri, Window w,String report) {
        rz.setWaitCursor(w);
        new RechenBlattDrucken(rz,ri,report,false,w,false).run();
    }

    public void rechenAuswahlReportPDF(RechenItem ri, Window w,String report,String filename) {
        rz.setWaitCursor(w);
        new RechenBlattDrucken(rz,ri,report,false,w,false).pdf(safeFilename(filename), w);
    }

    /** gibt einen Aufstärken/hearbsetzen-Report aus
     * das ist das gleiche wie ein Rechenblatt, nur dass für dieses
     * Fenster eine eigene Vorgabe für das zu verwendende
     * Formular existiert
     * @param ri RechenItem, dass ausgegeben werden soll
     */
    public void staerkeReport(RechenItem ri,Window w) {
        rz.setWaitCursor(w);
        new RechenBlattDrucken(rz,ri,"report.staerke",false,w,false).run();
    }

    /** gibt eine Containerliste aus
     * @param ci Containerliste
     */
    public void containerListeReport(ContainerListe cl,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new ContainerListeDrucken(rz,cl,"report.containerliste",w,duplex).run();
    }
    /** gibt einen Lieferschein aus
     * @param li LieferscheinItem
     */
    public void lieferscheinReport(LieferscheinItem li,Window w) {
        rz.setWaitCursor(w);
        new LieferscheinAusgabeDrucken(rz,li,"report.lieferschein",w).run();
    }
    /** gibt eine EtikettenListe aus
     * @param li LieferscheinItem
     */
    public void etikettenReport(EtikettenListe etiketten,Window w ){
        rz.setWaitCursor(w);
        new EtikettenDrucken(rz,etiketten,"",w).run();
    }

    /** gibt eine EtikettenListe aus
     * @param li LieferscheinItem
     */
    public void TafelReport(TafelItem ti,Window w) {
        rz.setWaitCursor(w);
        new TafelDrucken(rz,ti,"report.tafel",w).run();
    }

    /** gibt einen StatistikReport aus
     */
    public void StatistikReport(BuchungsListe bl,SaldenItem s,Window w,int auswahl,int rezeptur,int mode ,Date von, Date bis,String benutzer,String losnummer,boolean duplex) {
        rz.setWaitCursor(w);
        new StatistikDrucken(rz,bl,s,"report.statistik",w, auswahl,rezeptur, mode , von, bis, benutzer,losnummer,duplex).run();;
    }
    /** gibt eine einzelne Herstellung aus
     * @param hi herstellungsItem
     */
    public void HerstellungReport(HerstellungsItem hi,Window w ){
        if(hi != null) {
            rz.setWaitCursor(w);
            new HerstellungDrucken(rz,hi,"report.herstellung",w).run();
        }
    }

    /** gibt eine Lagerliste aus
     * @param hi herstellungsItem
     */
    public void LagerListenReport(LagerDruckListe ld,LagerListenItem ll ,boolean vorschau,Window w ,boolean duplex){
        if(ld != null) {
            // der Krempel ist NICHT thread-safe !!!
            // es werden mehrere Reports nacheinander mit derselben Datenstruktur
            // aufgerufen, mit Threads geht das in die Hose !!!
            // deshalb wird das nicht in separaten Threads gestartet, sondern schön nacheinander
            rz.setWaitCursor(w);
            final LagerListeDrucken druck = new LagerListeDrucken(rz,ld,ll,"report.lagerliste",vorschau,w,duplex);
            druck.run();
        }
    }

    /** Lagerbestandsliste
     * @param lb LagerBestandsListe
     */
    public void LagerBestandsReport(LagerBestandsListe lb,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new LagerBestandDrucken(rz,lb,"report.lagerbestand",w,duplex).run();
    }

    /** gibt einen VerlaufsReport aus
     * @param bl Buchungsliste
     */
    public void VerlaufReport(BuchungsListe bl,String los,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new VerlaufDrucken(rz,bl,"report.verlauf",los,w,duplex).run();;
    }


    /** gibt eine Inventur aus
     * @param ii InventurITem
     */
    public void InventurReport(InventurItem ii,boolean vorschau,String order,String filter,Window w ,boolean duplex){
        if(ii != null) {
            rz.setWaitCursor(w);
            new InventurDrucken(rz,ii,"report.inventur",vorschau,order,filter,w, duplex).run();
        }
    }

    /** gibt ein Spezifikations_Formblatt aus
     * @param spf FormblattItem
     */
    public void SPFormblattReport(SPFormblattItem spf,RechenItem ri,Window w ){
        if(spf != null) {
            rz.setWaitCursor(w);
            rz.getOptionFactory().setOption("report.spf_formblatt",rz.getDatabase().getDeklarationen().getFormBlattFormular());
            new SpezifikationFormblattDrucken(rz,spf,ri,"report.spf_formblatt",w).run();
        }
    }
    public void SPFormblattReportPDF(SPFormblattItem spf,RechenItem ri,Window w,String filename ){
        if(spf != null) {
            rz.setWaitCursor(w);
            rz.getOptionFactory().setOption("report.spf_formblatt",rz.getDatabase().getDeklarationen().getFormBlattFormular());
            new SpezifikationFormblattDrucken(rz,spf,ri,"report.spf_formblatt",w).pdf(rz.getLocale().getString("report.formblatt_prefix") + safeFilename(filename), w);
        }
    }


    /** gibt eine Ausstattung/RAW aus
     * @param ai AusstattungsItem
     */
    public void AusstattungRawReport(AusstattungsItem ai,Window w ){
        if(ai != null) {
            final ArrayList<Integer>liste = rz.getDatabase().getAusstattung().getAusstattungsReportFormular(REPORT_TYPE_AUSSTATTUNG_RAW);
            if((liste != null) && !liste.isEmpty()) {
                rz.setWaitCursor(w);
	            rz.getOptionFactory().setOption("report.ausstattung_raw",liste.get(0));
	            new AusstattungRawDrucken(rz,ai,"report.ausstattung_raw",w).run();
            }
        }
    }

    public void StatistikListeReport( StatistikRezepturListe sl,Window w ){
    	if (sl != null) {
            rz.setWaitCursor(w);
            new StatistiklisteDrucken(rz,sl,"report.statistikliste",w).run();
    	}
    }

    /** gibt ein Ausstattung/Kalkulation aus
     * @param ai AusstattungsItem
     */
    public void AusstattungCalcReport(AusstattungsItem ai,CurrencyItem waehrung,Window w ){
        if(ai != null) {
                rz.setWaitCursor(w);
	            new AusstattungCalcDrucken(rz,ai,"report.ausstattung_calc",waehrung,w).run();
        }
    }


    /** gibt ein Sicherheitsdatenblatt aus
     * @param di DatenblattItem
     */
    public void DatenbBlattDrucken (DatenblattItem di,boolean pdf,Window w ){
        if(di != null) {
                rz.setWaitCursor(w);
	            final DatenblattDrucken db = new DatenblattDrucken(rz,di,"report.datenblatt",w);
	            if(pdf) {
	            	db.pdf(rz.getLocale().getString("reportfactory.datenblatt_pdf") + di.getName().replaceAll("\\s+", "_"),w);
	            } else {
	            	db.run();
	            }
        }
    }

    
    public void DMReport(ArrayList<DMItem> liste,Window w ){
        if(liste != null && !liste.isEmpty()) {
            rz.setWaitCursor(w);
            new DMDrucken(rz,liste,"report.dm",w).run();
        }
    }
    /**
     * gibt einen Proben-Report aus
     * @param aKey
     */
    public void probenReport(int aKey,Window w){
        rz.setWaitCursor(w);
       new ProbeDrucken(rz,Integer.valueOf(aKey),"report.probe",w).run();
    }

    /**
     * gibt einen ProbenListen-Report aus
     * @param aKey
     */
    public void probenListenReport(ProbenListe pl,Window w,boolean duplex){
        rz.setWaitCursor(w);
       new ProbenListeDrucken(rz,pl,"report.probenliste",w,duplex).run();
    }


    public void changesListenReport(ArrayList<ChangesItem> liste,boolean vorschau,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.changesliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_CHANGES, "report.changesliste"));
       new ChangesDrucken(rz,liste,"report.changesliste",vorschau,w).run();
    }
    
    
    public void changesReport(ArrayList<ChangesItem> liste,boolean vorschau,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.changes",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_CHANGES, "report.changes"));
       new ChangesDrucken(rz,liste,"report.changes",vorschau,w).run();
    }

    public void laborwerteReport(LaborwertValueListe liste,Window w,LaborwertItem lw,RechenItem ri){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.laborwerte",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_LABORWERT, "report.laborwerte"));
       new LaborwertDrucken(rz,liste,"report.laborwerte",w,lw,ri).run();
    }
    
    public void mhdReport(boolean sort,boolean reverse,boolean datum,Calendar von, Calendar bis,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.mhd",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_MHD, "report.mhd"));
       new MHDDrucken(rz,null,sort,reverse,datum,von,bis,"report.mhd",w).run();
    }
    
    public void konformReport(boolean sort,boolean reverse,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.konform",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_KONFORM, "report.konform"));
       new KonformDrucken(rz,null,sort,reverse,"report.konform",w).run();
    }
    
    public void temperaturZonenReport(rezepturZonenListe liste,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.tzone",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_TEMPERATURZONEN, "report.tzone"));
       new TemperaturzonenDrucken(rz,liste,"report.tzone",w).run();
    }
    
    public void auftragslistenReport(Auftragsliste liste,boolean eigene,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.auftragsliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_AUFTRAGSLISTE, "report.auftragsliste"));
       new AuftragslisteDrucken(rz,liste,eigene,"report.auftragsliste",w).run();
    }
    
    /**
     * gibt einen Proben-Report aus
     * @param aKey
     */
    public void zutatenverzeichnisReport(ZutatenverzeichnisListe zl,Window w){
        rz.setWaitCursor(w);
       final ZutatenverzeichnisDrucken zd =new ZutatenverzeichnisDrucken(rz,zl,"report.zutatenverzeichnis",w);
       zd.run();
    }
    public void zutatenverzeichnisReportPDF(ZutatenverzeichnisListe zl,Window w){
        rz.setWaitCursor(w);
       final ZutatenverzeichnisDrucken zd =new ZutatenverzeichnisDrucken(rz,zl,"report.zutatenverzeichnis",w);
       zd.pdf(zl.getTitel().replaceAll("\\s+", "_"),w);
    }

    /**
     * gibt einen Notiz-Report aus
     * @param aKey
     */
    public void ergebnislisteReport(int aKey,Window w,ArrayList liste){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.ergebnisliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_ERGEBNISLISTE, "report.ergebnisliste"));
       new ErgebnislisteAusgabeDrucken(rz,Integer.valueOf(aKey),"report.ergebnisliste",w,liste).run();
    }
    
    public void ergebnislisteBestandReport(int aKey,Window w,ErgebnisListe liste,boolean bestand,boolean duplex){
       rz.setWaitCursor(w);
       new ErgebnislisteBestandDrucken(rz,Integer.valueOf(aKey),"report.ergebnisliste_bestand",w,liste,bestand,duplex).run();
    }
    
    public void bestellungenReport(Window w,BestellungsListe liste){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.bestellungsliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_BESTELLUNGEN, "report.bestellungsliste"));
       new BestellungslisteDrucken(rz,0,"report.bestellungsliste",w,liste).run();
    }
    
    public void bestandswarnungsReport(int aKey,Window w){
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.bestandswarnungsliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_BESTANDSWARNUNGSLISTE, "report.bestandswarnungsliste"));
        new BestandswarnungslisteDrucken(rz,Integer.valueOf(aKey),"report.bestandswarnungsliste",w).run();
    }
    
    public void adressenRezepturenlisteReport(AdressListe liste,Window w) {
        rz.setWaitCursor(w);
        rz.getOptionFactory().setOption("report.adressen_rezepturenliste",rz.getDatabase().getReport().getDefaultReport(REPORT_TYPE_ADRESSEN_REZEPTURENLISTE, "report.adressen_rezepturenliste"));
        new AdressenRezepturenlisteDrucken(rz,liste,"report.adressen_rezepturenliste",w).run();
    }
    
    public void tankBelegungsReport(ArrayList<tankItem> liste,boolean vorschau,boolean alle,boolean lager,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new TankbelegungDrucken(rz,liste,"report.tankbelegung",vorschau,alle,lager,w,duplex).run();
    }
    
    public void mischungDrucken(MischungsItem mi,boolean vorschau,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new MischungDrucken(rz,mi,"report.mischung",vorschau,w,duplex).run();
    }
    
    public void mischungsListeDrucken(ArrayList<MischungsHeaderItem> liste,boolean vorschau,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new MischungslisteDrucken(rz,liste,"report.mischungsliste",vorschau,w,duplex).run();
        
    }
    
    public void bewertungDrucken(BewertungsItem bi,Window w) {
        rz.setWaitCursor(w);
    	if(bi != null) {
    		new BewertungDrucken(rz,bi,"report.bewertung",w).run();
    	}
    	rz.setFreeCursor(w);
    }
    
    public void bewertungPDF(BewertungsItem bi,Window w) {
        rz.setWaitCursor(w);
    	if(bi != null) {
    		new BewertungDrucken(rz,bi,"report.bewertung",w).pdf(bi.getBezeichnung().replaceAll("\\s+", "_") + "_" + bi.getLosnummer().replaceAll("\\s+", "_"),w);;
    	}
    	rz.setFreeCursor(w);
    }
    public void zutatenListeDrucken(BedarfsItem bi ,boolean vorschau,Window w ){
        if(bi != null) {
            rz.setWaitCursor(w);
            final ZutatenlisteDrucken druck = new ZutatenlisteDrucken(rz,bi,"report.zutatenliste",vorschau,w);
            druck.run();
        }
    }
    
    public void TraceDrucken(TraceItem tri,boolean vorschau,Window w,boolean duplex) {
        rz.setWaitCursor(w);
        new TraceDrucken(rz,tri,"report.trace",vorschau,w,duplex).run();
    }
    
    public void dependencyListeDrucken (DependencyListe liste,boolean vorschau,Window w) {
        if(liste != null && liste.size()>0) {
                rz.setWaitCursor(w);
	            new DependencyDrucken(rz,(Object)liste,"report.dependency_liste",vorschau,w).run();;
        	}
    	}
   
}
