/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rechnen.RechenZeile;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class RechenBlattDrucken extends ReportAusgabe {

    RechenItem	ri;
    tableModel		modell;
    boolean vorschau=false;
    boolean duplex = false;
    
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public RechenBlattDrucken(RzPro r,Object reportData,String optionKey,boolean vorschau,java.awt.Window w,boolean duplex) {
        super(r, reportData,optionKey,w);
        rz = r;
        this.optionKey = optionKey;
        ri = (RechenItem)reportData;
        this.vorschau = vorschau;
        modell =null;
        this.duplex=duplex;
        
    }

    private String getLaborwerte(RechenItem ri) {
    	String ret = "";
    	double v=0.0;
    	ArrayList <LaborwertValueItem> liste = rz.getDatabase().getLaborwerte().getValue(ri.getRezeptur().getID());
    	if(liste!=null && !liste.isEmpty()) {
    		ret+= rz.getLocale().getString("ausgabe.rechenblatt_sonstige_werte");
    		for(LaborwertValueItem vi:liste) {
	    			EinheitsItem e2=rz.getDatabase().getEinheiten().getGrundEinheit(vi.getEinheit2());
	    			EinheitsItem eD=rz.getDatabase().getEinheiten().getEinheit(vi.getAusgabeeinheit());
	    			double faktor=1/rz.getDatabase().getEinheiten().convert(1,ri.getStaerke(),ri.getGesamtLitergewicht(),e2,eD);
	
	    			ret += " - " + vi.getLbwBezeichnung() + " :";
	    			if(vi.isFix()) {
	    				v = vi.getValue();
	    			} else {
	        			v =vi.getValue() * faktor;
	    			}
	    			ret += rz.getLocale().formatNumber(v,OptionFactory.NF_NORMAL) + " ";
	    			if(vi.isFix()) {
	    				ret +="";
	    			} else {
	    				ret += vi.getStrEinheit1() + " / " + rz.getDatabase().getEinheiten().getEinheit(vi.getAusgabeeinheit()).getName();
	    			}
	    			ret += "\n";
    		}
    	}
    	return ret + "\n";
    }
    
    /** liefert ein TableModel einer Rezeptur/Verweis
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    public void createModel(){
        int i;
        Integer flag;
        String user="",titel="",zartikelnummer="",zGrundpreis="",wassergrundpreis="",steuergrundpreis="",
		euro="",waehrung="",gr100ml="",zLosnummer="",kgPerLiter="",ztitel="",zeinheit="",zBestandsEinheit,zExtraktfrei="",
		kalkulationWarnung="",saeureText="",deklarationenText="",tanknummer="";


        Double staerke,gesamtLiter,gesamtKg,gesamtLA,zmenge,zstaerke,
        	zliter,zkg,zla,zlitergewicht,
			zBestand,zMeldebestand,zExtrakt,zTrockenmasse,
			zLiterExtraktfrei,zStaerkeExtraktfrei,zKgExtrakfrei,
			summeLiter,summeKg,summeLA,summeExtraktfreiLiter,summeExtraktfreiKg,
			kurs,litergewicht,extraktprozent,/*extraktgramm,*/
			wasserT,wasserTKg,kontraktion,kontraktionKg,wasserP,wasserPKg,
			zBrennwertAlkohol,zBrennwertAlkoholfrei,
			brennwertKj,brennwertKc,brennwertBe,
			literPerKg,
			grammAlkPerKg,grammAlkPerLiter,weinsaeure,saeure,
			brennwertKjG,brennwertKcG,brennwertBeG,
			alkoholGrammExtraktfrei,
			brennwertKj20,brennwertKc20,brennwertBe20;
			

        Double as_gebindegroesse =0.0;
        BigDecimal as_einzelpreis=new BigDecimal(0);
        BigDecimal as_inhalt_ohne_steuer =new BigDecimal(0);
        BigDecimal as_inhalt_mit_steuer =new BigDecimal(0);
        BigDecimal as_gesamtpreis_ohne_steuer = new BigDecimal(0);
        BigDecimal as_gesamtpreis_mit_steuer = new BigDecimal(0);
        Double as_gebinde_gesamtgewicht = 0.0;

        int as_anzahl = 0;

        Double as_charge_gesamtgewicht=0.0;
        BigDecimal as_chargenpreis_ohne_steuer=new BigDecimal(0);
        BigDecimal as_chargenpreis_mit_steuer=new BigDecimal(0);

        if(ri.getAusstattung()==null) {
        		ri.setAusstattung(rz.getDatabase().getAusstattung().getDefaultAusstattung());
        }
        if(ri.getAusstattung()!=null) {
        		as_gebindegroesse = ri.getAusstattung().getGebindegroesse();
	         as_einzelpreis = ri.getAusstattung().getPreis();
	         as_inhalt_ohne_steuer = ri.getLiterOhneSteuer().multiply(new BigDecimal(ri.getAusstattung().getGebindegroesse()));
	         as_inhalt_mit_steuer = ri.getLiterMitSteuer().multiply(new BigDecimal(ri.getAusstattung().getGebindegroesse()));
	         as_gesamtpreis_ohne_steuer = ri.getAusstattung().getPreis().add(as_inhalt_ohne_steuer);
	         as_gesamtpreis_mit_steuer = ri.getAusstattung().getPreis().add(as_inhalt_mit_steuer);

	         as_gebinde_gesamtgewicht = ri.getAusstattung().getGebindeGewicht() + (ri.getGesamtLitergewicht() * ri.getAusstattung().getGebindegroesse());
	         as_anzahl = 0;
	         try {
	        	 as_anzahl = (int)(ri.getGesamtLiter() / ri.getAusstattung().getGebindegroesse());
	         } catch(final Exception e) {}
	         as_charge_gesamtgewicht = as_gebinde_gesamtgewicht * as_anzahl;
	         as_chargenpreis_ohne_steuer = as_gesamtpreis_ohne_steuer.multiply(new BigDecimal(as_anzahl));
	         as_chargenpreis_mit_steuer = as_gesamtpreis_mit_steuer.multiply(new BigDecimal(as_anzahl));
        }
		BigDecimal summeKalkulation,perLiterEx,perKgEx,perLAEx,perLiterInc,perKgInc,perLAInc,
			summeOhneSteuer,summeMitSteuer,	wasserpreis,steuerpreis,zPreis;

        Double extraktgramm;

        final tableModel modell = new tableModel();
        if (modell != null) {
	        final Date datum = new Date();
	        if(ri.getAusstattung() != null) {
	        	ri.getAusstattung().rechnen(ri.getSummeLiter(),ri.getWaehrung());
	        }
	        titel = ri.getRezeptur().getTitel();
	        user = rz.getDatabase().dbGetUser();
	        staerke = Double.valueOf(ri.getStaerke());
	        gesamtLiter=Double.valueOf(ri.getGesamtLiter());
	        gesamtKg=Double.valueOf(ri.getGesamtKg());
	        gesamtLA=Double.valueOf(ri.getGesamtLA());
			summeLiter=Double.valueOf(ri.getSummeLiter());
			summeKg=Double.valueOf(ri.getSummeKg());
			summeLA=Double.valueOf(ri.getSummeLA());
			summeExtraktfreiLiter=Double.valueOf(ri.getSummeExtraktfreiLiter());
			summeExtraktfreiKg=Double.valueOf(ri.getSummeExtraktfreiKg());
			summeKalkulation=ri.getSummeKalkulation();
			kurs= Double.valueOf(ri.getWaehrung().getRate());
			euro=ri.getEuro().getShortName();
			waehrung=ri.getWaehrung().getShortName();
			litergewicht=Double.valueOf(ri.getGesamtLitergewicht());
			extraktprozent=Double.valueOf(ri.getExtraktMassenProzent());
			extraktgramm=  Double.valueOf(ri.getGesamtExtrakt());  //Double.valueOf(ri.getGesamtExtrakt());
			wasserT=Double.valueOf(ri.getWasserT());
			wasserTKg=Double.valueOf(ri.getWasserT() * rz.getTafelFactory().Litergewicht(0));
			kontraktion=Double.valueOf(ri.getKontraktion());
			kontraktionKg=Double.valueOf(ri.getKontraktion() * rz.getTafelFactory().Litergewicht(0));
			wasserP=Double.valueOf(ri.getWasserP());
			wasserPKg=Double.valueOf(ri.getWasserP() * rz.getTafelFactory().Litergewicht(0));
			wassergrundpreis=ri.getWasserGrundpreis();
			wasserpreis=ri.getVerschnittwasserPreis();
			steuergrundpreis=ri.getSteuerGrundpreis();
			steuerpreis=ri.getSteuer();
			perLiterEx=ri.getLiterOhneSteuer();
			perKgEx=ri.getKgOhneSteuer();
			perLAEx=ri.getLaOhneSteuer();
			perLiterInc=ri.getLiterMitSteuer();
			perKgInc=ri.getKgMitSteuer();
			perLAInc=ri.getLaMitSteuer();
	        summeOhneSteuer=ri.getSummeOhneSteuer();
	        summeMitSteuer=ri.getSummeMitSteuer();
	        kgPerLiter = rz.getDatabase().getEinheiten().dbGetLitergewichtString();
	        gr100ml = rz.getDatabase().getEinheiten().dbGetGramm100mlString();
	        brennwertKj=Double.valueOf(ri.getBrennwert());
	        brennwertKc=Double.valueOf(ri.getBrennwert() * rz.getOptionFactory().getDouble("brennwert.kj_to_kk"));
	        brennwertBe=Double.valueOf(ri.getBrennwert() * rz.getOptionFactory().getDouble("brennwert.kj_to_be"));
	        
	        brennwertKj20 = brennwertKj / 5;
	        brennwertKc20 = brennwertKc / 5;
	        brennwertBe20 = brennwertBe / 5;
	        
	        brennwertKjG=Double.valueOf(ri.getBrennwertG());
	        brennwertKcG=Double.valueOf(ri.getBrennwertG() * rz.getOptionFactory().getDouble("brennwert.kj_to_kk"));
	        brennwertBeG=Double.valueOf(ri.getBrennwertG() * rz.getOptionFactory().getDouble("brennwert.kj_to_be"));
	                
	        literPerKg=Double.valueOf(1/ri.getGesamtLitergewicht());
	        grammAlkPerKg = Double.valueOf(ri.getAlkoholGramm());
	        grammAlkPerLiter = Double.valueOf(ri.getAlkoholGrammPerLiter());
	        alkoholGrammExtraktfrei = Double.valueOf(ri.getAlkoholGrammExtraktfrei());
	        weinsaeure = Double.valueOf(ri.getGesamtAcid());
	        saeure = Double.valueOf(ri.getAcidOther());
	        saeureText = rz.getLocale().getString("report.spezifikation.saeure_label").replaceAll("%s", ri.getAcidDest().getName());
	        deklarationenText = getLaborwerte(ri) +  rz.getLocale().getString("ausgabe.rechenblatt_deklarationen")+
	        		rz.getTafelFactory().getFlammpunkt(ri.getStaerke())+"\n"+
	        			ri.getRezeptur().getDeklarationenListe().toVerboseDeklarationenString() + "\n"  + 
	        			ri.getDeklarationenAlle().toVerboseDeklarationenString()  +
	        			(ri.isSpezifikationTextDrucken()?"\n" + ri.getRezeptur().getSpezifikation_text().trim():"");
	        if(ri.isPreisWarnung()) {
	        	kalkulationWarnung=rz.getLocale().getString("rechnen.error_zutatenpreise_fehlen");
	        } else {
	        	kalkulationWarnung="";
	        }
	        for(i = 0 ; i < ri.getZeilenListe().size();i++) {
	            final RechenZeile z = ri.getZeilenListe().getItem(i);
	            ztitel = z.getBezeichnung();
	            if(z.isRechnen() || z.isStern()) {
					tanknummer=!z.getTank().equals("")?" " +rz.getLocale().getString("rezeptur.ausgabe_tanknummer").replaceAll("%s",z.getTank()):"";
	                zmenge= Double.valueOf(z.getMenge());
	                zeinheit= z.getEinheit().getName();
	                zstaerke=Double.valueOf(z.getStaerke());
	                zliter=Double.valueOf(z.getLiter());
	                zkg=Double.valueOf(z.getKg());
	                zla= Double.valueOf(z.getLa());
	                zlitergewicht=Double.valueOf(z.getLitergewicht());
	                zartikelnummer=z.getRezeptur().getArtikelnummer();
	        		zLosnummer=z.getRezeptur().getLosnummer()  + tanknummer;
	        		zBestand=Double.valueOf(z.getRezeptur().getBestand());
	        		zBestandsEinheit  = rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(z.getRezeptur().getBestandseinheit())).getName();
	        		zMeldebestand = Double.valueOf(z.getRezeptur().getMeldebestand());
	        		zGrundpreis= z.getGrundPreis();
	        		zPreis= z.getKalkulationBetrag();
	        		zExtraktfrei= (rz.isZero(z.getExtrakt())) ? rz.getLocale().getString("string_extraktfrei") : rz.getLocale().getString("string_extrakthaltig");
	        		zExtrakt= Double.valueOf(z.getRezeptur().getExtrakt());
	        		zTrockenmasse=Double.valueOf(z.getExtrakt());
	    			zLiterExtraktfrei = Double.valueOf(z.getExtraktfreiLiter());
					zStaerkeExtraktfrei = Double.valueOf(z.getExtraktfreiStaerke());
					zKgExtrakfrei =Double.valueOf(z.getExtraktfreiKg());
					zBrennwertAlkohol = Double.valueOf(z.getBrennwertAlkohol());
					zBrennwertAlkoholfrei = Double.valueOf(z.getBrennwertAlkoholfrei());
	            } else {
	                zmenge= Double.valueOf(0);
	                zstaerke=Double.valueOf(0);
	                zliter=Double.valueOf(0);
	                zkg=Double.valueOf(0);
	                zla= Double.valueOf(0);
	                zlitergewicht=Double.valueOf(0);
	        		zBestand=Double.valueOf(0);
	        		zMeldebestand = Double.valueOf(0);
	        		zPreis= z.getKalkulationBetrag();
	        		zExtrakt= Double.valueOf(0);
	        		zTrockenmasse=Double.valueOf(0);
	    			zLiterExtraktfrei = Double.valueOf(0);
					zStaerkeExtraktfrei = Double.valueOf(0);
					zKgExtrakfrei =Double.valueOf(0);
	            	zartikelnummer="";zGrundpreis="";
					zLosnummer="";zeinheit="";zBestandsEinheit="";zExtraktfrei="";
					zBrennwertAlkohol = Double.valueOf(0);
					zBrennwertAlkoholfrei = Double.valueOf(0);
					tanknummer="";
	            }
	            if((ri.getZeilenListe().getItem(i).isRechnen() || ri.getZeilenListe().getItem(i).isStern())){
	            	flag = Integer.valueOf(z.getEinheit().getTyp());
	            } else {
            		flag = Integer.valueOf(RzPro.EINHEIT_COMMENT);
	            	if (ztitel != null && !ztitel.trim().equals("") && ztitel.trim().startsWith("!!")){
	            		flag = Integer.valueOf(RzPro.EINHEIT_COMMENT_WARNING);
	            		ztitel = ztitel.replaceAll("!!", "");
	            	}
	            }
	            modell.addItem(
	                    flag,user,titel,staerke,gesamtLiter,gesamtKg,gesamtLA, //7
	                    zmenge,zeinheit,ztitel,zstaerke,zliter,zkg,zla, //16
	                    zlitergewicht, zartikelnummer, //18
	        			zLosnummer,zBestand,zMeldebestand,zBestandsEinheit, //22
						zGrundpreis,zPreis,zExtraktfrei,zExtrakt,zTrockenmasse, //27
						zLiterExtraktfrei,zStaerkeExtraktfrei,zKgExtrakfrei,
						summeLiter,summeKg,summeLA,summeExtraktfreiLiter,summeExtraktfreiKg,
						summeKalkulation,kurs,euro,waehrung,litergewicht,extraktprozent,extraktgramm,
						wasserT,wasserTKg,kontraktion,kontraktionKg,wasserP,wasserPKg,
						wassergrundpreis,wasserpreis,steuergrundpreis,steuerpreis,
						perLiterEx,perKgEx,perLAEx,perLiterInc,perKgInc,perLAInc,
						summeOhneSteuer,summeMitSteuer,kgPerLiter,gr100ml,
	                    kalkulationWarnung, datum,
	                    zBrennwertAlkohol,zBrennwertAlkoholfrei,
	                    brennwertKj,brennwertKc,brennwertBe,
	                    literPerKg,
	                    grammAlkPerKg,grammAlkPerLiter,
	                    weinsaeure,saeure,saeureText,deklarationenText,
	                    ri.getAusstattung() == null?"":ri.getAusstattung().getTitel(),
	                    as_gebindegroesse,
	                    as_einzelpreis,
	                    as_inhalt_ohne_steuer,
	                    as_inhalt_mit_steuer,
	                    as_gesamtpreis_ohne_steuer,
	                    as_gesamtpreis_mit_steuer,
	                    as_anzahl,
	                    as_gebinde_gesamtgewicht,
	                    as_charge_gesamtgewicht,
	                    as_chargenpreis_ohne_steuer,
	                    as_chargenpreis_mit_steuer,
	        			brennwertKjG,
	        			brennwertKcG,
	        			brennwertBeG,
	        			alkoholGrammExtraktfrei,
	        			brennwertKj20,
	        			brennwertKc20,
	        			brennwertBe20
	                    );
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");

        }
    }

	public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	boolean dp = (duplex || ri.isDuplex()?true:false);
	            	if(dp) {
	            		printDirectlyDuplex(report);
	            	} else {
						printDirectly(report);
		            }	
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "flag", "user","titel","staerke","gesamtLiter","gesamtKg","gesamtLA", //1-7
                "zMenge","zEinheit","zTitel","zStaerke","zLiter","zKg","zLA",//2-7
                "zLitergewicht", "zArtikelnummer",//3-2
				"zLosnummer","zBestand","zMeldebestand","zBestandsEinheit","zGrundpreis","zPreis","zExtraktfrei","zExtrakt","zTrockenmasse",//4-9
				"zLiterExtraktfrei","zStaerkeExtraktfrei","zKgExtrakfrei",//5-3
				"summeLiter","summeKg","summeLA","summeExtraktfreiLiter","summeExtraktfreiKg",//6-5
				"summeKalkulation","kurs","euro","waehrung","litergewicht","extraktprozent","extraktgramm",//7-7
				"wasserT","wasserTKg","kontraktion","kontraktionKg","wasserP","wasserPKg",//8-6
				"wassergrundpreis","wasserpreis","steuergrundpreis","steuerpreis",//9-4
				"perLiterEx","perKgEx","perLAEx","perLiterInc","perKgInc","perLAInc",//10-6
				"summeOhneSteuer","summeMitSteuer","kgPerLiter","gr100ml",//11-4
                "kalkulation_warnung","datum",//12,
                "zBrennwertAlkohol","zBrennwertAlkoholfrei",
                "brennwertKj","brennwertKc","brennwertBe",
                "literPerKg",
                "grammAlkPerKg","grammAlkPerLiter",
                "weinsaeure","saeure","saeureText","deklarationenText",
                "as_bezeichnung","as_gebindegroesse","as_einzelpreis",
                "as_inhalt_preis_ohne_steuer","as_inhalt_preis_mit_steuer",
                "as_gesamtpreis_ohne_steuer","as_gesamtpreis_mit_steuer",
                "as_anzahl","as_gebinde_gesamtgewicht","as_charge_gesamtgewicht",
                "as_chargenpreis_ohne_steuer","as_chargenpreis_mit_steuer",
                "brennwertKjG","brennwertKcG","brennwertBeG",
                "alkoholGrammExtraktfrei",
                "brennwertKj20","brennwertKc20","brennwertBe20"
              };

              private final Class[] COLUMN_TYPE = {
                Integer.class, Double.class,Double.class,Double.class,Double.class,Double.class,Double.class,//1-7
                Double.class, Double.class,String.class,Double.class,Double.class,Double.class,Double.class,//2-7
                Double.class, String.class,//3-2
                String.class, Double.class,Double.class,Double.class,String.class,BigDecimal.class,Double.class,Double.class,Double.class,//4-9
                Double.class, Double.class,Double.class,//5-3
                Double.class, Double.class,Double.class,Double.class,Double.class,//6-5
				Double.class, Double.class,String.class,String.class,Double.class,Double.class,Double.class,//7-7
				Double.class, Double.class,Double.class,Double.class,Double.class,Double.class,//8-6
				String.class, BigDecimal.class,String.class,BigDecimal.class,//9-4
				BigDecimal.class, BigDecimal.class,BigDecimal.class,BigDecimal.class,BigDecimal.class,BigDecimal.class,//10-6
				BigDecimal.class, BigDecimal.class,String.class,String.class,//11-4
				String.class,java.util.Date.class,//12
				Double.class,Double.class,
				Double.class,Double.class,Double.class,
				Double.class,
				Double.class,Double.class,
				Double.class,Double.class,String.class,String.class,
				String.class,Double.class,BigDecimal.class,
				BigDecimal.class,BigDecimal.class,
				BigDecimal.class,BigDecimal.class,
				Integer.class,Double.class,Double.class,
				BigDecimal.class,BigDecimal.class,
				Double.class,Double.class,Double.class,
				Double.class,
				Double.class,Double.class,Double.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }


		public void addItem (
                final Integer flag,final String user,final String titel,final Double staerke,final Double gesamtLiter,final Double gesamtKg,
				final Double gesamtLA,final Double zMenge,final String zEinheit,final String zTitel,final Double zStaerke,
				final Double zLiter,final Double zKg,final Double zLA,final Double zLitergewicht,final String zArtikelnummer,
				final String zLosnummer,final Double zBestand,final Double zMeldebestand,final String zBestandsEinheit,final String zGrundpreis,
				final BigDecimal zPreis,final String zExtraktfrei,final Double zExtrakt,final Double zTrockenmasse,final Double zLiterExtraktfrei,
				final Double zStaerkeExtraktfrei,final Double zKgExtrakfrei,
				final Double summeLiter,final Double summeKg,final Double summeLA,final Double summeExtraktfreiLiter,final Double summeExtraktfreiKg,
				final BigDecimal summeKalkulation,final Double kurs,final String euro,final String waehrung,
				final Double litergewicht,final Double  extraktprozent,final Double extraktgramm,final Double wasserT,
				final Double wasserTKg,final Double kontraktion,final Double kontraktionKg,final Double wasserP,final Double wasserPKg,
				final String wassergrundpreis,final BigDecimal wasserpreis,final String steuergrundpreis,final BigDecimal steuerpreis,
				final BigDecimal perLiterEx,final BigDecimal perKgEx,final BigDecimal perLAEx,final BigDecimal perLiterInc,final BigDecimal perKgInc,final BigDecimal perLAInc,
				final BigDecimal summeOhneSteuer,final BigDecimal summeMitSteuer,final String kgPerLiter,final String gr100ml,
				final String kalkulationWarnung,Date	datum,
				final Double zBrennwertAlkohol,final Double zBrennwertAlkoholfrei,
				final Double brennwertKj,final Double brennwertKc,final Double brennwertBe,
				final Double literPerKg,
				final Double grammAlkPerKg,final double grammAlkPerLiter,
				final Double weinsaeure,final Double saeure,final String saeureText,final String deklarationenText,
				final String as_bezeichnung,
				final Double as_groesse,
				final BigDecimal as_einzelpreis,
				final BigDecimal as_inhalt_ohne_steuer,
				final BigDecimal as_inhalt_mit_steuer,
				final BigDecimal as_gesamtpreis_ohne_steuer,
				final BigDecimal as_gesamtpreis_mit_steuer,
				final Integer as_anzahl,
				final Double as_gebinde_gesamtgewicht,
				final Double as_charge_gesamtgewicht,
				final BigDecimal as_chargenpreis_ohne_steuer,
				final BigDecimal as_chargenpreis_mit_steuer,
				final Double brennwertKjG,final Double brennwertKcG,final Double brennwertBeG,
				final Double alkoholGrammExtraktfrei,
				final Double brennwertKj20,final Double brennwertKc20, final Double brennwertBe20
                )
        {
            	liste.add (new Object[] {
            	        flag,user,titel,staerke,
            	        gesamtLiter,gesamtKg,gesamtLA,
            	        zMenge,zEinheit,zTitel,zStaerke,zLiter,zKg,zLA,zLitergewicht,zArtikelnummer,
        				zLosnummer,zBestand,zMeldebestand,zBestandsEinheit,zGrundpreis,zPreis,zExtraktfrei,zExtrakt,zTrockenmasse,
						zLiterExtraktfrei,zStaerkeExtraktfrei,zKgExtrakfrei,
						summeLiter,summeKg,summeLA,summeExtraktfreiLiter,summeExtraktfreiKg,
						summeKalkulation,kurs,euro,waehrung,litergewicht,extraktprozent,extraktgramm,
						wasserT,wasserTKg,kontraktion,kontraktionKg,wasserP,wasserPKg,
						wassergrundpreis,wasserpreis,steuergrundpreis,steuerpreis,
						perLiterEx,perKgEx,perLAEx,perLiterInc,perKgInc,perLAInc,
						summeOhneSteuer,summeMitSteuer,kgPerLiter,gr100ml,
						kalkulationWarnung,datum,
						zBrennwertAlkohol,zBrennwertAlkoholfrei,
						brennwertKj,brennwertKc,brennwertBe,
						literPerKg,
						grammAlkPerKg,grammAlkPerLiter,
						weinsaeure,saeure,saeureText,deklarationenText,
						as_bezeichnung,
						as_groesse,
						as_einzelpreis,
						as_inhalt_ohne_steuer,
						as_inhalt_mit_steuer,
						as_gesamtpreis_ohne_steuer,
						as_gesamtpreis_mit_steuer,
						as_anzahl,
						as_gebinde_gesamtgewicht,
						as_charge_gesamtgewicht,
						as_chargenpreis_ohne_steuer,
						as_chargenpreis_mit_steuer,
						brennwertKjG,
						brennwertKcG,
						brennwertBeG,
						alkoholGrammExtraktfrei,
						brennwertKj20,brennwertKc20,brennwertBe20
            	});
        }

        public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}
