/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.proben.ProbenItem;
/**
 * @author labor
 *
 */
public class ProbeDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public ProbeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        ProbenItem  pi = null;
        pi = rz.getDatabase().getProben().getProbe(key);
        modell = new tableModel();
        if(modell != null) {
	        if(pi != null){
	        	final String bezeichnung=pi.getBezeichnung();
	            final String nummer = rz.getLocale().getString( "report.probe.nummer")
	            	.replaceAll("%n",String.valueOf(pi.getId()));
	            final String losnummer = rz.getLocale().getString("report.probe.losnummer")
	                 .replaceAll("%l", 	pi.getLosnummer());
	            final String zeilen[] = pi.getBemerkungen().split("\\n");
	            final String erstellt  = rz.getLocale().getString("string_erstellt").replaceAll("%s", pi.getErstelltToString()).replaceAll("%v",pi.getUser_1());
	            final String adressen = pi.getAdressListe().toVerboseString();
	            final Date datum = new Date();
	            for (final String element : zeilen) {
	                modell.addItem(rz.getDatabase().dbGetUser(),nummer,losnummer,bezeichnung, adressen,  erstellt, element, datum);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }
	

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","nummer","losnummer","bezeichnung","adressen","erstellt","zeile","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class,String.class, String.class, String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String nummer,
                final String losnummer,
                final String bezeichnung,
                final String adressen,
                final String erstellt,
                final String zeile,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,nummer,losnummer,bezeichnung,adressen,erstellt,zeile,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

