/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rezeptur.NotizItem;

/**
 * @author labor
 *
 */
public class NotizAusgabeDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public NotizAusgabeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        NotizItem ni = null;
        ni = rz.getDatabase().getNotizen().dbGetNotiz(key,true);
        modell = new tableModel();
        if(modell != null) {
	        if(ni != null){
	            final String titel = ni.getTitel();
	            final String zeilen[] = ni.getComment().split("\\n");
	            final String erstellt  = rz.getLocale().getString("string_erstellt").replaceAll("%s", ni.getErstelltToString()).replaceAll("%v",ni.getUser1());
	            final String geaendert = rz.getLocale().getString("string_geaendert").replaceAll("%s", ni.getGeaendertToString()).replaceAll("%v",ni.getUser2());
	            final String adressen = ni.getAdressListe().toVerboseString();
	            final String stichworte = ni.getStichwortListe().toVerboseString();
	            final Date datum = new Date();
	            for (final String element : zeilen) {
	                modell.addItem(rz.getDatabase().dbGetUser(),titel, adressen, stichworte, erstellt, geaendert, element, datum);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","adressen","stichworte","erstellt","geaendert","zeile","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, String.class, String.class, String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final String adressen,
                final String stichworte,
                final String erstellt,
                final String geaendert,
                final String zeile,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,titel,adressen,stichworte,erstellt,geaendert,zeile,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

