/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class MischungslisteDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    ArrayList<MischungsHeaderItem>	liste;
    boolean vorschau;
    boolean duplex=false;
    /**
     *
     */
    public	MischungslisteDrucken(RzPro r,ArrayList<MischungsHeaderItem> liste  ,String optionKey,boolean vorschau,java.awt.Window w,boolean duplex) {
        super(r,liste,optionKey,w);
        this.vorschau = vorschau;
        rz = r;
        this.duplex=duplex;
        this.optionKey=optionKey;
       this.liste = liste;;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
		SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
        if(modell != null) {
        	double summe =0;
            for(MischungsHeaderItem mhi:liste) {
            	summe += mhi.getLa();
            }
	        if(liste != null && !liste.isEmpty()){
	            final Date datum = rz.getDatabase().getServerTimestamp();
	            for(MischungsHeaderItem mhi:liste) {
	            	String ticketliste = getTicketListe(mhi);
	            	modell.addItem(
	            			rz.getDatabase().dbGetUser(),
	            			datum, 
	            			mhi.isActive()?rz.getLocale().getString("mischungslistendruck.active"):rz.getLocale().getString("mischungslistendruck.inactive"),
	            			String.valueOf(mhi.getId()),
	            			mhi.getBezeichnung(),
	            			mhi.getSorte().getBezeichnung(),
	            			mhi.getTank(),
	            			mhi.getBemerkungen(),
	            			rz.getLocale().formatNumber(mhi.getLa(),OptionFactory.NF_NORMAL),
	            			mhi.getLosnummer(),
	            			rz.getLocale().getString("mischungslistendruck.erstellt").replaceAll("%d", df.format(mhi.getErstellt())).replaceAll("%u", mhi.getErstellt_user()),
	    	            	rz.getLocale().getString("mischungslistendruck.geaendert").replaceAll("%d", df.format(mhi.getErstellt())).replaceAll("%u", mhi.getGeaendert_user()),
	    	    	        !mhi.isActive()?rz.getLocale().getString("mischungslistendruck.abgeschlossen").replaceAll("%d", df.format(mhi.getErstellt())).replaceAll("%u", mhi.getAbgeschlossen_user()):"",
	    	    	        rz.getLocale().formatNumber(summe, OptionFactory.NF_NORMAL),
	    	    	        mhi.getSorte().getId(),
	    	    	        mhi.getLa(),
	    	    	        ticketliste
	            		 );
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }
    
    private String getTicketListe(MischungsHeaderItem mhi) {
    	String ret = "";
    	MischungsItem mi = rz.getDatabase().getMischungen().getMischung(mhi.getId());
    	for(TicketItem ti:mi.getAllTickets()) {
    		if(ti.getTyp() == TicketItem.TYP_WARE) {
    			ret += ti.getNummer()+" :" + ti.getBezeichnung() + " :" + ti.getLosnummer_original() +  " (" + ti.getErstelltToString2() + ")" + "\n";
    		}
    	}
    	if(ret.endsWith("\n")) {
    		ret = ret.substring(0,ret.length()-1);
    	}
    	return ret;
    }
    
    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
	    				printDirectly(report);
	                }
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"user",
        		"datum",
        		"mischung.active",
        		"mischung.nummer",
        		"mischung.bezeichnung",
        		"mischung.sorte",
        		"mischung.tank",
        		"mischung.bemerkungen",
        		"mischung.la",
        		"mischung.losnummer",
        		"mischung.erstellt",
        		"mischung.geaendert",
        		"mischung.abgeschlossen",
        		"mischung.summe",
        		"mischung.sorte_id",
        		"mischung.la_double",
        		"mischung.ticketliste"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  Integer.class,
            		  Double.class,
            		  String.class
            		  
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String user,
        		Date datum,
        		String mischung_active,
        		String mischung_nummer,
        		String mischung_bezeichnung,
        		String mischung_sorte,
        		String mischung_tank,
        		String mischung_bemerkungen,
        		String mischung_a,
        		String mischung_losnummer,
        		String mischung_erstellt,
        		String mischung_geaendert,
        		String mischung_abgeschlossen,
        		String mischung_summe,
        		int	mischung_sorte_id,
        		double la_double,
        		String mischung_ticketliste
                )
        {
            	liste.add (new Object[] {   
            			user,
                		datum,
                		mischung_active,
                		mischung_nummer,
                		mischung_bezeichnung,
                		mischung_sorte,
                		mischung_tank,
                		mischung_bemerkungen,
                		mischung_a,
                		mischung_losnummer,
                		mischung_erstellt,
                		mischung_geaendert,
                		mischung_abgeschlossen,
                		mischung_summe,
                		mischung_sorte_id,
                		la_double,
                		mischung_ticketliste
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

