/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.TransaktionsItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class MischungDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    MischungsItem	mi;
    boolean vorschau;
    boolean duplex=false;
    /**
     *
     */
    public	MischungDrucken(RzPro r,MischungsItem mi,String optionKey,boolean vorschau,java.awt.Window w,boolean duplex) {
        super(r,mi,optionKey,w);
        this.vorschau = vorschau;
        rz = r;
        this.duplex=duplex;
        this.optionKey=optionKey;
       this.mi = mi;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(mi != null){
	            final Date datum = rz.getDatabase().getServerTimestamp();
	            for(TicketItem ti:mi.getAllTickets()) {
	            	TransaktionsItem tri = rz.getDatabase().getMischungen().getTransaktion(ti.getTransaktion());
	            	String transaktion_daten=rz.getLocale().getString("mischungdrucken.transaktion_daten")
	            			.replaceAll("%n", String.valueOf(tri.getId()))
	            			.replaceAll("%b", tri.getBemerkungen())
	            			.replaceAll("%0", String.valueOf(tri.getMischung_source()))
	            			.replaceAll("%1", String.valueOf(tri.getMischung_dest()))
	            			.replaceAll("%2", tri.getTank())
	            			.replaceAll("%3", tri.getTank_dest())
	            			;
		            modell.addItem(
		            		rz.getDatabase().dbGetUser(),
		            		datum,
		            		String.valueOf(mi.getHeader().getId()),
		            		mi.getHeader().getBezeichnung(),
		            		mi.getHeader().getSorte().getBezeichnung(),
		            		mi.getHeader().getBemerkungen(), 
		            		mi.getHeader().getTank(),
		            		mi.getHeader().getLosnummer(),
		            		rz.getLocale().formatNumber(mi.getLA(),OptionFactory.NF_NORMAL),
		            		rz.getLocale().getString("string_erstellt").replaceAll("%s",mi.getErstelltToString()).replaceAll("%v",mi.getHeader().getErstellt_user()),
		            		mi.getHeader().getErstellt_user(),
		            		rz.getLocale().getString("string_geaendert").replaceAll("%s",mi.getGeaendertToString()).replaceAll("%v",mi.getHeader().getGeaendert_user()) ,
		            		mi.getHeader().getGeaendert_user(),
		            		mi.getHeader().isActive()?"": rz.getLocale().getString("string_abgeschlossen").replaceAll("%s",mi.getAbgeschlossenToString()).replaceAll("%v",mi.getHeader().getAbgeschlossen_user()) ,
		            		mi.getHeader().isActive()?"":mi.getHeader().getAbgeschlossen_user(),
		            		ti.getTyp(),
		            		rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText(),
		            		ti.getNummer(), 
		            		String.valueOf(ti.getTransaktion()), 
		            		ti.getBezeichnung(),
		            		ti.getBemerkungen(), 
		            		ti.getLosnummer_original(), 
		            		rz.getDatabase().getMischungen().getSorte(ti.getSorte()).getBezeichnung(),
		            		rz.getLocale().formatNumber(ti.getLa(), OptionFactory.NF_NORMAL),
		            		rz.getLocale().formatNumber(ti.getStaerke(), OptionFactory.NF_TWO),
		            		ti.getAdresse(),
		            		rz.getLocale().getString("string_erstellt").replaceAll("%s",ti.getErstelltToString()).replaceAll("%v",ti.getErstellt_user()),
		            		ti.getErstellt_user(),
		            		rz.getLocale().getString("string_geaendert").replaceAll("%s",ti.getGeaendertToString()).replaceAll("%v",ti.getGeaendert_user()) ,
		            		ti.getGeaendert_user(),
		            		tri.getBemerkungen(),
		            		String.valueOf(tri.getMischung_source()),
		            		tri.getTank(),
		            		String.valueOf(tri.getMischung_dest()),
		            		tri.getTank_dest(),
		            		transaktion_daten,
		            		ti.getProbe() == 0?"":String.valueOf(ti.getProbe())
		            		);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }
    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
	            	if(duplex) {
	            		printDirectlyDuplex(report);
	            	} else {
	    				printDirectly(report);
	                }
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"user",
        		"datum",
        		"mischung_nummer",
        		"mischung_bezeichnung",
        		"mischung_sorte",
        		"mischung_bemerkungen",
        		"mischung_tank",
        		"mischung_losnummer",
        		"mischung_la",
        		"mischung_erstellt_datum",
        		"mischung_erstellt_user",
        		"mischung_geaendert_datum",
        		"mischung_geaendert_user",
        		"mischung_abgeschlossen_datum",
        		"mischung_abgeschlossen_user",
        		"ticket_typ",
        		"ticket_typ_string",
        		"ticket_nummer",
        		"ticket_transaktionsnummer",
        		"ticket_bezeichnung",
        		"ticket_bemerkungen",
        		"ticket_original_losnummer",
        		"ticket_sorte",
        		"ticket_la",
        		"ticket_staerke",
        		"ticket_adresse",
        		"ticket_erstellt_datum",
        		"ticket_erstellt_user",
        		"ticket_geaendert_datum",
        		"ticket_geaendert_user",
        		"transaktion_bezeichnung",
        		"transaktion_src_mischung",
        		"transaktion_src_tank",
        		"transaktion_dest_mischung",
        		"transaktion_dest_tank",
        		"transaktion_daten",
        		"ticket_probe"
        		
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  Integer.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
              		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
               		  String.class,
            		  String.class,
            		  String.class, 
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String user,
        		Date datum,
        		String mischung_nummer,
        		String mischung_bezeichnung,
        		String mischung_sorte,
        		String mischung_bemerkungen,
        		String mischung_tank,
        		String mischung_losnummer,
        		String mischung_la,
        		String mischung_erstellt_datum,
        		String mischung_erstellt_user,
        		String mischung_geaendert_datum,
        		String mischung_geaendert_user,
        		String mischung_abgeschlossen_datum,
        		String mischung_abgeschlossen_user,
        		int ticket_typ,
        		String ticket_typ_string,
        		String ticket_nummer,
        		String ticket_transaktionsnummer,
        		String ticket_bezeichnung,
        		String ticket_bemerkungen,
        		String ticket_original_losnummer,
        		String ticket_sorte,
        		String ticket_la,
        		String ticket_staerke,
        		String ticket_adresse,
        		String ticket_erstellt_datum,
        		String ticket_erstellt_user,
        		String ticket_geaendert_datum,
        		String ticket_geaendert_user,
        		String transaktion_bezeichnung,
        		String transaktion_src_mischung,
        		String transaktion_src_tank,
        		String transaktion_dest_tank,
        		String transaktion_dest_mischung,
        		String transaktion_daten,
        		String probe
                )
        {
            	liste.add (new Object[] {        		 user,
                		 datum,
                		 mischung_nummer,
                		 mischung_bezeichnung,
                		 mischung_sorte,
                		 mischung_bemerkungen,
                		 mischung_tank,
                		 mischung_losnummer,
                		 mischung_la,
                		 mischung_erstellt_datum,
                		 mischung_erstellt_user,
                		 mischung_geaendert_datum,
                		 mischung_geaendert_user,
                		 mischung_abgeschlossen_datum,
                		 mischung_abgeschlossen_user,
                		 ticket_typ,
                		 ticket_typ_string,
                		 ticket_nummer,
                		 ticket_transaktionsnummer,
                		 ticket_bezeichnung,
                		 ticket_bemerkungen,
                		 ticket_original_losnummer,
                		 ticket_sorte,
                		 ticket_la,
                		 ticket_staerke,
                		 ticket_adresse,
                		 ticket_erstellt_datum,
                		 ticket_erstellt_user,
                		 ticket_geaendert_datum,
                		 ticket_geaendert_user,
                 		 transaktion_bezeichnung,
                		 transaktion_src_mischung,
                		 transaktion_src_tank,
                		 transaktion_dest_tank,
                		 transaktion_dest_mischung,
                		 transaktion_daten,
                		 probe
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

