/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.lieferschein.LieferscheinAuftrag;
import de.lunqual.rzpro.items.lieferschein.LieferscheinItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinZeile;

/**
 * @author labor
 *
 */
public class LieferscheinAusgabeDrucken extends ReportAusgabe {

    public static final String			DEFAULT_ORIENTATION="portrait";

    LieferscheinItem							li;
    /**
     *
     */
    public LieferscheinAusgabeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        li = (LieferscheinItem)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(li != null){
                String adressString = "";
                if(li.getAi() != null) {
                    adressString = li.getAi().getFirma() + "," + li.getAi().getStrasse() + ", " +
                    	li.getAi().getPLZ() + " " + li.getAi().getOrt();
                } else {
                    adressString = li.getAdresse_string();
                }
	            final Date datum = new Date();
	            for(int i = 0; i < li.getAuftragsListe().size();i++) {
	                final LieferscheinAuftrag a = li.getAuftragsListe().getItem(i);
	                for(int j=0;j < a.getZeilenListe().size();j++) {
	                    final LieferscheinZeile zl = a.getZeilenListe().getItem(j);
	                    Calendar c = Calendar.getInstance();
	                    c.setTime(li.getErstellt());
	                    String ean = zl.getEan()!=null && zl.getEan().equals("")?zl.getLosnummer():zl.getLosnummer()+"\n" + zl.getEan();
	                    modell.addItem(
	                            Integer.valueOf(zl.getTyp()),
	                            li.getNummer(),
	                            adressString,
	                            li.getAi() != null ? li.getAi().getFirma(): li.getAdresse_string(),
	    	                    li.getAi() != null ? li.getAi().getVorname(): "",
	                            li.getAi() != null ? li.getAi().getNachname(): "",
	                            li.getAi() != null ? li.getAi().getPLZ(): "",
		                        li.getAi() != null ? li.getAi().getStrasse():"",
	                            li.getAi() != null ? li.getAi().getOrt():"",
	                            li.getAi() != null ? li.getAi().getFon():"",
	    	                    li.getAi() != null ? li.getAi().getFax():"",
	                            li.getErstelltToString(),
	                            li.getGeaendertToString(),
	                            a.getBezeichnung(),
	                            Double.valueOf(a.getStaerke()),
	                            zl.getBezeichnung(),
	                            zl.getContainerS(),
	                            //zl.getLosnummer(),
	                            ean,
	                            Double.valueOf(zl.getStaerke()),
	                            Double.valueOf(zl.getLitergewicht()),
	                            Double.valueOf(zl.getBrutto()),
	                            Double.valueOf(zl.getTara()),
	                            Double.valueOf(zl.getNetto()),
	                            Double.valueOf( zl.getLiter()),
	                            Double.valueOf( zl.getKg()),
	                            Double.valueOf(zl.getLa()),
	                            datum,
	                            rz.getDatabase().dbGetUser(),
	                            rz.getLocale().getString("report.lieferschein.abfuelltag")
	                            	.replaceAll("%s",rz.getDatabase().getKalender().getDate20(c))
	                            	.replaceAll("%y",rz.getDatabase().getKalender().getYear20(c))
	                    );
	                }
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "flag",
                "lieferschein-nummer","adresse-string","adresse-firma",
                "adresse-vorname","adresse-nachname","adresse plz",
                "adresse-strasse","adresse-ort","adresse-telefon","adresse-fax",
                "erstellt","geaendert", "auftrag-bezeichnung","auftrag-staerke","container-inhalt","container-nummer",
                "losnummer","staerke","litergewicht","brutto","tara",
                "netto","liter","kg",
                "la",
                "datum","user","datum20"
              };

              private final Class[] COLUMN_TYPE = {
                Integer.class,
                String.class, String.class,  String.class,
                String.class, String.class, String.class,
                String.class,String.class, String.class, String.class,
                String.class, String.class, String.class, Double.class,String.class,String.class,
                String.class,Double.class,Double.class,Double.class,Double.class,
                Double.class,Double.class,Double.class,
                Double.class,
                java.util.Date.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                Integer flag,
                String lieferschein_nummer,
                String adresse_string,
                String adresse_firma,
                String adresse_vorname,
                String adresse_nachname,
                String adresse_plz,
                String adresse_strasse,
                String adresse_ort,
                String adresse_telefon,
                String adresse_fax,
                String erstellt,
                String geaendert,
                String auftrag_bezeichnung,
                Double auftrag_staerke,
                String inhalt,
                String nummer,
                String losnummer,
                Double staerke,
                Double litergewicht,
                Double brutto,
                Double tara,
                Double netto,
                Double liter,
                Double kg,
                Double la,
                java.util.Date datum,
                String user,
                String datum20
                )
        {
            	liste.add (new Object[] {
            	         flag,
                         lieferschein_nummer,
                         adresse_string,
                         adresse_firma,
                         adresse_vorname,
                         adresse_nachname,
                         adresse_plz,
                         adresse_strasse,
                         adresse_ort,
                         adresse_telefon,
                         adresse_fax,
                         erstellt,
                         geaendert,
                         auftrag_bezeichnung,
                         auftrag_staerke,
                         inhalt,
                         nummer,
                         losnummer,
                         staerke,
                         litergewicht,
                         brutto,
                         tara,
                         netto,
                         liter,
                         kg,
                         la,
                        datum,
                        user,
                        datum20
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}


