/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class LaborwertDrucken extends ReportAusgabe {

    int 											key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    LaborwertValueListe					vliste;
    LaborwertItem							lw;
    RechenItem								ri;
    /**
     *
     */
    public LaborwertDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,LaborwertItem lw,RechenItem ri) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        vliste = (LaborwertValueListe)reportData;
        this.lw=lw;
        this.ri=ri;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        Date 			datum=new Date();
        String		user=rz.getDatabase().dbGetUser();
        if(modell != null) {
        	if(vliste != null && !vliste.isEmpty()) {
        		for(int i =0;i<vliste.size();i++) {
        			LaborwertValueItem vi = vliste.getItem(i);
        			if(vi != null) {
        				modell.addItem(
        						datum, user,
        						vliste.getRezepturBezeichnung(),vliste.getLaborwert(),
        						vi.getStrEinheit1(),vi.getStrEinheit2(),
        						vi.getStrEinheit1() + " / " + vi.getStrEinheit2(),
        						rz.getLocale().formatNumber( vliste.getSumme_liter(),OptionFactory.NF_NORMAL),
        						rz.getLocale().formatNumber( vliste.getSumme_kg(),OptionFactory.NF_NORMAL),
        						rz.getLocale().formatNumber( vliste.getSumme_la(),OptionFactory.NF_NORMAL),
        						rz.getLocale().formatNumber( vliste.getValue_liter(),OptionFactory.NF_NORMAL),
        						rz.getLocale().formatNumber( vliste.getValue_kg(),OptionFactory.NF_NORMAL),
        						rz.getLocale().formatNumber( vliste.getValue_la(),OptionFactory.NF_NORMAL),

        						vi.getRezepturBezeichnung(),
        						rz.getLocale().formatNumber( vi.getValue(),OptionFactory.NF_NORMAL),
        						vi.isFix()?rz.getLocale().getString("laborwert.fix"):(vi.getStrEinheit1() + " / " + vi.getStrEinheit2()),
        						rz.getLocale().formatNumber( vi.getRezepturMenge(),OptionFactory.NF_NORMAL),
        						vi.isFix()?"":vi.getStrEinheit2(),
        						rz.getLocale().formatNumber( vi.getMenge(),OptionFactory.NF_NORMAL),
        						vi.isFix()?"":vi.getStrEinheit1(),
        						getErgebnisString()
        						);
        			}
        		}
        	}
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    private String getErgebnisString() {
    	String inhalt="";
        double value =0.0;
        final String einheit = lw.getStrEinheit1();
        final String laborwert = lw.getBezeichnung();
        switch(vliste.getEinheit()) {
        	case RzPro.EINHEIT_KG:value =vliste.getValue_kg();break;
        	case RzPro.EINHEIT_LITER:value =vliste.getValue_liter();break;
        	case RzPro.EINHEIT_LA:value =vliste.getValue_la();break;
        }
        inhalt += rz.getLocale().getString("report.laborwertberechnung_titelzeile1")
        	.replaceAll("%v", rz.getLocale().formatNumber(value, OptionFactory.NF_NORMAL))
        	.replaceAll("%e",einheit)
        	.replaceAll("%l",laborwert)
        	.replaceAll("%menge",rz.getLocale().formatNumber(ri.getGesamtLiter(),OptionFactory.NF_NORMAL))
        	.replaceAll("%rezeptur",ri.getRezeptur().getTitel());
        inhalt +="\n";

        inhalt += rz.getLocale().getString("report.laborwertberechnung_titelzeile2")
            	.replaceAll("%v", rz.getLocale().formatNumber(value, OptionFactory.NF_NORMAL))
            	.replaceAll("%e",einheit)
            	.replaceAll("%l",laborwert)
            	.replaceAll("%menge",rz.getLocale().formatNumber(ri.getGesamtLiter(),OptionFactory.NF_NORMAL))
            	.replaceAll("%rezeptur",ri.getRezeptur().getTitel());
        inhalt +="\n\n";
        
        inhalt +=rz.getLocale().getString("report.laborwertberechnung_ergebnis_la")
    	.replaceAll("%la",rz.getLocale().formatNumber( vliste.getSumme_la(),OptionFactory.NF_NORMAL))
    	.replaceAll("%v",rz.getLocale().formatNumber(  value/vliste.getSumme_la()  ,OptionFactory.NF_NORMAL))
    	.replaceAll("%e",einheit).replaceAll("%a",laborwert);

        inhalt +="\n";
        inhalt += rz.getLocale().getString("report.laborwertberechnung_ergebnis_liter")
        	.replaceAll("%liter",rz.getLocale().formatNumber( vliste.getSumme_liter(),OptionFactory.NF_NORMAL))
        	.replaceAll("%v",rz.getLocale().formatNumber(  value/vliste.getSumme_liter()  ,OptionFactory.NF_NORMAL))
        	.replaceAll("%e",einheit).replaceAll("%a",laborwert);

        inhalt +="\n";
        inhalt += rz.getLocale().getString("report.laborwertberechnung_ergebnis_kg")
    	.replaceAll("%kg",rz.getLocale().formatNumber( vliste.getSumme_kg(),OptionFactory.NF_NORMAL))
    	.replaceAll("%v",rz.getLocale().formatNumber(  value/vliste.getSumme_kg()  ,OptionFactory.NF_NORMAL))
    	.replaceAll("%e",einheit).replaceAll("%a",laborwert);
    	
    	return inhalt;
    }
    
    
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"datum","user",
        		"rezeptur","laborwert",
        		"einheit1","einheit2",
        		"messeinheit",
        		"summe_liter","summe_kg","summe_la",
        		"summe_value_liter","summe_value_kg","summe_value_la",
        		
        		"vi_rezeptur",
        		"value","einheit",
        		"rezepturmenge","rezeptureinheit",
        		"menge","mengeneinheit",
        		"ergebnis_string"
              };

              private final Class[] COLUMN_TYPE = {
            	Date.class,String.class,
            	String.class,String.class,
            	String.class,String.class,
            	String.class,
            	String.class,String.class,String.class,
            	String.class,String.class,String.class,
            	String.class,
            	String.class,String.class,
            	String.class,String.class,
            	String.class,String.class,
            	String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		final Date datum,final String user,
        		final String rezeptur,final String laborwert,
        		final String einheit1,final String einheit2,
        		final String messeinheit,
        		final String summe_liter,final String summe_kg,final String summe_la,
        		final String summe_value_liter,final String summe_value_kg,final String summe_value_la,
        		final String vi_rezeptur,
        		final String value,final String einheit,
        		final String rezepturmenge,final String rezepturheinheit,
        		final String menge,final String mengeneinheit,
        		final String ergebnis_string
                )
        {
            	liste.add (new Object[] {
            			datum,  user,
                		rezeptur,  laborwert,
                		einheit1,  einheit2,
                		messeinheit,
                		summe_liter,  summe_kg,  summe_la,
                		summe_value_liter,  summe_value_kg,  summe_value_la,
                		vi_rezeptur,
                		value,  einheit,
                		rezepturmenge,  rezepturheinheit,
                		menge,  mengeneinheit,
                		ergebnis_string
                		
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

