/*
 *  Copyright (C) Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.log.LogFactory;

/**
 * @author lunqual
 *
 */
public class EtikettenDrucken extends  ReportAusgabe {

	public static final int		ETIKETTEN_MAX_COLUMNS		= 8;
	public static final int		MODELL_OFFSET = 24;

	EtikettenListe			etiketten;
	EtikettenListe			eListe;
	tableModel				modell;

    public EtikettenDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        etiketten = (EtikettenListe)reportData;
        //this.optionKey = "report.etiketten";
        rz.getOptionFactory().setOption(optionKey,etiketten.getBogen().getReport());
        modell =null;
    }


	@Override
	public void createModel() {
		int i,e,c,z;
        eListe = new EtikettenListe();
		for(i =0;i < etiketten.getStartEtikett() -1;i++) {
			eListe.add(0,new EtikettenItem(rz));
		}
		for(i =0;i < etiketten.size();i++) {
			eListe.add(etiketten.getItem(i));
		}
		modell = new tableModel();
		for( e = 0; e < eListe.size();e+=etiketten.getBogen().getColumns()) {
       	    for( c = 0;c < etiketten.getBogen().getColumns();c++) {
       	    	for( z = 0;z < EtikettenItem.ETIKETTENZEILEN ; z++) {
       	    		try {
       	    		    if(!eListe.getItem(e+c).isEmpty()) {
       	    		    	if(!eListe.getItem(e+c).isEmptyLabel()) {
	       	    		        modell.addItem(eListe.getItem(e+c).getCode128(),e/etiketten.getBogen().getColumns(), c);
		       	    		    modell.addItem(eListe.getItem(e+c).getImage(),e/etiketten.getBogen().getColumns(), c+ETIKETTEN_MAX_COLUMNS);
		       	    		    modell.addItem(eListe.getItem(e+c).getLosnummer(),e/etiketten.getBogen().getColumns(), c+(ETIKETTEN_MAX_COLUMNS * 2));
		       	    		    modell.addItem(eListe.getItem(e+c).getZeile(z),e/etiketten.getBogen().getColumns(), MODELL_OFFSET+(c*EtikettenItem.ETIKETTENZEILEN)+z);
	       	    		    } else {
	       	    		        modell.addItem("",e/etiketten.getBogen().getColumns(), c);
		       	    		    modell.addItem(null,e/etiketten.getBogen().getColumns(), c+ETIKETTEN_MAX_COLUMNS);
		       	    		    modell.addItem("",e/etiketten.getBogen().getColumns(), c+(ETIKETTEN_MAX_COLUMNS * 2));
		       	    		    modell.addItem("",e/etiketten.getBogen().getColumns(), MODELL_OFFSET+(c*EtikettenItem.ETIKETTENZEILEN)+z);
	       	    		    }
       	    		    }
       	    		} catch (final Exception ex) {}
       	    	}
       	    }
		}
		report = getReport();
        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
        report.setQuery ("default");
	}

    private class tableModel extends AbstractTableModel{

    	private final ArrayList liste;

    	public String COLUMN_NAMES[];
    	private final Class COLUMN_TYPES[];

    	public tableModel() {
    		int i,j;
    		liste = new ArrayList();
    		COLUMN_NAMES = new String[(ETIKETTEN_MAX_COLUMNS * EtikettenItem.ETIKETTENZEILEN)+MODELL_OFFSET];
       		COLUMN_TYPES = new Class[(ETIKETTEN_MAX_COLUMNS * EtikettenItem.ETIKETTENZEILEN)+MODELL_OFFSET];
       		for(i=0 ;i < ETIKETTEN_MAX_COLUMNS;i++) {
       		    COLUMN_NAMES[i] = "losnummercode_" + String.valueOf(i);
       	    	COLUMN_TYPES[i] = Image.class;
       		    COLUMN_NAMES[i + ETIKETTEN_MAX_COLUMNS] = "bild_" + String.valueOf(i);
       		    COLUMN_TYPES[i + ETIKETTEN_MAX_COLUMNS] = Image.class;
       		    COLUMN_NAMES[i +( ETIKETTEN_MAX_COLUMNS*2)] = "losnummer_" + String.valueOf(i);
       		    COLUMN_TYPES[i + (ETIKETTEN_MAX_COLUMNS*2)] = String.class;
       		}
       	    for( i = 0;i < ETIKETTEN_MAX_COLUMNS;i++) {
       	    	for( j = 0;j < EtikettenItem.ETIKETTENZEILEN ; j++) {
       	    		COLUMN_NAMES[(i*EtikettenItem.ETIKETTENZEILEN)+j+MODELL_OFFSET] = "column_" + String.valueOf((i)) + "_row_" + String.valueOf(j);
       	    		COLUMN_TYPES[(i*EtikettenItem.ETIKETTENZEILEN)+j+MODELL_OFFSET] = String.class;
       	    	}
       	    }
       	    createField();
    	}

    	public void createField() {
    	    for(int i = 0; i < eListe.size();i++) {
    	    	liste.add(new  Object[(ETIKETTEN_MAX_COLUMNS * EtikettenItem.ETIKETTENZEILEN)+2]);
    	    }
    	}
    	public void addItem(Object item,int row,int col) {
    		((Object[])liste.get(row))[col] = item;
    	}

        public int getColumnCount() {
            return COLUMN_TYPES.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

		public int getRowCount() {
			int rc = liste.size() / etiketten.getBogen().getColumns();
			if(liste.size() % etiketten.getBogen().getRows() != 0) {
				rc += 1;
			}
			return rc;
		}

		public Object getValueAt(int rowIndex, int columnIndex){
			try {
	          final Object[] l = (Object[])liste.get (rowIndex);
	          if (columnIndex >= l.length) {
	        	  columnIndex = l.length-1;
	          }
	          return l[columnIndex];
			}catch(Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "Etikettendrucken.geValueAt", e.getLocalizedMessage());
				return null;
			}
		}
    }
}
