/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class ErgebnislisteBestandDrucken extends ReportAusgabe {

    int 						key;
    public static final String	DEFAULT_ORIENTATION="landscape";
    ErgebnisListe				liste;
    SimpleDateFormat 			df;
    boolean						bestand;
    boolean						duplex=false;
    /**
     *
     */
    public ErgebnislisteBestandDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,ErgebnisListe liste,boolean bestand,boolean duplex) {
        super(r,reportData,optionKey,w);
        rz = r;
        df = new SimpleDateFormat("EEEE, dd. MM yyyy");
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
        this.liste=liste;
        this.bestand = bestand;
        this.duplex=duplex;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("EEEE d. MMMM yyyy");
        modell = new tableModel();
        if(modell != null) {
        	if(liste != null) {
        		rz.getDatabase().getBuchungen().getZugangAbgangListe(liste);
        		for(int i =	0;i < liste.size();i++) {
        			ErgebnisItem eli = liste.getItem(i);
                	final SaldenItem s = rz.getDatabase().getRezeptur().forceBestand(eli.getID());
                	String abgang = eli.getAbgang()!=null?rz.getLocale().getString("ergebnislistebestand.letzter_abgang").replaceAll("%s",df.format(eli.getAbgang())) :"";
                	String zugang = eli.getZugang()!=null?rz.getLocale().getString("ergebnislistebestand.letzter_zugang").replaceAll("%s",df.format(eli.getZugang())) :"";
                	boolean print = true;
                	if(bestand && rz.isZero(s.getBestand())){
                		print = false;
                	}
        			if(print) {
        				modell.addItem(
        					rz.getDatabase().dbGetUser(),
        					now,
        					eli.getBezeichnung(),
        					eli.getArtikelnummer(),
        					 rz.getLocale().getString("ausgabe.bestand_detail_plain")
                				.replaceAll("%l",rz.getLocale().formatNumber(s.getLiter(), OptionFactory.NF_NORMAL)  )
                				.replaceAll("%k",rz.getLocale().formatNumber(s.getKg(), OptionFactory.NF_NORMAL)  )
                				.replaceAll("%a",rz.getLocale().formatNumber(s.getLa(), OptionFactory.NF_NORMAL)  ),
                			rz.getLocale().getString("ausgabe.rezeptur_temperatur") + ": "+
                			rz.getLocale().getString("ausgabe.rezeptur_temperatur_string") 
        							.replaceAll("%v",String.valueOf(eli.getTempVon()))
        							.replaceAll("%b",String.valueOf(eli.getTempBis()))
        							.replaceAll("%s",String.valueOf(eli.getTemperaturDurchschnitt()))
        							.replaceAll("%z", eli.isKonform()?(rz.getLocale().getString("ausgabe.rezeptur_konform")+ df.format(eli.getKonformDatum())):""),
        							abgang,
        							zugang,
        					      	rz.getLocale().getString("bestandslistendruck.tank").replaceAll("%s", rz.getDatabase().getBuchungen().getBestandTanks(eli.getID(),rz.getLocale().getString("ausgabe.tank"),rz.getOptionFactory().getOption("dbbuchung.tank_sb"),rz.getOptionFactory().getOption("dbbuchung.tank_se")).getTankString())

        					);
        			}
        		}
		        report = getReport();
		        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
		        report.setQuery ("default");
        	}
        }
    }

    public void printReport(){
    	try {
    	  if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
              final PreviewFrame frame = new PreviewFrame(report);
              frame.pack();
              frame.setVisible(true);
              frame.requestFocus();
          } else {
          		if(duplex) {
          			printDirectlyDuplex(report);
          		} else {
          			printDirectly(report);
          		}	
          }
        }
        catch (final Exception e){}
    }
    
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user",
                "datum",
                "bezeichnung",
                "artikelnummer",
                "bestand",
                "temperatur",
                "letzterAbgang",
                "letzterZugang",
                "tank"
              };

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  java.util.Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final Date datum,
                final String bezeichnung,
                final String artikelnummer,
                final String bestand,
                final String temperatur,
                final String letzterAbgang,
                final String letzterZugang,
                final String tank
                )
        {
            	liste.add (new Object[] {user,datum,bezeichnung,artikelnummer,bestand,temperatur,letzterAbgang,letzterZugang,tank});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

