/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListenItem;

/**
 * @author labor
 *
 */
public class ErgebnislisteAusgabeDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    ArrayList<ErgebnisListenItem>				liste;
    /**
     *
     */
    public ErgebnislisteAusgabeDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w,ArrayList liste) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
        this.liste=liste;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        Date now = new Date();
        modell = new tableModel();
        if(modell != null) {
        	if(liste != null) {
        		for(int i =	0;i < liste.size();i++) {
        			ErgebnisListenItem eli = liste.get(i);
        			modell.addItem(rz.getDatabase().dbGetUser(),
        					eli.getRezeptur(), 
        					eli.getArtikelnummer(), 
        					eli.getFirma(), 
        					!eli.getSpezifikation().equals("")?rz.getLocale().getString("report.label_spezifikation")+eli.getSpezifikation():"",
        					now);
        		}
		        report = getReport();
		        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
		        report.setQuery ("default");
        	}
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","name","artikelnummer","firma","spezifikation","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class, String.class, String.class, String.class,String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String name,
                final String artikelnummer,
                final String firma,
                final String spezifikation,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,name,artikelnummer,firma,spezifikation,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

