/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.DependencyItem;
/**
 * @author labor
 *
 */
public class DependencyDrucken extends ReportAusgabe {

    int 								key;
    public static final String			DEFAULT_ORIENTATION="portrait";
    DependencyListe						liste;
    boolean								vorschau;
    /**
     *
     */
    public DependencyDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        this.liste = (DependencyListe)reportData;
        this.vorschau = vorschau;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
        	if(liste != null && liste.size() > 0) {
        		for(int i = 0;i< liste.size();i++) {
        			DependencyItem di = liste.getItem(i);
        			if(di != null) {
        				modell.addItem(rz.getDatabase().dbGetUser(),
        						liste.getTitel(), 
        						rz.getDatabase().getServerTimestamp(),
        						di.getName(), 
        						rz.getLocale().getString("report.dependency.lager").replaceAll("%s", di.getLager()),
        						rz.getLocale().getString("report.dependency.steuer_lager").replaceAll("%s", di.getSteuer_lager()),
        						rz.getLocale().getString("report.dependency.steuer_artikel").replaceAll("%s", di.getSteuer_artikel()));
        			}
        		}
        	}
	    }
        report = getReport();
        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
        report.setQuery ("default");
    }

    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
					printDirectly(report);
				}
            }
        }
        catch (final Exception e){}
    }

    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","rezeptur","datum","name","lager","steuer_lager","steuer_artikel"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class,java.util.Date.class,String.class, String.class, String.class, String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String rezeptur,
                final java.util.Date datum,
                final String name,
                final String lager,
                final String steuer_lager,
                final String steuer_artikel

                )
        {
            	liste.add (new Object[] {user,rezeptur,datum,name,lager,steuer_lager,steuer_artikel});
        }

        
        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

