/*
 * Created on 10.09.2004
 *
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dm.DMItem;
/**
 * @author labor
 *
 */
public class DMDrucken extends ReportAusgabe {
	ArrayList<DMItem>	liste;
    public static final String			DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public DMDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        liste = ((ArrayList<DMItem>)reportData);
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
    	SimpleDateFormat df = new SimpleDateFormat("d. MMMM yyyy H:mm");
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
        	if(liste !=null && !liste.isEmpty()) {
        		Date datum = new Date();
        		for(DMItem di:liste) {
	        		modell.addItem(
	        				datum,
	        				rz.getDatabase().dbGetUser(),
	        				di.getProben_id(),
	        				df.format(di.getDatum_zeit()),
	        				di.getFirmware(),
	        				di.getDma_seriennummer(),
	        				di.getXsample_seriennummer(),
	        				di.getStaerke(),
	        				di.getDichte(),
	        				di.getRel_dichte(),
	        				di.getDichte_temperatur(),
	        				di.getFeld1(),
	        				di.getFeld2(),
	        				di.getFeld3(),
	        				di.getBezeichnung(),
	        				di.getLosnummer(),
	        				di.getConnected_user(),
	        				di.isConnected()?df.format(di.getConnected_datum()):"",
	        				di.getZucker(),
	        				di.getExtrakt()		
	        			);
	        	}
        	}
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "datum",
                "user",
                "proben_id",
                "proben_datum",
                "firmware",
                "dma_seriennummer",
                "xsample_seriennummer",
                "staerke",
                "dichte",
                "rel_dichte",
                "temp",
                "feld1",
                "feld2",
                "feld3",
                "bezeichnung",
                "losnummer",
                "z_user",
                "z_datum",
                "zucker",
                "extrakt"
              };

              private final Class[] COLUMN_TYPE = {
            		  Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final java.util.Date 	datum,
                final String			user,
                final String			proben_id,
                final String			proben_datum,
                final String			firmware,
                final String			dma_seriennummer,
                final String			xsample_seriennummer,
                final String			staerke,
                final String			dichte,
                final String			rel_dichte,
                final String			temp,
                final String			feld1,
                final String			feld2,
                final String			feld3,
                final String			bezeichnung,
                final String			losnummer,
                final String			z_user,
                final String			z_datum,
                final String			zucker,
                final String			extrakt
                )
        {
            	liste.add (new Object[] {
            			datum,
            			user,
            			proben_id,
            			proben_datum,
            			firmware,
            			dma_seriennummer,
            			xsample_seriennummer,
            			staerke,
            			dichte,
            			rel_dichte,
            			temp,
            			feld1,
            			feld2,
            			feld3,
            			bezeichnung,
            			losnummer,
            			z_user,
            			z_datum,
            			zucker,
            			extrakt
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

