/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import org.jfree.report.modules.gui.base.PreviewFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rezeptur.ChangesItem;
/**
 * @author labor
 *
 */
public class ChangesDrucken extends ReportAusgabe {

    int 						key;
    public static final String			DEFAULT_ORIENTATION="landscape";
    ArrayList<ChangesItem>			cliste;
    boolean											vorschau = false;
    /**
     *
     */
    public ChangesDrucken(RzPro r,Object reportData ,String optionKey,boolean vorschau,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        this.vorschau=vorschau;
        cliste = (ArrayList<ChangesItem>)reportData;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(cliste != null && !cliste.isEmpty()){
	            final Date datum = new Date();
	            SimpleDateFormat df_stunde = new SimpleDateFormat("HH:mm");
	            SimpleDateFormat df_field = new SimpleDateFormat("yyyy-MM-dd");
	            for (final ChangesItem ci : cliste) {
	            	modell.addItem(
	            			ci.getId(),
	            			ci.getRezeptur_id(),
	            			ci.getBezeichnung(),
	            			ci.getAlt(),
	            			ci.getNeu(),
	            			ci.getErstellt(),
	            			df_stunde.format(ci.getErstellt()),
	            			df_field.format(ci.getErstellt()),
	            			ci.getUser(), 
	            			ci.getRezeptur(),
	            			ci.getStichworte().toVerboseString(),
	            			ci.isRelevant()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),
	            			rz.getDatabase().dbGetUser(),
	            			datum
	            	);
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }

    public void printReport(){
        try{
            if(vorschau) {
                final PreviewFrame frame = new PreviewFrame(report);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            } else {
	            if (rz.getOptionFactory().getOption("printercommand").equals("printpreview")){
	                final PreviewFrame frame = new PreviewFrame(report);
	                frame.pack();
	                frame.setVisible(true);
	                frame.requestFocus();
	            } else {
					printDirectly(report);
				}
            }
        }
        catch (final Exception e){}
    }

    
    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"id", "rezeptur_id", "bezeichnung",
        		"alt","neu",
        		"erstellt_date",
        		"erstellt_stunde",
        		"erstellt_field",
        		"user1","rezeptur","stichworte",
        		"relevant","user","datum"
              };

              private final Class[] COLUMN_TYPE = {
                Integer.class,Integer.class,String.class,
                String.class, String.class,
                Date.class,
                String.class,
                String.class,
                String.class,String.class,String.class,
                String.class,String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		final int id, 
        		final int rezeptur_id, 
        		final String bezeichnung,
        		final String alt,
        		final String neu,
        		final Date erstellt_date,
        		final String erstellt_stunde,
        		final String erstellt_field,
        		final String user,
        		final String rezeptur,
        		final String stichworte,
        		final String relevant,
        		final String user1,
        		final Date datum
                )
        {
            	liste.add (new Object[] {id, rezeptur_id,bezeichnung,alt,neu,erstellt_date,erstellt_stunde,erstellt_field,user, rezeptur,stichworte, relevant,user1,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

