package de.lunqual.rzpro.ausgabe;

/*
 */

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.bewertungen.BewertungenColorItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.bewertungen.KategorieItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class BewertungDrucken extends ReportAusgabe {

	public static final String			DEFAULT_ORIENTATION="portrait";
	
	BewertungsItem						bi;
	
    public BewertungDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        bi = ((BewertungsItem)reportData);
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
    	Date now = new Date();
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(bi != null){
	        	String summenzeile = bi.getSummenZeile();
	        	BewertungenColorItem c = rz.getDatabase().getBewertungen().getColorItem();
	        	for (KategorieItem ki:bi.getKategorienListe()) {
		        	modell.addItem(
		        			rz.getDatabase().dbGetUser(),
		        			now,
		        			rz.getLocale().getString("bewertungdrucken.string_titelzeile").replaceAll("%b", bi.getBezeichnung()).replaceAll("%l", bi.getLosnummer()).replaceAll("%i", String.valueOf(bi.getId())),
		        			bi.getBezeichnung(),
		        			bi.getLosnummer(),
		        			bi.getComment() + "\n\n" + summenzeile,
		        			bi.isValid()?rz.getLocale().getString("bewertungdrucken.string_punkte").replaceAll("%v",c.getValue(bi.getBewertung())).replaceAll("%t",c.getText(bi.getBewertung())):rz.getLocale().getString("bewertungdrucken.string_nicht_bewertet"),
		        			bi.getBewertung(),
		        			c.getText(bi.getBewertung()),
		        			ki.getBezeichnung(),
		        			ki.getBewertung(),
		        			ki.getBewertung() >=0?rz.getLocale().getString("bewertungdrucken.string_kategorie_punkte").replaceAll("%v",rz.getLocale().formatNumber(ki.getBewertung(),OptionFactory.NF_TWO)):rz.getLocale().getString("bewertungdrucken.string_nicht_bewertet"),
		        			ki.getOriginalListe().getErgebnisseListeString(), 
		        			rz.getLocale().getString("bewertungdrucken.string_erstellt").replaceAll("%d",bi.getErstelltToString()).replaceAll("%u", bi.getErstellt_user()),
		        			bi.getErstellt_user(),
		        			rz.getLocale().getString("bewertungdrucken.string_geaendert").replaceAll("%d",bi.getGeaendertToString()).replaceAll("%u", bi.getGeaendert_user()),
		        			bi.getGeaendert_user()
		        		);
		        }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","datum",
                "titelzeile",
                "bezeichnung","losnummer","comment",
                "bewertung","punkte","bewertung_text",
                "kategorie_bezeichnung","kategorie_punkte","kategorie_bewertung","kategorie_unterpunkte",
                "erstellt_datum","erstellt_user","geaendert_datum","geaendert_user"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,java.util.Date.class,
                String.class,
                String.class,String.class,String.class,
                String.class,Double.class,String.class,
                String.class,Double.class,String.class,String.class,
                String.class,String.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final java.util.Date datum,
                final String titelzeile,
                final String bezeichnung,
                final String losnummer,
                final String comment,
                final String bewertung,
                final Double punkte,
                final String bewertung_text,
                final String kategorie_bezeichnung,
                final Double kategorie_punkte,
                final String kategorie_bewertung,
                final String kategorie_unterpunkte,
                final String erstellt_datum,
                final String erstellt_user,
                final String geaendert_datum,
                final String geaendert_user
               )
        {
            	liste.add (new Object[] {user,datum,titelzeile,bezeichnung,losnummer,comment,bewertung,punkte,bewertung_text,kategorie_bezeichnung,kategorie_punkte,kategorie_bewertung,kategorie_unterpunkte,erstellt_datum,erstellt_user,geaendert_datum,geaendert_user});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

