package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rezeptur.BestandswarnungsListe;
import de.lunqual.rzpro.options.OptionFactory;

public class BestandswarnungslisteDrucken extends ReportAusgabe {
    int 															key;
    public static final String						DEFAULT_ORIENTATION="portrait";
    /**
     *
     */
    public BestandswarnungslisteDrucken(RzPro r,Object reportData ,String optionKey,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        key = ((Integer)reportData).intValue();
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        Date now = new Date();
        modell = new tableModel();
        if(modell != null) {
			BestandswarnungsListe bl = rz.getDatabase().getRezeptur().getBestandswarnungen(false,false);
        	if(bl != null && bl.size()>0) {
        		
        		for(int i =	0;i < bl.size();i++) {
        			modell.addItem(
        					rz.getDatabase().dbGetUser(),
        					bl.getItem(i).getBezeichnung(),
        					rz.isZero(bl.getItem(i).getDiff())?"":rz.getLocale().formatNumber(bl.getItem(i).getDiff(),OptionFactory.NF_ONE),
        					now
        			);
        		}
		        report = getReport();
		        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
		        report.setQuery ("default");
        	}
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","name","liter","datum"
              };

              private final Class[] COLUMN_TYPE = {
                String.class, String.class, String.class, java.util.Date.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String name,
                final String liter,
                final java.util.Date datum
                )
        {
            	liste.add (new Object[] {user,name,liter,datum});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}
