/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsZeile;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class AusstattungCalcDrucken extends ReportAusgabe {

    AusstattungsItem ai = null;
    public static final String			DEFAULT_ORIENTATION="portrait";
    CurrencyItem zielWaehrung = null;
    /**
     *
     */
    public AusstattungCalcDrucken(RzPro r,Object reportData ,String optionKey,CurrencyItem waehrung,java.awt.Window w) {
        super(r,reportData,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        ai = (AusstattungsItem)reportData;
        zielWaehrung = waehrung;
       }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        if(modell != null) {
	        if(ai != null){
	            final String titel = ai.getTitel();
	            final String erstellt  = rz.getLocale().getString("string_erstellt").replaceAll("%s", ai.getErstelltToString()).replaceAll("%v",ai.getUser1());
	            final String geaendert = rz.getLocale().getString("string_geaendert").replaceAll("%s", ai.getGeaendertToString()).replaceAll("%v",ai.getUser2());
	            final String adressen = ai.getAdressListe().toVerboseString();
	            final String stichworte = ai.getStichwortListe().toVerboseString();
	            final Date datum = new Date();
	            if(ai.getZeilenListe().size() > 0) {
		            for (int i = 0; i < ai.getZeilenListe().size();i++) {
		            	String factor = "";
	            		if(ai.getZeilenListe().getItem(i).getMode() == AusstattungsZeile.MODE_MAL) {
	            			factor = rz.getLocale().getString("ausgabe.as_rechnen_mode_mal_faktor")
	            				.replaceAll("%s",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getFactor(), OptionFactory.NF_NORMAL));
	            		} else {
	            			factor =  rz.getLocale().getString("ausgabe.as_rechnen_mode_plus_faktor")
	        					.replaceAll("%s",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getFactor(), OptionFactory.NF_NORMAL));
	            		}


		                modell.addItem(rz.getDatabase().dbGetUser(),titel, adressen, stichworte, erstellt, geaendert, datum,
		                rz.getLocale().formatNumber(ai.getGebindegroesse(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_liter"),
		                rz.getLocale().formatNumber(ai.getGebindeGewicht(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_kg"),
		                rz.getLocale().formatNumber(ai.getPreis(),OptionFactory.NF_NORMAL) + " " + 	rz.getDatabase().getCurrency().dbGetCurrency(ai.getWaehrung(),true).getName(),
		                ai.getArtikelnummer(),
		                ai.getZeilenListe().getItem(i).getName(),
	            		rz.getLocale().getString("ausgabe.as_rechnen_einzelpreis_zeile")
	        				.replaceAll("%p",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getEinzelPreis(), OptionFactory.NF_NORMAL))
	        				.replaceAll("%w",ai.getZeilenListe().getItem(i).getWQuelle().getName()),
	        				factor,
	        			rz.getLocale().getString("ausgabe.as_rechnen_gesamtpreis_zeile")
	            			.replaceAll("%p",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getZeilenPreis(), OptionFactory.NF_NORMAL))
	            			.replaceAll("%w",ai.getZeilenListe().getItem(i).getWZiel().getName()),

						rz.getLocale().getString("ausgabe.as_rechnen_summe")
	        				.replaceAll("%p",rz.getLocale().formatNumber(ai.getGesamtPreis(), OptionFactory.NF_NORMAL))
	        				.replaceAll("%w",zielWaehrung.getName()),
						rz.getLocale().getString("ausgabe.as_rechnen_gesamtgewicht")
	        				.replaceAll("%g",rz.getLocale().formatNumber(ai.getGesamtGewicht(), OptionFactory.NF_NORMAL))
		                );
		            }
	            } else {
	                modell.addItem(rz.getDatabase().dbGetUser(),titel, adressen, stichworte, erstellt, geaendert, datum,
			                rz.getLocale().formatNumber(ai.getGebindegroesse(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_liter"),
			                rz.getLocale().formatNumber(ai.getGebindeGewicht(),OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_kg"),
			                rz.getLocale().formatNumber(ai.getPreis(),OptionFactory.NF_NORMAL) + " " + 	rz.getDatabase().getCurrency().dbGetCurrency(ai.getWaehrung(),true).getName(),
			                ai.getArtikelnummer(),
			                "","","","","",
			                ""
			                );
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
                "user","titel","adressen","stichworte","erstellt","geaendert","datum",
                "gebindegroesse","gebindegewicht","gebindepreis","artikelnummer",
                "bezeichnung", "einzelpreis", "stueckzahl", "zeilenpreis","gesamtpreis",
                "gesamtgewicht"
              };

              private final Class[] COLUMN_TYPE = {
                String.class,String.class, String.class, String.class, String.class, String.class,  java.util.Date.class,
                String.class,String.class,String.class,String.class,
                String.class,String.class,String.class,String.class,String.class,String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
                final String user,
                final String titel,
                final String adressen,
                final String stichworte,
                final String erstellt,
                final String geaendert,
                final java.util.Date datum,
                final String groesse,
                final String gewicht,
                final String preis,
                final String artikelnummer,
                final String bezeichnung,
                final String einzelpreis,
                final String stueckzahl,
                final String zeilenpreis,
                final String gesamtpreis,
                final String gesamtgewicht
                )
        {
            	liste.add (new Object[] {user,titel,adressen,stichworte,erstellt,geaendert,datum,groesse,gewicht,preis,artikelnummer,
            			bezeichnung,einzelpreis,stueckzahl,zeilenpreis,gesamtpreis,gesamtgewicht
            	});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

