/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.ausgabe;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.swing.Icon;
import javax.swing.JEditorPane;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBAdressen;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.database.DBKontrakte;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.abfrage.AbfrageListe;
import de.lunqual.rzpro.items.acid.AcidItem;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.bestellung.BestellungsItem;
import de.lunqual.rzpro.items.bestellung.LastOrdersItem;
import de.lunqual.rzpro.items.bewertungen.BewertungenColorItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.bewertungen.KategorieItem;
import de.lunqual.rzpro.items.bewertungen.UnterkategorieItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.ClientBuchungsItem;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.buchung.StatistikListenItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsItem;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.InventurSummenItem;
import de.lunqual.rzpro.items.kontrakt.kontraktItem;
import de.lunqual.rzpro.items.kontrakt.kontraktStatistikItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.mischungen.MischungenTankItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.paletten.PalettenItem;
import de.lunqual.rzpro.items.proben.ProbenItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsZeile;
import de.lunqual.rzpro.items.rezeptur.BestandswarnungsItem;
import de.lunqual.rzpro.items.rezeptur.BestandswarnungsListe;
import de.lunqual.rzpro.items.rezeptur.HinweisItem;
import de.lunqual.rzpro.items.rezeptur.NotizItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.SteuerDatenItem;
import de.lunqual.rzpro.items.statistik.StatistikItem;
import de.lunqual.rzpro.items.statistik.WerteItem;
import de.lunqual.rzpro.items.temperaturzone.temperaturZonenItem;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.items.trace.TraceLineItem;
import de.lunqual.rzpro.items.trace.TraceTextItem;
import de.lunqual.rzpro.items.verbrauch.VerbrauchsItem;
import de.lunqual.rzpro.items.verbrauch.VerbrauchsListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * AusgabeControl stellt Items als styled-Text in als Argumenten übergebenen
 * JTextPanes dar
 * Die Items werden dazu aus der Datenbank aktuell abgeholt. Wenn ein Datensatz
 * zwischenzeitlich nicht mehr existiert, wird ein Fehlertext ausgegeben.
 * @author  lunqual */
public class AusgabeFactory {

	private static String BEMERKUNGEN_PREFIX = "!!";

    RzPro               	rz;

    Icon            	    fehlerIcon;
    Icon		 		  	statistikMarkierung;

    // Farben und Styles
    String			color_text;
    String			color_background;
    String 			color_headline_background;
    String			color_headline_text;
    String			color_markup;
    String			color_erstellt_text;
    String			color_erstellt_back;
    String			color_geaendert_text;
    String			color_geaendert_back;
    String			color_adressen_text;
    String			color_adressen_back;
    String			color_stichworte_text;
    String			color_stichworte_back;
    String 			color_hinweis_text;
    String			color_hinweis_back;
    String			color_user_back;
    String			color_user_text;
    String			color_markup_green;
    String			color_markup_kunde;
    String 			color_markup_lieferant;

    public static final int					DIV_HEADLINE 							=	0;
    public static final int					DIV_MARKUP								=	1;
    public static final int					DIV_CONTENT								=  2;
    public static final int					DIV_BOLD								=	3;
    public static final int					DIV_SMALL								= 	4;
    public static final int					DIV_SMALL_BOLD							= 	5;
    public static final int					DIV_ERSTELLT							=	6;
    public static final int					DIV_GEAENDERT							=	7;
    public static final int					DIV_ADRESSEN							= 	8;
    public static final int					DIV_STICHWORTE							= 	9;
    public static final int					DIV_NORMAL								=	10;
    public static final int					DIV_RED_HEADLINE						= 	11;
    public static final int					DIV_HINWEIS								= 12;
    public static final int					DIV_HEADLINE_LEFT						= 13;
    public static final int					DIV_BESTANDSWARNUNG						= 14;
    public static final int					DIV_HEADLINE_YELLOW						= 15;
    public static final int					DIV_MARKUP_BORDER						= 16;
    public static final int					DIV_NORMAL_BORDER						= 17;
    public static final int					DIV_MARKUP_GREEN						= 18;
    public static final int					DIV_MARKUP_LIEFERANT					= 19;
    public static final int					DIV_MARKUP_KUNDE						= 20;
    public static final int					DIV_ROT									= 21;
    public static final int					DIV_BLAU								= 22;
    public static final int					DIV_GRUEN								= 23;
    public static final int					DIV_ROT1								= 24;
    
    /** Creates a new instance of AusgabeControl */
    public AusgabeFactory(RzPro r)  {
        rz = r;
        setStyles();
        fehlerIcon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/fehler.png"));
    }

    private void setStyles() {
        color_background="#"+rz.getOptionFactory().getHexColor("auswahl.color_background");
        color_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_text");
        color_headline_background="#"+rz.getOptionFactory().getHexColor("auswahl.color_headline_background");
        color_headline_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_headline_text");
        color_markup="#"+rz.getOptionFactory().getHexColor("auswahl.color_markup");
        color_markup_green="#"+rz.getOptionFactory().getHexColor("auswahl.color_markup_green");
        color_erstellt_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_erstellt_text");
        color_erstellt_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_erstellt_back");
        color_geaendert_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_geaendert_text");
        color_geaendert_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_geaendert_back");
        color_adressen_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_adressen_text");
        color_adressen_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_adressen_back");
        color_stichworte_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_stichworte_text");
        color_stichworte_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_stichworte_back");
        color_hinweis_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_hinweis_text");
        color_hinweis_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_hinweis_back");
        color_user_back="#"+rz.getOptionFactory().getHexColor("auswahl.color_yellow_back");
        color_user_text="#"+rz.getOptionFactory().getHexColor("auswahl.color_yellow_text");
        color_markup_kunde=DBAdressen.COLOR_KUNDE;
        color_markup_lieferant=DBAdressen.COLOR_LIEFERANT;
    }
    /**
     * gibt einen String mit "<div style=" zurück
     * @param int  Style
     * @param int  UserDefined
     * @return String "style=......"
     */
    public String insertStyle(int style,int userDefined) {
    	String ret = "style=\"";
    	switch (style) {

    		case DIV_NORMAL :
    			ret += "color:" + color_text + ";background-color:" + color_background + ";font-size:" + String.valueOf(userDefined) + ";font-weight:normal";
    			break;
    		case DIV_NORMAL_BORDER :
    			ret += "color:" + color_text + ";background-color:" + color_background + ";font-size:" + String.valueOf(userDefined) + ";font-weight:normal"+";border-width:1px;border-style:solid;";
    			break;
    		case DIV_HEADLINE: // UserDefined == font size
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined +2) + ";font-weight:bold;background-color:" + color_headline_background + ";color:" +color_headline_text ;
    			break;
    		case DIV_MARKUP: //USerDefined == font-size
    			ret += "text-align:right;font-size:" + String.valueOf(userDefined) + ";font-weight:bold;color:" + color_markup;
    			break;
    		case DIV_MARKUP_GREEN: //USerDefined == font-size
    			ret += "text-align:right;font-size:" + String.valueOf(userDefined) + ";font-weight:bold;color:" + color_markup_green;
    			break;
    		case DIV_MARKUP_BORDER: //USerDefined == font-size
    			ret += "text-align:right;font-size:" + String.valueOf(userDefined) + ";font-weight:bold;color:" + color_markup+";border-width:1px;border-style:solid;";
    			break;
    		case DIV_CONTENT://UserDefinde == fontsize
       			ret += "text-align:left;font-size:" + String.valueOf(userDefined) + ";font-weight:normal;color:" +color_headline_text;
    			break;
    		case DIV_BOLD:
    			ret += "font-weight:bold";
    			break;
    		case DIV_SMALL:
    			ret += "font-size:" + String.valueOf(userDefined - 2) ;
    			break;
    		case DIV_SMALL_BOLD:
    			ret += "font-size:" + String.valueOf(userDefined - 2) + ";font-weight:bold";
    			break;

    		case DIV_ERSTELLT: // UserDefined == font size
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:normal;background-color:" + color_erstellt_back + ";color:" +color_erstellt_text ;
    			break;
    		case DIV_GEAENDERT: // UserDefined == font size
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:normal;background-color:" + color_geaendert_back + ";color:" +color_geaendert_text ;
    			break;
    		case DIV_ADRESSEN: // UserDefined == font size
    	        ret += "text-align:left;font-size:" + String.valueOf(userDefined ) + ";font-weight:normal;background-color:" + color_adressen_back + ";color:" +color_adressen_text ;
    			break;
    		case DIV_STICHWORTE: // UserDefined == font size
    	        ret += "text-align:left;font-size:" + String.valueOf(userDefined ) + ";font-weight:normal;";
    			break;
    		case DIV_RED_HEADLINE: // UserDefined == font size
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined +3) + ";font-weight:bold;background-color:red;color:white" ;
    			break;
    		case DIV_HINWEIS: // UserDefined == font size
    	        ret += "text-align:center;font-weight:normal;font-size:" + String.valueOf(userDefined ) +";background-color:" + color_hinweis_back + ";color:" +color_hinweis_text ;
    			break;
    		case DIV_HEADLINE_LEFT: // UserDefined == font size
    	        ret += "text-align:left;font-size:" + String.valueOf(userDefined +2) + ";font-weight:bold;background-color:" + color_headline_background + ";color:" +color_headline_text ;
    			break;
    		case DIV_HEADLINE_YELLOW: // UserDefined == font size
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:bold;background-color:" + color_user_back + ";color:" +color_user_text ;
    			break;
    		case DIV_MARKUP_KUNDE: //USerDefined == font-size
    			ret += "text-align:right;font-size:" + String.valueOf(userDefined) + ";font-weight:bold;color:" + color_markup_kunde;
    			break;
    		case DIV_MARKUP_LIEFERANT: //USerDefined == font-size
    			ret += "text-align:right;font-size:" + String.valueOf(userDefined) + ";font-weight:bold;color:" + color_markup_lieferant;
    			break;
    		case DIV_ROT:
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:normal;background-color:red;color:white";
    			break;
    		case DIV_BLAU:
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:bold;background-color:white;color:blue";
    			break;
    		case DIV_GRUEN:
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:bold;background-color:white;color:green";
    			break;
    		case DIV_ROT1:
    	        ret += "text-align:center;font-size:" + String.valueOf(userDefined ) + ";font-weight:bold;background-color:white;color:red";
    			break;
    	}
    	return ret + ";\"";
    }

    /**
     * gibt den HTML-String zum einfügen eines Bildes aus dem Klassenpfad zurück
     * @param image Name des Bildes
     * @return String "<img src=.......>"
     */
    public String insertGfx(String image) {
    	String ret = "";
    	try {
    		 ret = "<img src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/"+image).toString() + "\" border=\"0\">";
    	}catch(final Exception e) {
    	}
    	return ret;
    }
    
    public String insertGfx(String image,String alt) {
    	String ret = "";
    	try {
    		 ret = "<img  src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/"+image).toString() + "\" border=\"0\""  + "   alt=\"" + alt +"\">";
    	}catch(final Exception e) {
    	}
    	return ret;
    }
    /** void displayNotFoundError(JTextPane) gibt einen Fehlertext aus, wenn
     * ein Datensatz nicht mehr in der Datenbank gefunden werden konnte
     */
    private void displayNotFoundError(JEditorPane aPane){
    	String inhalt = "<html><head></head>";
        aPane.setEditable(true);
        aPane.setText("");
        inhalt += "<img src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/fehler.png").toString() + "\"><br>";
        inhalt += rz.getLocale().getString("ausgabe.fehler_not_found").replaceAll("<br>","\n") +"\n";
        inhalt += "</body></html>";
        aPane.setText(inhalt);
        aPane.setEditable(false);
    }

    public void kontrakteAusgabe(JEditorPane aPane,kontraktItem ki) {
		setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	String inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";font-size:" + fontsize + "\">";
		if(ki != null) {
			inhalt += "<div " + insertStyle(DIV_HEADLINE,fontsize) + ">";
         	inhalt +=  rz.getLocale().getString("ausgabe.kontrakte_titelzeile").replaceAll("%n", ki.getName()).replaceAll("%m", rz.getLocale().formatNumber(ki.getMenge(),OptionFactory.NF_ONE)).replaceAll("%e", rz.getDatabase().getEinheiten().getGrundeinheit(ki.getEinheit()).getName())+ "<br></div>";
         	// erstellt
         	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
         		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ki.getErstelltToString()).replaceAll("%v",ki.getErstelltUserString());
         	inhalt += "</div>";
         	//geändert
         	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
         		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ki.getGeaendertToString()).replaceAll("%v",ki.getGeaendertUserString()) ;
         	inhalt += "</div>";
			//Typ
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.typ") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + (ki.getTyp() == DBKontrakte.KONTRAKT_EINKAUF?rz.getLocale().getString("kontrakte.typ_einkauf"): rz.getLocale().getString("kontrakte.typ_verkauf")) + "</td>";
			inhalt +="</tr>";
			//Rezeptur
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.rezeptur") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ki.getName() + "</td>";
			inhalt +="</tr>";
			//Adresse
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.adresse") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ki.getAdresseText() + "</td>";
			inhalt +="</tr>";
			//menge
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.menge") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + rz.getLocale().formatNumber(ki.getMenge(), OptionFactory.NF_ONE) + " " +  rz.getDatabase().getEinheiten().getGrundeinheit(ki.getEinheit()).getName() + "</td>";
			inhalt +="</tr>";
			//start datum
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.startdatum") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ki.getStartDateToString() + "</td>";
			inhalt +="</tr>";
			//end datum
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.enddatum") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ki.getEndDateToString() + "</td>";
			inhalt +="</tr>";			
			//aktiv
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.aktiv") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + (ki.isAktiv()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein")) + "</td>";
			inhalt +="</tr>";
			//abgerufen
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.abgerufen") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + rz.getLocale().formatNumber(ki.getAbgerufen(), OptionFactory.NF_ONE) + " " 
							+  rz.getDatabase().getEinheiten().getGrundeinheit(ki.getEinheit()).getName() + 
							"  (" + rz.getLocale().formatNumber((ki.getAbgerufen()*100)/ki.getMenge(),OptionFactory.NF_NORMAL) + " %)"+
							"</td>";
			inhalt +="</tr>";
			
			kontraktStatistikItem ksi = new  kontraktStatistikItem(rz, ki);
			if(ksi.hasElements()) {
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.statistik") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ksi.getHTMLString() + "</td>";
				inhalt +="</tr>";	
			}
			

			
			
			//bemerkungen
        	inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.kontrakte.bemerkungen") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ki.getBemerkungen().replaceAll("\n", "<br>") + "</td>";
			inhalt +="</tr>";	
			//------
			inhalt +="</div></body></html>";
    		aPane.setText(inhalt);
    		aPane.setCaretPosition(0);
		}else {
			aPane.setText("<html></html>");
		}
}
    
    public void TraceAusgabe(JEditorPane aPane,TraceItem tr) {
    		setStyles();
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
        	String inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";font-size:" + fontsize + "\">";
    		if(tr != null) {
    			for(TraceLineItem zeile:tr.getText().getZeilen()) {
    				switch(zeile.getTyp()) {
    					case TraceTextItem.TRACE_H1: inhalt += "<h1>" + zeile.toHTMLString()+"</h1><br>";break;
    					case TraceTextItem.TRACE_H2: inhalt += "<h2>" + zeile.toHTMLString()+"</h2><br>";break;
    					case TraceTextItem.TRACE_H3: inhalt += "<h3>" + zeile.toHTMLString()+"</h3><br>";break;
    					case TraceTextItem.TRACE_TEXT: inhalt += zeile.toHTMLString()+"<br>";break;
    				}
    			}
    			inhalt +="</div></body></html>";
        		aPane.setText(inhalt);
        		aPane.setCaretPosition(0);
    		}else {
    			aPane.setText("<html></html>");
    		}
    }
    
    public void MischungsAusgabe(JEditorPane aPane,MischungsItem mi,boolean mischungenAnzeigen) {
        setStyles();    
        if(mi != null) {
        	MischungsItem mi1 = rz.getDatabase().getMischungen().getMischung(mi.getHeader().getId());
        	if(mi1 != null) {
        		if(mi1.getLA() != mi.getLA()) {
        			rz.getDatabase().getMischungen().updateMischungLA(mi1);
        		}
        	}
        	String inhalt = "<html><head></head><body>";
        	inhalt += mischungsAusgabe(mi,mischungenAnzeigen);
        	//inhalt += ticketAusgabe(mi.getHeader().getId(),mi.getAllTickets(),true,mischungenAnzeigen); 
        	inhalt += "</body></html>";
    		aPane.setText(inhalt);
    		aPane.setCaretPosition(0);
        } else {
        	aPane.setText("");
        }
    }

    public void ticketAusgabe(JEditorPane aPane,int mischung,TicketListe tl,boolean mischungenAnzeigen) {
        setStyles();
        if(tl != null) {
        	String inhalt = "<html><head></head><body>";
        	inhalt += ticketAusgabe(mischung,tl,false,mischungenAnzeigen);
        	inhalt += "</body></html>";
    		aPane.setText(inhalt);
        }else {
        	aPane.setText("");
        }
        aPane.setCaretPosition(0);
    }
    
    public String mischungsAusgabe(MischungsItem mi,boolean mischungenAnzeigen) {

    	final int fontsize = rz.getFontFactory().getTextPaneFont().getSize();
    	String inhalt = "<center>";
    	inhalt += "<div " + insertStyle(DIV_HEADLINE,fontsize) + ">";
     	inhalt += insertGfx("mischung.png") + rz.getLocale().getString("ausgabe.mischung_titelzeile")
     			.replaceAll("%s", mi.getHeader().getBezeichnung())
     			.replaceAll("%t",mi.getHeader().getTank())
     			.replaceAll("%n", String.valueOf(mi.getHeader().getId()))+
     			"<br></div>";
     	// erstellt
     	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
     		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",mi.getErstelltToString()).replaceAll("%v",mi.getHeader().getErstellt_user());
     	inhalt += "</div>";
     	//geändert
     	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
     		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",mi.getGeaendertToString()).replaceAll("%v",mi.getHeader().getGeaendert_user()) ;
     	inhalt += "</div>";
     	//abgeschlossen
     	if(!mi.getHeader().isActive()) {
	     	inhalt += "<div " + insertStyle(DIV_RED_HEADLINE,fontsize) + ">";
	     		inhalt += rz.getLocale().getString("string_abgeschlossen").replaceAll("%s",mi.getAbgeschlossenToString()).replaceAll("%v",mi.getHeader().getAbgeschlossen_user()) ;
	     	inhalt += "</div>";
     	}
    	inhalt += "<table>";
    		inhalt +="<tr>";
	     	inhalt += "</div>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.mischung_sorte") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + mi.getHeader().getSorte().getBezeichnung() + "</td>";
			inhalt +="</div>";
			inhalt +="</tr>";
				inhalt +="<tr>";
					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.msichung_rezeptur") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +  rz.getDatabase().getRezeptur().dbGetRezepturNameNEX(mi.getHeader().getRezeptur_id())+ "</td>";
				inhalt +="</tr>";
	     	inhalt += "</div>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.mischung_losnummer") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + mi.getHeader().getLosnummer() + "</td>";
			inhalt +="</div>";
			inhalt +="</tr><tr>";
	     	inhalt += "</div>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.mischung_la") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().formatNumber(mi.getLA(), OptionFactory.NF_NORMAL) + "</td>";
			inhalt +="</div>";
			inhalt +="</tr><tr>";
	     	inhalt += "</div>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.mischung_bemerkungen") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + mi.getHeader().getBemerkungen().replaceAll("\\\n", "<br>") + "</td>";
			inhalt +="</div>";					
		inhalt +="</tr>";		
		inhalt +="</table>";
    	return inhalt + "</center>";
    }
    
    public String ticketAusgabe(int mischung,TicketListe tl,boolean link_alle,boolean mischungenAnzeigen) {
    	final int fontsize = rz.getFontFactory().getTextPaneFont().getSize();
    	String inhalt ="";
    	for(TicketItem ti:tl) {
        	inhalt += "<table  style=\"padding:1px;border-width:1px;border-style:solid;\">";
    		inhalt += "<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_typ") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + insertGfx(rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getIconString()) + "&nbsp;" + rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText()+ "</td>";
			inhalt +="</tr><tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_bezeichnung") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getBezeichnung()+ "</td>";
				if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
					inhalt +="</tr>";
						inhalt +="<tr>";
						inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_sorte") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +  rz.getDatabase().getMischungen().getSorte(ti.getSorte()).getBezeichnung().trim()+ "</td>";
					inhalt +="</tr>";
					inhalt +="</tr>";
						inhalt +="<tr>";
							inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_rezeptur") + "</td>";
							inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +  rz.getDatabase().getRezeptur().dbGetRezepturNameNEX(ti.getRezeptur_id())+ "</td>";
						inhalt +="</tr>";
				}
				inhalt += "<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_original_losnummer") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getLosnummer_original()+ "</td>";
			inhalt +="</tr><tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_nummer") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getNummer()+ "</td>";
			inhalt += "</tr>";
			inhalt +="</tr><tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_aktion") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + String.valueOf(ti.getTransaktion())+ "</td>";
			inhalt +="</tr><tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_erstellt") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getErstelltToString2()+ "</td>";
			inhalt +="</tr><tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_geaendert") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getGeaendertToString2()+ "</td>";
			inhalt +="</tr>";
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				inhalt += "<tr>";
					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_la") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().formatNumber(ti.getLa(),OptionFactory.NF_NORMAL)+ "</td>";
				inhalt += "</tr>";	
				inhalt += "<tr>";
					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_staerke") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().formatNumber(ti.getStaerke(),OptionFactory.NF_NORMAL)+ " % Vol </td>";
				inhalt += "</tr>";
			}
			if(!ti.getLosnummer().equals("")) {
				inhalt += "<tr>";
					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_losnummer") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getLosnummer()+ "</td>";
				inhalt += "</tr>";
			}
			inhalt += "<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_bemerkungen") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getBemerkungen().replaceAll("\\n", "<br>")+ "</td>";
			inhalt += "</tr>";
			if(ti.getAdresse_id() != 0) {
				inhalt += "<tr>";
					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_adresse") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ti.getAdresse()+ "</td>";
				inhalt += "</tr>";
			}
			if(ti.getTyp() == TicketItem.TYP_WARE) {
				if(mischungenAnzeigen) {
					String mischungen = rz.getDatabase().getMischungen().getmischungenFromTicketNummerHTML(mischung,ti.getNummer(),link_alle);
					if(!mischungen.equals("")) {
						inhalt += "<tr>";
							inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_mischungen") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + mischungen+ "</td>";
						inhalt += "</tr>";
					}
				}
			}
			if(ti.getProbe() != 0) {
				inhalt += "<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_probe") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +insertGfx("ausgabe.icon_probe.png")+  String.valueOf(ti.getProbe())+ "</td>";
			inhalt += "</tr>";
			}
			if(ti.getBewertung() != 0) {
				inhalt += "<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_bewertung") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +rz.getLocale().getString("ticketeingabe.label_bewertung")
	    				.replaceAll("%n", String.valueOf(ti.getBewertung()))
	    				.replaceAll("%v",  rz.getDatabase().getBewertungen().getColorItem().getValue(ti.getBewertungValue()) + 
	    						" " + rz.getLocale().getString("punkte") + " " +
	    						"  ("+ rz.getDatabase().getBewertungen().getColorItem().getText(ti.getBewertungValue()) +")"	)+ "</td>";
			inhalt += "</tr>";
			}
			if(!ti.getKontrolle().trim().equals("")) {
				inhalt +="<tr>";
				inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ticket_kontrolle") + "</td>";
		    	inhalt += "<td>" + rz.getLocale().getString("ticketeingabe.label_kontrolle").replaceAll("%d", ti.getKontrolle_datum_text()).replaceAll("%s", ti.getKontrolle()) + "</td>";
		    	inhalt +="</tr>";
			}
			  if(rz.getDatabase().getDM().isConnected()) {
				  inhalt +="<tr><td></td><td>";
		            final SimpleDateFormat df1=new SimpleDateFormat("EEEE, dd. MMMM yyyy  H:mm");
		            String s = rz.getLocale().getString("dbdm.ticketmuster").replaceAll("%t", ti.getNummer()).replaceAll("%m", String.valueOf(ti.getMischung()));
		           	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(s);
		        	if(dmliste != null && !dmliste.isEmpty()) {
		        			for(DMItem dm:dmliste) {
			            		inhalt +="<div style=\"background-color:ddffdd;\"><br><center>";
			            			if(dm.getStaerke().length() > 2){
			            			inhalt += rz.getLocale().getString("ausgabe.herstellung.dma")
			            					.replaceAll("%n",dm.getProben_id())
			            					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
			            					.replaceAll("%s",dm.getStaerke())
			            					.replaceAll("%g",dm.getDichte())
			            					.replaceAll("%1", dm.getFeld1())			       
			            					;
			            			} else {
				            			inhalt += rz.getLocale().getString("ausgabe.herstellung.dmz")
				            					.replaceAll("%n",dm.getProben_id())
				            					.replaceAll("%d",df1.format(dm.getDatum_zeit()))
				            					.replaceAll("%z",dm.getZucker())
				            					.replaceAll("%e",dm.getExtrakt())
				            					.replaceAll("%g",dm.getDichte())
				            					.replaceAll("%1", dm.getFeld1())
				            					;
			            			}
			            		inhalt +="&nbsp;<br>&nbsp;<br></center></div>";
			            	}
		            	}
		        	inhalt +="</td></tr>";
			  }
			inhalt += "</table><br>";
    	}
    	return inhalt;
    }
    
    public void bewertungsAusgabe(JEditorPane aPane,BewertungsItem bi) {
        setStyles();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
        if(bi != null) {
        	bi.rechnen();
        	String inhalt = "<html><head></head><body><center>";
	    	inhalt += "<div " + insertStyle(DIV_HEADLINE,fontsize) + ">";
         	inhalt += insertGfx("bewertung.png") + rz.getLocale().getString("ausgabe.bewertungen_titelzeile").replaceAll("%b", bi.getBezeichnung()).replaceAll("%l", bi.getLosnummer()) + "<br></div>";
         	// erstellt
         	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
         		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",bi.getErstelltToString()).replaceAll("%v",bi.getErstellt_user());
         	inhalt += "</div>";
         	//geändert
         	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
         		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",bi.getGeaendertToString()).replaceAll("%v",bi.getGeaendert_user()) ;
         	inhalt += "</div>";
         	//kontrolle
         	if(!bi.getKontrolle().equals("")) {
         		inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
     				inhalt += rz.getLocale().getString("string_kontrolle").replaceAll("%d",bi.getKontrolleDatumToString()).replaceAll("%u",bi.getKontrolle()) ;
     			inhalt += "</div>";
         	}
    		if(bi.isValid()) {
    			BewertungenColorItem c = rz.getDatabase().getBewertungen().getColorItem();
    		    inhalt += "<div style=\"text-align:center;font-size:" + String.valueOf(fontsize +4) + ";font-weight:bold;background-color:#" +	c.getBg(bi.getBewertung())+ ";color:#" + c.getFg(bi.getBewertung()) + "\">";
    			inhalt +=  rz.getLocale().getString("ausgabe.bewertungen_bewertung")
    					.replaceAll("%v",c.getValue(bi.getBewertung()))
    					.replaceAll("%t",c.getText(bi.getBewertung()));    		    
    		    inhalt += "</div>";
    		}else {
    			inhalt += "<div " + insertStyle(DIV_RED_HEADLINE,fontsize+4) + ">"+ rz.getLocale().getString("ausgabe.bewertungen_bewertung_invalid") + "</div>";
    		}
        	inhalt += "<table  style=\"padding:1px;border-width:0px;border-style:solid;\">";
        		inhalt += "<tr>";
        			inhalt += "<td  style=\"padding:1px;border-width:1px;border-style:solid;\">";
                	inhalt += "<table  style=\"padding:1px;border-width:1px;border-style:solid;\">";
	        			for(KategorieItem ki:bi.getKategorienListe()) {
	        				inhalt += "<tr>";
	        				inhalt += "<tr>";
	        					inhalt += "<td>" + rz.getAusgabeFactory().insertGfx(ki.isValid()?"bewertungseingabefenster.icon_bewertet.png":"bewertungseingabefenster.icon_unbewertet.png") + "</td>"; //icon
	        					inhalt += "<td><h1>" + ki.getBezeichnung() + "</h1></td>"; //überschrift
	        					inhalt += "<td>&nbsp;</td>"; // in der überschrift leer
	        					inhalt += "<td>&nbsp;</td>"; // in der überschrift leer
	        					inhalt += "<td><h1>" + (ki.getBewertung() > 0?rz.getLocale().getString("bewertungsItem.bewertung_punkte").replaceAll("%p",rz.getLocale().formatNumber(ki.getBewertung(), OptionFactory.NF_TWO)):"") + "</h1></td>"; //Bewertung
	        				inhalt += "</tr>";
	        				for(int i=0;i < ki.getListe().size();i++) {
	        					UnterkategorieItem uki = ki.getOriginalListe().getItem(i);
	        					if (uki.isBewertet()) {
	        						inhalt += "<tr style=\"padding:5px;border-width:0px;border-style:solid;\">";
	        						inhalt += "<td>&nbsp;</td>"; //icon
	        						inhalt += "<td>&nbsp;</td>"; 
	        						inhalt += "<td>" + rz.getAusgabeFactory().insertGfx("bewertungseingabefenster.icon_bewertet.png") + "</td>"; //icon
	        						inhalt += "<td>" + uki.getBezeichnung() + "</td>"; //überschrift
	        						inhalt += "<td>" + rz.getLocale().getString("bewertungsItem.bewertung_punkte").replaceAll("%p",rz.getLocale().formatNumber(uki.getBewertung(), OptionFactory.NF_TWO)) + "</td>"; //Bewertung
	        					inhalt += "</tr>";
	        					}
	        				}
	        				inhalt += "<tr  style=\"padding:1px;spacing:5px;border-width:1px;border-style:solid;\"></tr>";
	        			inhalt += "</tr>";
	        			}
        			inhalt += "</table>";
        			inhalt += "</td>";
        			inhalt += "<td  style=\"padding:1px;border-width:1px;border-style:solid;\">";
        				inhalt += bi.getComment().replaceAll("\\n", "<br>") + "<br><br>" + bi.getSummenZeile().replaceAll("\\n", "<br>");
        			inhalt += "</td>";
        		inhalt += "</tr>";
        	inhalt += "</table>";
    		inhalt += "</center></body></html>";
    		aPane.setText(inhalt);
        }else {
        	displayNotFoundError(aPane);
        }
    }
    
    public void dmlistenAusgabe(DMItem di,JEditorPane aPane){
        setStyles();
        if (di != null){
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            SimpleDateFormat df = new SimpleDateFormat("EEEE dd. MMMM yyyy HH:mm");
        	inhalt =  "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
           	
	       		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_firmware") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getFirmware() + "</td>";
				inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_dma") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getDma_seriennummer() + "</td>";
				inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_xsample") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getXsample_seriennummer() + "</td>";
				inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_datum") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + df.format(di.getDatum_zeit()) + "</td>";
				inhalt += "</tr>";
				inhalt+="<tr><td></td><tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_probenid") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getProben_id() + "</td>";
           		inhalt += "</tr>";
           		if(di.isConnected()) {
	           		inhalt += "<tr>";
	   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_zugewiesen_am") + "</td>";
	   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + df.format(di.getConnected_datum()) + "</td>";
	           		inhalt += "</tr>";
	           		inhalt += "<tr>";
	   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_zugewiesen_von") + "</td>";
	   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getConnected_user() + "</td>";
           		inhalt += "</tr>";
           		}
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_bezeichnung") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getBezeichnung() + "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_losnummer") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getLosnummer()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_staerke") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getStaerke()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_zucker") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getZucker()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_extrakt") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getExtrakt()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_dichte") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getDichte()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td "+ insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_rel_dichte") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getRel_dichte()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_temperatur") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getDichte_temperatur()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_status") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getStatus()+ "</td>";
           		inhalt += "</tr>";
           		inhalt += "<tr><td></td></tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_feld1") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" +di.getFeld1() + "</td>";
				inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_feld2") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getFeld2() + "</td>";
				inhalt += "</tr>";
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dm_feld3") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + di.getFeld3() + "</td>";
				inhalt += "</tr>";
           	inhalt += "</table></body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }else {
            aPane.setEditable(true);
            aPane.setText("");
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
    }
    
    public void auftragslistenAusgabe(ArrayList<AuftragsItem> ail,AuftragsItem ai,JEditorPane aPane){
        setStyles();
        String inhalt = "";
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
        if (ai != null){
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ai.getErstelltToString()).replaceAll("%v",ai.getErstellt_user()) ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ai.getGeaendertToString()).replaceAll("%v",ai.getGeaendert_user()) ;
           	inhalt += "</div>";       
           	if(ai.isErledigt()) {
       			inhalt += "<div style=text-align:center;font-size:" + String.valueOf(fontsize+2) + ";font-weight:bold;background-color:#ffffff;color:#000000>";
      			inhalt += rz.getLocale().getString("ausgabe.auftragsliste_erledigt").replaceAll("%s", ai.getErledigtToString()).replaceAll("%u",ai.getErledigt_user());
       			inhalt+="</div>";
           	}else {
           		inhalt+="<div style=";
           			inhalt += "text-align:center;font-size:" + String.valueOf(fontsize+2) + ";font-weight:bold;background-color:#"  + ai.getHg() + ";color:#" +ai.getVg() +">";
           			inhalt += rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]+ ",&nbsp;"+ rz.getLocale().getString("ausgabe.auftragsliste_faellig").replaceAll("%s", ai.getFaelligToString());;
           		inhalt +="</div>";
           	}
           	if(ai.isInarbeit()) {
       			inhalt += "<div style=text-align:center;font-size:" + String.valueOf(fontsize+2) + ";font-weight:bold;background-color:#ffffff;color:#000000>";
       			inhalt += insertGfx("auftragslistenfenster.icon_inarbeit.png");
      			inhalt += rz.getLocale().getString("ausgabe.auftragsliste_inarbeit").replaceAll("%s",ai.getInArbeitToString());
       			inhalt+="</div>";
           	}
           	if(ai.isArbeitsAuftrag()) {
           		inhalt += "<br><div style=text-align:center;font-size:" + String.valueOf(fontsize+2) + ";font-weight:bold;>" + 
       				ai.getBezeichnung() +
       				"</div><br>";
           	}else {
           		inhalt += "<br><div style=text-align:center;font-size:" + String.valueOf(fontsize+2) + ";font-weight:bold;>" + 
       				rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_NORMAL) + "&nbsp;" + rz.getLocale().getString("string_liter") + "&nbsp;"+
       				ai.getBezeichnung() +
       				"</div><br>";
           	}
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
       		inhalt += "<tr>";
	   		if(ai.isRepeat()) {
	   			inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.auftrage.label_repeat") + "</td>";
   				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getDatabase().getAuftrag().getRepeatSpanListe().get(ai.getRepSpan()).getSpanString(ai)  + "</td>";
       		inhalt +="</tr>";
	   		}
   			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.auftrage.label_user") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getArbeit_user() + "</td>";
	   		inhalt +="</tr>";
       		inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.auftrage.label_bemerkungen") + "</td>";
   				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getComment().replaceAll("\\n","<br>") + "</td>";
       		inhalt +="</tr>";
			inhalt += "</table>";    
            inhalt +="</body></html>";

        }
        else if (ail != null){
        	inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
        	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
       		inhalt += rz.getLocale().getString("ausgabe.auftraege.multi_header");
       		inhalt += "</div><center>";
        	for(AuftragsItem ai1:ail) {
        		inhalt += rz.getLocale().formatNumber(ai1.getLiter(),OptionFactory.NF_ONE) + "&nbsp;" + rz.getLocale().getString("string_liter") + "&nbsp;" + ai1.getBezeichnung() + "<br>";
        	}
            inhalt +="</center></body></html>";
        } 
        aPane.setEditable(true);
        aPane.setText(inhalt);
        aPane.setCaretPosition(0);
        aPane.setEditable(false);
    }
    
    
    public void clientBuchungenAusgabe(ArrayList<ClientBuchungsItem> liste,JEditorPane aPane) {
        setStyles();
        final SimpleDateFormat df=new SimpleDateFormat("HH:mm");
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();    	
    	String inhalt = "";
        inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
        
        inhalt +="<center>";
        	inhalt+= "<b>" + rz.getLocale().getString("clientausgabe.buchungen_header")
        		.replaceAll("%u",rz.getDatabase().dbGetUser())
        	+ "</b>";
        inhalt += "</center>";
        
    	inhalt += "<table  style=\"padding:5px;border-width:2px;border-style:solid;\">";
       	inhalt += "<tr>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_datum")+ "</td>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_nummer")+ "</td>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_bezeichnung")+ "</td>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_liter")+ "</td>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_losnummer")+ "</td>";
       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + rz.getLocale().getString("clientausgabe.tableheader_user")+ "</td>";
       	inhalt+="</tr>";
        if(liste != null && !liste.isEmpty()) {
    		for (int i = 0;i < liste.size();i++) {
    			ClientBuchungsItem bi = liste.get(i);
    			inhalt += "<tr>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + df.format(bi.getDatum()) + "</td>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">";
	           		inhalt += "<div " + insertStyle(DIV_BLAU,fontsize) + ">";
	           		inhalt += String.valueOf(bi.getId()) + "</div></td>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + bi.getBezeichnung() + "</td>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">";  
    	       		if(bi.getLiter()<0) {
    	           		inhalt += "<div " + insertStyle(DIV_ROT1,fontsize) + ">";
    	       		}else {
    	           		inhalt += "<div " + insertStyle(DIV_GRUEN,fontsize) + ">";
    	       		}
    	       		inhalt += rz.getLocale().formatNumber(bi.getLiter(),OptionFactory.NF_ONE) + "</div></td>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">";
    	       		inhalt += "<div " + insertStyle(DIV_BLAU,fontsize) + ">";
           			inhalt += bi.getLosnummer() + "</div></td>";
    	       	inhalt +="<td   style=\"padding:5px;border-width:2px;border-style:solid;\">"  + bi.getUser()+ "</td>";
    	       	inhalt += "</tr>";
    		}
    		inhalt += "</table>";
    	}else {
    		inhalt="";
    	}
    	aPane.setEditable(true);
        aPane.setText(inhalt.replace(" ","&nbsp;") );
        aPane.setCaretPosition(0);
    	aPane.setEditable(false);
    	
    }
    

    
    /**
     * Ausgabe Probenfenster
     */
    public void probenAusgabe(JEditorPane aPane,ProbenItem pi) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	String inhalt = "";
    	if(pi != null) {
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("probe.png") + rz.getLocale().getString("probenausgabe.nummer").replaceAll("%n",String.valueOf(pi.getId())) + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",pi.getErstelltToString()).replaceAll("%v",pi.getUser_1()) ;
           	inhalt += "</div>";
           	if(pi.isDeleted()) {
	           	inhalt += "<div " + insertStyle(DIV_ROT,fontsize) + ">";
	       		inhalt += rz.getLocale().getString("ausgabe.probe_entsorgt").replaceAll("%u",pi.getUser_2()).replaceAll("%s",pi.getEntsorgtToString()) ;
	       		inhalt += "</div>";
           	}
           	
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
       		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">"  + rz.getLocale().getString("probenausgabe.label_adressen") + "</td>";
       				inhalt += "<td " + insertStyle(DIV_ADRESSEN,fontsize) +">" +
       					"<a href=\"" + pi.getAdressListe().toVerbosePatternString()+  "\">" +
       					pi.getAdressListe().toVerboseString() + "</a></td>";
       		inhalt +="</tr>";
	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("probenausgabe.label_bezeichnung") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getBezeichnung() + "</td>";
			inhalt +="</tr>";
	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("probenausgabe.label_rezeptur") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getRezeptur_bezeichnung() + "</td>";
			inhalt +="</tr>";
			inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("probenausgabe.label_losnummer") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getLosnummer() + "</td>";
			inhalt +="</tr>";

   		    inhalt +="</table>";
       		inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + ">" +pi.getBemerkungen().replaceAll("\\n","<br>") + "</div>";
            inhalt +="</body></html>";

    	}else {
    		inhalt="";
    	}
    	aPane.setEditable(true);
        aPane.setText(inhalt.replace(" ","&nbsp;") );
        aPane.setCaretPosition(aPane.getDocument().getLength());
    	aPane.setEditable(false);
    }
    
    /**
     * Ausgabe Füllgewichte
     */
    public void gewichtsAusgabe(JEditorPane aPane,RezepturItem r,double tara,double liter1) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	String inhalt = "<html><head></head><body><div style=\"font-family:"+fontName + ";font-size:" +String.valueOf(fontsize)+ ";\">&nbsp;";
    	String liste = rz.getOptionFactory().getOption("auswahl.fuellgewichte") + ";" + Double.toString(liter1);
    	String l[]=liste.split(";");
    	inhalt += "<table  style=\"padding:5px;border-width:2px;border-style:solid;\">";
    	for(int i = 0;i<l.length;i++) {
    		inhalt += "<tr>";
    			inhalt +="<td " + insertStyle(DIV_MARKUP_BORDER,fontsize)+   ">"+ l[i] +"&nbsp;" +  rz.getLocale().getString("string_liter") +  "&nbsp;:</td>";
    			double value=0.0;
    			try {
    				value = Double.parseDouble(l[i]);
    			}catch (NumberFormatException e) {value=0.0;}
    			inhalt +="<td " + insertStyle(DIV_NORMAL_BORDER,fontsize) + ">";
    				if (!rz.isZero(value)) {
    					inhalt += rz.getLocale().formatNumber((r.getLitergewicht() * value),OptionFactory.NF_NORMAL) + "&nbsp;" + rz.getLocale().getString("string_kg");
    				}
    			inhalt +="</td>";
    			inhalt +="<td style=\"border-width:1px;border-style:solid\">";
    				if (!rz.isZero(tara)) {
    					inhalt += rz.getLocale().getString("gewicht.tara").replaceAll("%g", rz.getLocale().formatNumber(tara+((r.getLitergewicht() * value)),OptionFactory.NF_NORMAL));
    				}
    				else {
    					inhalt += rz.getLocale().getString("gewicht.tara_0");
    				}
    			inhalt +="</td>";
    		inhalt += "</tr>";
    	}
        inhalt += "</table></div></body></html>";
        aPane.setEditable(true);
        aPane.setText(inhalt.replace(" ","&nbsp;") );
        aPane.setCaretPosition(aPane.getDocument().getLength());
        aPane.setEditable(false);
    }
    
    /**
     * Ausgabe history-Liste
     */
    public void historyAusgabe(JEditorPane aPane,AbfrageListe abfragen) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize()-1;
    	String inhalt = "<html><head></head><body><div style=\"font-family:"+fontName + ";font-size:" +String.valueOf(fontsize)+ ";\">&nbsp;";
    	//String trennerL =  "<span style=\"color:#ffffff;background-color:#9090ff ;\">&lt;</span>" ;
    	//String trennerR =  "<span style=\"color:#ffffff;background-color:#9090ff ;\">&gt;</span>" ;
    	final String trennerL =  "<span style=\"color:#000000;background-color:#ffff00 ;\"><b>&nbsp;" ;
    	final String trennerR =  "<span style=\"color:#ffffff;background-color:#ffffff ;\">&nbsp;&nbsp;</span>" ;
    	if((abfragen != null) && (abfragen.size() > 0)) {
        	for(int i = 0;i < abfragen.size();i++) {
            		final AbfrageItem ai = abfragen.getItem(i);
        			inhalt += "<a href=\"abf:" + String.valueOf(i)+  "\":>" +
        			trennerL + (String.valueOf(-((abfragen.size() - i) -1))) +  ":</b></span>" +
        			(ai.getAdressListe().size() > 0?ai.getAdressListe().toHTMLShortString(3) + " ":"") +
        			(ai.getStichwortListe().size() > 0?ai.getStichwortListe().toHTMLShortString(1) + " ":"") +
        			" " +  (ai.getTyp()==DBAbfrage.ABFRAGE_TYP_SQL?rz.getLocale().getString("abfragefenster.string_erweitert") :  ai.getMuster())+ "</a>"  + trennerR;
        		}
        	}
        inhalt += "</table></div></body></html>";
        aPane.setEditable(true);
        aPane.setText(inhalt.replace(" ","&nbsp;") );
        aPane.setCaretPosition(aPane.getDocument().getLength());
        aPane.setEditable(false);
    }
    /**
     * Ausgabe Bestandswarnung
     */
    public void bestandswarnungsAusgabe(JEditorPane aPane,boolean checkBestand,boolean checkBuchungen) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	String inhalt = "<html><head>";
       	inhalt += "</head>";
    	inhalt+="<body><div style=\"font-family:"+fontName + ";\">";
    	final BestandswarnungsListe bl = rz.getDatabase().getRezeptur().getBestandswarnungen(checkBestand,checkBuchungen);
    	if(bl != null) {
     		inhalt +="<table>";
    		for(int i =0;i < bl.size();i++) {
    			final BestandswarnungsItem bi =bl.getItem(i);
    			String style="<td style=\"font-size:" + fontsize + ";\"";
    			String styleSmall="<td style=\"font-size:" + (fontsize-1) + ";color:red;\"";
    			if(bi.isLeer()) {
					style= "<td style=\"font-size:" + fontsize + ";background-color:#" + rz.getOptionFactory().getHexColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT)) + ";white-space:nowrap;\"";
					styleSmall= "<td style=\"font-size:" + (fontsize-1) + ";color:red;background-color:#" + rz.getOptionFactory().getHexColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT)) + ";white-space:nowrap;\"";
    			}
    			inhalt += "<tr>";
    	        if (checkBuchungen) {
            		inhalt += "<td style=\"background-color:" + bi.getLetzteBuchung() + "\">&nbsp;</td>";
    	        }
        		if( bi.isBestellt()){
        			if(rz.getDatabase().getBestellung().bestellungAbgelaufen(bi.getRezeptur())) {
	        			inhalt += style + "><a href=\"bst:\">" +insertGfx("bestellt_abgelaufen.png")+ "</a></div></td>";
        			} else {
	        			inhalt += style + "><a href=\"bst:\">" +insertGfx("bestellt.png")+ "</a></div></td>";
        			}
	        	}else {
	        		inhalt+=style +"></td>";
	        	}
	        	if(rz.isZero(bi.getDiff())){
	        		inhalt +=style+ "></td>";
	        	}else {
	        		String number =rz.getLocale().formatNumber(Math.floor(bi.getDiff()),OptionFactory.NF_NORMAL) ;
	        		inhalt += style + " align=right><a href=\"bsw:{{" + bi.getBezeichnung().replaceAll("\"","").replaceAll("'","") + "}}[["+bi.getRezeptur()+  "]]"+(Math.floor(bi.getDiff()))  +"\">" +  number + "&nbsp;" + bi.getStrEinheit()+  "</a></td>";
	        	}
	        	inhalt += style + "><a href=\"" + bi.getRezeptur() +  "\">" +bi.getBezeichnung().replaceAll(" " ,"&nbsp;") + "</a></td>";
        		inhalt +="<td><a href=\"naf:" + String.valueOf(bi.getRezeptur()) +"§" + Double.toString(Math.floor(bi.getDiff())) +"§" + bi.getBezeichnung() +"\">" + insertGfx("ausgabe.bestandswarnung_auftrag.png") + "</a></td>";
	        	inhalt +="</tr>";
	        	if(checkBestand && (bi.getZutatenListe().size() > 0)) {
	        		for(int j=0;j<bi.getZutatenListe().size();j++) {
	        			inhalt +="<tr><td></td><td></td>";
	        			inhalt += checkBuchungen?"<td></td>":"";
	        			inhalt +=styleSmall + ";>" + bi.getZutatenListe().get(j) ;
	        			inhalt +="</td></tr>";
	        		}
	        	}
    		}
    	}
        inhalt += "</table></div></body></html>";
        aPane.setEditable(true);
        aPane.setText(inhalt);
        aPane.setCaretPosition(0);
        aPane.setEditable(false);
    }


    /**
     * Ausgabe Bestellungslistenfenster
     */
    public void bestellungsListenAusgabe(BestellungsItem bi,JEditorPane aPane) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	SimpleDateFormat df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
    	String inhalt = "";
    	if(bi != null) {
	        inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";font-size:" + String.valueOf(fontsize) + "pt;\">";
	        // Überschrift
	        inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
	       	inhalt += rz.getLocale().getString("bestellungslistenfenster.ueberschrift") +"<br></div>";
	       	// erstellt
	       	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
	       		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",bi.getErstelltToString()).replaceAll("%v",bi.getUser_1()) ;
	       	inhalt += "</div>";
	       	//geändert
	       	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
	       		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",bi.getGeaendertToString()).replaceAll("%v",bi.getUser_2()) ;
	       	inhalt += "</div>";
	        inhalt +="<table border=\"0\">";

	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_bezeichnung") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getBezeichnung() + "</td>";
			inhalt +="</tr>";

	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_artikelnummer") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getArtikelnummer() + "</td>";
			inhalt +="</tr>";
	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_firma") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getFirma() + "</td>";
			inhalt +="</tr>";
			if(bi.getAdresse() != 0) {
				final AdressItem ai = rz.getDatabase().getAdressen().dbGetAdresse(bi.getAdresse(),true);
		        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_adresse") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + (ai == null ? "":"<a href=\"" + ai.getFirma() + "\">"+ ai.getFirma())+  "</a></td>";
				inhalt +="</tr>";
			}

	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_menge") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().formatNumber(bi.getMenge(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit())  + "</td>";
			inhalt +="</tr>";

			if(bi.isLiefertermin()) {
		        inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_liefertermin") + "</td>";
					if(bi.getLiefertermin_datum().before(rz.getToday())){
						inhalt += "<td " +insertStyle(DIV_ROT,fontsize) + ">" + df.format(bi.getLiefertermin_datum().getTime())  + "</td>";
					} else {
						inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + df.format(bi.getLiefertermin_datum().getTime())  + "</td>";
					}
				inhalt +="</tr>";
			}
	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_rest") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().formatNumber(bi.getRest(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit())  + "</td>";
			inhalt +="</tr>";

	        inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_comment") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getComment() + "</td>";
			inhalt +="</tr>";

			if(!bi.getLosnummer().trim().equals("")) {
		        inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_zugang") + "</td>";
					inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getErledigtToString() + "</td>";
				inhalt +="</tr>";
		        inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("bestellungslistenfenster.text_label_zugang_1") + "</td>";
					inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + bi.getLosnummer() + "</td>";
				inhalt +="</tr>";
			}
	        inhalt +="</table>";
	        inhalt += "</body></html>";
    	} else {
    		inhalt="<html><head></head><body></body></html>";
    	}
        aPane.setEditable(true);
        aPane.setText(inhalt);
        aPane.setCaretPosition(0);
        aPane.setEditable(false);

    }
    /**
     * Ausgabe Palettenfenster
     */
    public void palettenAusgabe(PalettenItem pi,JEditorPane aPane) {
        setStyles();
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
        String inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";font-size:" + String.valueOf(fontsize) + "pt;\">";
        inhalt +="<table border=\"0\">";
   		inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("palettenfenster.label_bezeichnung") + "</td>";
			inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getBezeichnung() + "</td>";
		inhalt +="</tr>";
   		inhalt += "<tr>";
		inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("palettenfenster.label_inhalt") + "</td>";
		inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + Double.toString(pi.getInhalt()) + "</td>";
		inhalt +="</tr>";
			inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("palettenfenster.label_flaschen_per_karton") + "</td>";
			inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getFlaschen_per_karton() + "</td>";
		inhalt +="</tr>";
			inhalt += "<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("palettenfenster.label_kartons_per_palette") + "</td>";
			inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + pi.getKarton_per_palette() + "</td>";
		inhalt +="</tr>";

        inhalt +="</table>";
        inhalt += "</body></html>";
        aPane.setEditable(true);
        aPane.setText(inhalt);
        aPane.setCaretPosition(0);
        aPane.setEditable(false);

    }

    /**
     * public void getAdressAusgabe(int,JEditorPane) gibt den Text eines AdressItems aus
     * @param aKey Key der Adresse
     * @param aPane JEditorpane
     */
    public void adressAusgabe(int aKey,JEditorPane aPane){
        setStyles();
        final AdressItem ai = rz.getDatabase().getAdressen().dbGetAdresse(aKey,true);
        if (ai != null){
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("adressbuch.png") + ai.getFirma() + ", " + ai.getOrt() + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ai.getErstelltToString()).replaceAll("%v",ai.getUser1()) ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ai.getGeaendertToString()).replaceAll("%v",ai.getUser2()) ;
           	inhalt += "</div>";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
       		inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_kd1") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getKdnummer1() + "</td>";
			inhalt +="</tr>";
       		inhalt += "<tr>";
   				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_kd2") + "</td>";
   				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getKdnummer2() + "</td>";
			inhalt +="</tr>";
       		inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_strasse") + "</td>";
       			inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getStrasse() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
   				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_plz") + "</td>";
   				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getPLZ() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
   				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_ort") + "</td>";
   				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getOrt() + "</td>";
			inhalt +="</tr>";
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_name") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getVorname() + " " + ai.getNachname() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_fon") + "</td>";
				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ai.getFon() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_fax") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getFax() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_mobil") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getMobil() + "</td>";
		    inhalt +="</tr>";
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("adresseingabe.label_mail") + "</td>";
				inhalt += "<td " +insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getMail() + "</td>";
		    inhalt +="</tr>";
   			if(ai.getTyp()==DBAdressen.TYP_BEIDE||ai.getTyp()==DBAdressen.TYP_KUNDE) {
	       		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP_KUNDE,fontsize)+ ">" + rz.getLocale().getString("adressausgabe.label_kunde") + "</td>";
					inhalt += "<td></td>";
			    inhalt +="</tr>";
   			}
   			if(ai.getTyp()==DBAdressen.TYP_BEIDE||ai.getTyp()==DBAdressen.TYP_LIEFERANT) {
	       		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP_LIEFERANT,fontsize)+ ">" + rz.getLocale().getString("adressausgabe.label_lieferant") + "</td>";
					inhalt += "<td></td>";
			    inhalt +="</tr>";
   			}
			inhalt += "</table>";
       		inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + ">" + ai.getComment().replaceAll("\\n","<br>") + "</div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    /** public void getErgebnisAusgabe(int,JTexpPane) gibt den Text der Auswahlfenster-
     * Ergebnisliste aus */
    public void ergebnisAusgabe(int aKey,int aTyp,JEditorPane aPane){
        setStyles();
        switch(aTyp){
            case RzPro.TYP_ID_NOTIZ  : notizAusgabe(aKey,aPane); break;
            case RzPro.TYP_ID_REZEPT :
            case RzPro.TYP_ID_VERWEIS :  	rezepturAusgabe(aKey,aPane); break;
            case RzPro.TYP_ID_AUSSTATTUNG: ausstattungsAusgabe(aKey,aPane);break;
        }
    }

    /** public void getErgebnisAusgabe(int,JTexpPane) gibt den Text der Auswahlfenster-
     * Ergebnisliste aus
     * Die Version für Clients, die nicht alles sehen sollen..
     * */
    public void ergebnisAusgabeClient(int aKey,int aTyp,JEditorPane aPane){
        setStyles();
        switch(aTyp){
            case RzPro.TYP_ID_NOTIZ  : notizAusgabe(aKey,aPane); break;
            case RzPro.TYP_ID_REZEPT :
            case RzPro.TYP_ID_VERWEIS :
            	rezepturAusgabeClientHTML(aKey,aPane); break;
        }
    }


    /** notizausgabe(int,JTextPane) gibt eine Notiz aus */
    private void notizAusgabe(int aKey,JEditorPane aPane){
        final NotizItem ni = rz.getDatabase().getNotizen().dbGetNotiz(aKey,true);
        if (ni != null){
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("notiz.png") + ni.getTitel() + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ni.getErstelltToString()).replaceAll("%v",ni.getUser1()) ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
       		if(rz.getDatabase().getChanges().isChanges(ni.getID())) {
       			inhalt += "<a href=\"cha:" + ni.getID() + "\">" + insertGfx("auswahl.action_changes.png")+ "&nbsp;&nbsp;</a>";
       		}
           	inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ni.getGeaendertToString()).replaceAll("%v",ni.getUser2()) ;
           	inhalt += "</div>";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
           		inhalt += "<tr>";
       					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">"  + rz.getLocale().getString("string_adressen") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_ADRESSEN,fontsize) +">" +
           					"<a href=\"" + ni.getAdressListe().toVerbosePatternString()+  "\">" +
           					ni.getAdressListe().toVerboseString() + "</a></td>";
           		inhalt +="</tr>";
           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("string_stichworte") + "</td>";
	       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ni.getStichwortListe().toHTMLString() + "</td>";
       		    inhalt +="</tr>";
           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.string_rezepturnummer") + "</td>";
	       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + String.valueOf(ni.getID()) + "</td>";
       		    inhalt +="</tr>";
       			/*
				 * Dokumente
				 */
				String documents = rz.getDatabase().getDocuments().getDocumentListeText(ni.getID(),true);
				if(!documents.equals("")) {
					documents =  "<a href=\"doc:" + ni.getID() + "\">" + documents + "</a>";
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dokumente") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + documents +  "</td>";
					inhalt +="</tr>";
				}
       		    
       		    inhalt +="</table>";
       		inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + ">" + ni.getComment().replaceAll("\\n","<br>") + "</div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    /** void rezepturAusgabe(int,JTextPane) gibt eine Rezeptur aus */
    private void rezepturAusgabe(int aKey,JEditorPane aPane){
        RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(aKey,true);
    	String inhalt;
    	String verweisListe;
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
      	String tankliste = rz.getDatabase().getBuchungen().getBestandTanks(aKey,rz.getLocale().getString("ausgabe.tank"),rz.getOptionFactory().getOption("dbbuchung.tank_sb"),rz.getOptionFactory().getOption("dbbuchung.tank_se")).getCommentListeHTML();
    	if (ri != null){
        	final SaldenItem s = rz.getDatabase().getRezeptur().forceBestand(ri.getID());
        	//final SaldenItem s= rz.getDatabase().getRezeptur().getBestandsSaldo(ri.getID());
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            // Überschrift   
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("rezeptur.png") + ri.getTitel() + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt +=  "<a href=\"DD:" +ri.getErstellt().getTime() + "\">" +rz.getLocale().getString("string_erstellt").replaceAll("%s",ri.getErstelltToString()).replaceAll("%v",ri.getUser1()) + "</a>" ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
           		if(rz.getDatabase().getChanges().hasRelevanteAenderungen(ri.getID())) {
           			inhalt += "<a href=\"cha:" + ri.getID() + "\"><b>" +rz.getLocale().getString("ausgabe.aenderungen") + "</b>&nbsp;&nbsp;" + insertGfx("auswahl.action_changes.png")+  "&nbsp;&nbsp;</a>";
           		}
           		inhalt += "<a href=\"DD:" + ri.getGeaendert().getTime() + "\">" + rz.getLocale().getString("string_geaendert").replaceAll("%s",ri.getGeaendertToString()).replaceAll("%v",ri.getUser2()) + "</a>" ;
           	inhalt += "</div>";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left border=0 ";
           		inhalt += "<tr>";
       					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">"  + rz.getLocale().getString("string_adressen") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_ADRESSEN,fontsize) +">" +
           					"<a href=\"" + ri.getAdressListe().toVerbosePatternString() +  "\">" +
           					ri.getAdressListe().toVerboseString() + "</a></td>";
           		inhalt +="</tr>";
           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("string_stichworte") + "</td>";
	       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ri.getStichwortListe().toHTMLString() + "</td>";
       		    inhalt +="</tr>";
       		    // Verweis
           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.string_rezepturnummer") + "</td>";
	       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + String.valueOf(ri.getID()) + "</td>";
       		    inhalt +="</tr>";
       		    if(ri.getVerweis() != 0) {
       		    	inhalt += "<tr>";
       		    		inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("rezeptur.label_verweis") + "</td>";
       	                ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ri.getVerweis(),true);
       		    		inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + ri.getTitel() + "</td>";
				    inhalt +="</tr>";
       		    }
       		    verweisListe = rz.getDatabase().getRezeptur().dbGetVerweisListe(aKey);
       		    if(!verweisListe.equals("")) {
       		    	inhalt += "<tr>";
   		    			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.verweise") + "</td>";
   		    			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + verweisListe + "</td>";
   		    		inhalt +="</tr>";
       		    }
       		    // Stärke
           		inhalt += "<tr>";
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.staerke") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + rz.getLocale().formatNumber(ri.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol")  +
   					 " (" + rz.getLocale().formatNumber(ri.getAlkoholGramm(), OptionFactory.NF_NORMAL) + "  " + rz.getLocale().getString("string_gr_per_kg") + ")</td>";
   				inhalt +="</tr>";
   				//extraktfrei
           		inhalt += "<tr>";
       				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.extraktfrei") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + ((ri.getExtraktfrei() == true) ? rz.getLocale().getString("string_ja") : rz.getLocale().getString("string_nein") )   + "</td>";
				inhalt +="</tr>";
   				//extraktgehalt
           		inhalt += "<tr>";
       				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.extrakt") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">"  + rz.getLocale().formatNumber(ri.getExtrakt(), OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_prozentmas") + "</td>";
				inhalt +="</tr>";
   				//litergewicht
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.litergewicht") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getLitergewicht(), OptionFactory.NF_LITERGEWICHT) + " " + rz.getDatabase().getEinheiten().dbGetLitergewichtString()+ "</td>";
			    inhalt +="</tr>";
                //Volumen
                inhalt += "<tr>";
                    inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.volumen") + "</td>";
                    inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(1/ri.getLitergewicht(), OptionFactory.NF_LITERGEWICHT) + " " + rz.getDatabase().getEinheiten().dbGetVolumenString()+ "</td>";
                inhalt +="</tr>";
   				//basismenge
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.basismenge") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getBasismenge(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBasiseinheit())) +  "</td>";
				inhalt +="</tr>";
				//bestand-Meldebestand
           		inhalt += "<tr>";
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.bestand") + "</td>";
           			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><a href=\"((" + ri.getID()+  "))\">";
           				inhalt += rz.getLocale().getString("ausgabe.bestand_detail")
           				.replaceAll("%l",rz.getLocale().formatNumber(s.getLiter(), OptionFactory.NF_NORMAL)  )
           				.replaceAll("%k",rz.getLocale().formatNumber(s.getKg(), OptionFactory.NF_NORMAL)  )
           				.replaceAll("%a",rz.getLocale().formatNumber(s.getLa(), OptionFactory.NF_NORMAL)  );
           		inhalt +="<br>" + tankliste + "</td>";
			    inhalt +="</tr>";
			    //Kontrakt
           			final ArrayList<kontraktItem> kil = rz.getDatabase().getKontrakte().getKontraktRezeptur(ri.getID());
           			if(kil != null && kil.size() > 0) {
           				String kontrakte = "";
           				for(kontraktItem ki:kil) {
           					kontrakte +=   "<a href=\"kon:" + ki.getId() + "\">" + ki.getKontraktAusgabeString() + "</a><br>"; 
           				}
           				if(kontrakte.endsWith("<br>")) {
           					kontrakte = kontrakte.substring(0,kontrakte.length()-4);
           				}
                   		inhalt += "<tr>";
           				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.kontrakt") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + kontrakte  + "</td>";
           				inhalt +="</tr>";
           			}
           		//Mischungen
           		ArrayList<MischungenTankItem> mischungen = rz.getDatabase().getMischungen().getMischungenTanksFromRezeptur(ri.getID());
           		if(!mischungen.isEmpty()) {
           			String mischungen_liste = "";
           			String alle = "";
           			ArrayList<Integer> ids = new ArrayList<Integer>(); 
           			for(MischungenTankItem i:mischungen) {
           				if(!i.getTank().equals("")) {
           					ids.add(i.getMischung());
           					mischungen_liste += "<a href=\"MM:"+String.valueOf(i.getMischung())+"\">" + String.valueOf(i.getMischung())+"&nbsp;</a>&nbsp;" + 
           							rz.getLocale().getString("dbmischung.getMischungenTanksFromRezeptur").replaceAll("%n", 
                   							"<a href=\"ttt:"+i.getTank()+"\">"+i.getTank()+"</a>") + 
           						 "&nbsp;";
           				} else {
           					mischungen_liste += "<a href=\"MM:"+String.valueOf(i.getMischung())+"\">" + String.valueOf(i.getMischung())+"&nbsp;</a>&nbsp;";
           				}
           				alle += String.valueOf(i.getMischung())+" ";
           			}
       				mischungen_liste += "<a href=\"MA:"+alle+"\">" + rz.getLocale().getString("ausgabe.mischungen_alle")+";</a>&nbsp;";           			
           			inhalt += "<tr>";
       					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.mischungen_liste") + "</td>";
       					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + mischungen_liste  + "  (" + rz.getLocale().formatNumber(rz.getDatabase().getMischungen().getMischungenLA(ids),OptionFactory.NF_ONE) + " LA) </td>";
       				inhalt +="</tr>";
           		}
           		inhalt += "<tr>";
       				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.meldebestand") + "</td>";
       				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getMeldebestand(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBestandseinheit()))  + "</td>";
       			inhalt +="</tr>";
           		inhalt += "<tr>";
	   				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.vorschlagsbestand") + "</td>";
	   				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getVorschlagsbestand(), OptionFactory.NF_NORMAL) + " "  + rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getBestandseinheit()))  + "</td>";
	   			inhalt +="</tr>";
       			//Preis
           		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.preis") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +
   	                	rz.getLocale().formatNumber(ri.getPreisMenge(), OptionFactory.NF_NORMAL) + " " +
   	                	rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(ri.getPreisEinheit())) + " " +
   	                	rz.getLocale().getString("string.ist_gleich") + " " +
   	                	rz.getLocale().formatNumber(ri.getPreis(), OptionFactory.NF_NORMAL) + " "  +
   	                	rz.getDatabase().getCurrency().dbGetCurrency( ri.getWaehrung(),true).getName() + "</td>";
			    inhalt +="</tr>";
   				//lager
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.lager") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getDatabase().getLager().dbGetLager(ri.getLager(),true).getName() + "</td>";
				inhalt +="</tr>";
				//steuerartikel
				SteuerDatenItem si = rz.getDatabase().getRezeptur().getSteuerDaten(ri.getID()); 
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.steuerartikel") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + ri.getSteuerArtikel() + "</td>";
				inhalt +="</tr>";
				//steuerlager
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.steuerlager") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + si.getStrSteuerlager() + "</td>";
				inhalt +="</tr>";
				//sorte
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.sorte") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + si.getStrSorte() + "</td>";
				inhalt +="</tr>";
   				//Schwundsatz
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.schwundsatz") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getSchwundsatz(), OptionFactory.NF_NORMAL) + " %" + "</td>";
				inhalt +="</tr>";
   				//Artikelnummer
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.artikelnummer") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + ri.getArtikelnummer() + "</td>";
				inhalt +="</tr>";
   				//Losnummer
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.losnummer") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +ri.getLosnummer() + "</td>";
				inhalt +="</tr>";

   				//Tank
           		inhalt += "<tr>";
           			if(rz.getDatabase().getTank().tankExists(ri.getTank().trim())) {
           				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.tank") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + ri.getTTTHtml()+"</td>";
           			}else {
           				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.tank") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +  ri.getTank() + "</td>";
           			}
				inhalt +="</tr>";
				
   				//Spezifikation
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("rezeptur.label_spezifikation") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +  ri.getSpezifikation() + "</td>";
				inhalt +="</tr>";

   		
			//Brennwert

					final double kj = ri.getBrennwert();
					if(!rz.isZero(kj)) {
						final double kk = ri.getBrennwert() * rz.getOptionFactory().getDouble("brennwert.kj_to_kk");
						final double be = ri.getBrennwert() * rz.getOptionFactory().getDouble("brennwert.kj_to_be");
						inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.brennwert") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +
						 	rz.getLocale().getString("ausgabe.bw")
							.replaceAll("%kj", rz.getLocale().formatNumber(kj,OptionFactory.NF_NORMAL))
						    .replaceAll("%kk",rz.getLocale().formatNumber(kk,OptionFactory.NF_NORMAL) )
						    .replaceAll("%be",rz.getLocale().formatNumber(be,OptionFactory.NF_NORMAL) )
						   + "</td>";
						inhalt +="</tr>";
					} else {
						inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.brennwert") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + 	rz.getLocale().getString("ausgabe.bw_na") +  "</td>";
						inhalt +="</tr>";
					}

				//Säuregehalt
	           	inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.acid") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getAcid(),OptionFactory.NF_NORMAL) + "</td>";
				inhalt +="</tr>";

				//Deklarationen
	           	inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.deklaration") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><b>" +ri.getDeklarationenListe().toVerboseString()+ "</b>&nbsp;" +
						ri.getDeklarationenAlle().toVerboseString() +	"</td>";
				inhalt +="</tr>";
   				//hinweis
				if(!ri.getHinweis().equals("")) {
					SimpleDateFormat df;
		            df = new SimpleDateFormat("dd. MM yyyy");
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_user") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +ri.getHinweis_user() + "</td>";
					inhalt +="</tr>";
						inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_datum") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +df.format(ri.getHinweis_datum()) + "</td>";
					inhalt +="</tr>";
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +ri.getHinweis() + "</td>";
				    inhalt +="</tr>";
				}
				
			//Spezifikationen
				ArrayList <LaborwertValueItem>liste = rz.getDatabase().getLaborwerte().getValue(ri.getID());
				if(liste != null && !liste.isEmpty()) {
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.spezifikationen") + "</td>";
					String sp = "";
					for(LaborwertValueItem vi:liste) {
						if(vi.isFix()) {
							sp+=vi.getLbwBezeichnung()+ " (" +rz.getLocale().getString("laborwert.fix") +"), ";
						}else {
							sp+=vi.getLbwBezeichnung()+ " (" + vi.getStrEinheit1() + "/" + vi.getStrAusgabeeinheit() +"), ";
						}
					}
					if (sp.endsWith(", "))sp=sp.substring(0,sp.length()-2);
					inhalt +=  "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + sp + "</td>";
					
				}
				//zsätzliche Spezifikationen - Text
				if(!ri.getSpezifikation_text().trim().equals("")) {
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.spezifikation_text") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +ri.getSpezifikation_text().replaceAll("\n","<br>" ) + "</td>";
					inhalt +="</tr>";
				}
				
				//Konformitätserklärung
				if(ri.isKonform()) {
					SimpleDateFormat dfx;
		            dfx = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.konform") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().getString("ausgabe.konform_zeile")
								.replaceAll("%d", ri.getKonformDatum() != null?dfx.format(ri.getKonformDatum()):"")
								.replaceAll("%s", ri.getKonformComment())
								+ "</td>";
					inhalt +="</tr>";
				}
   				//Temperatur
           		inhalt += "<tr>";
           			temperaturZonenItem ti = rz.getDatabase().getTemperatur().getZone(ri.getTemperaturDurchschnitt());
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.rezeptur_temperatur") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize) + ">" + rz.getLocale().getString("ausgabe.rezeptur_temperatur_string") 
	            		     .replaceAll("%z",ti.getBezeichnung())
							.replaceAll("%v",String.valueOf(ri.getTempVon()))
							.replaceAll("%b",String.valueOf(ri.getTempBis()))
							.replaceAll("%s",String.valueOf(ri.getTemperaturDurchschnitt()))
							+ "</td>";

				inhalt +="</tr>";
   				//datenblatt
				if(rz.getDatabase().getDatenblatt().getDatenblatt(ri.getID(),ri.getTitel()).isSaved()){
	           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.rezeptur_datenblatt") + "</td>";
						inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +  rz.getLocale().getString("string_ja")+ "</td>";
					inhalt +="</tr>";
				}
			//rückstellprobe
				if(ri.isRProbe()) {
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.rueckstellprobe") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + rz.getLocale().getString("ausgabe.rueckstellprobe_anzahl").replaceAll("%n",Integer.toString(ri.getProbenAnzahl())) + "</td>";
				inhalt +="</tr>";
				}

				if(ri.isBewertung()) {
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.bewertung") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + "</td>";
				inhalt +="</tr>";
				}
				
				if(!ri.getEan().trim().equals("")) {
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ean") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + ri.getEan().replaceAll("\\n", "<br>") +  "</td>";
				inhalt +="</tr>";
				}
				
				if(ri.isAuto_anfrage()) {
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.autoanfrage") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + rz.getLocale().getString("string_ja") +  "</td>";
				inhalt +="</tr>";
				}
				/*
				 * Dokumente
				 */
				String documents = rz.getDatabase().getDocuments().getDocumentListeText(ri.getID(),true);
				if(!documents.equals("")) {
					documents =  "<a href=\"doc:" + ri.getID() + "\">" + documents + "</a>";
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dokumente") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + documents +  "</td>";
					inhalt +="</tr>";
				}
				
				/*
				 * last orders
				 */
				ArrayList<LastOrdersItem> lastOrders = rz.getDatabase().getBestellung().getLastOrders(ri.getID());
				if(!lastOrders.isEmpty()) {
					String orders = "";
					SimpleDateFormat df;
		            df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
					for(LastOrdersItem item:lastOrders) {
						orders = orders + "<b>" + df.format(item.getErstellt()) + " (" + item.getUser() + ") " +item.getErledigt() + "</b>: " +item.getAdresseFirma() + "&nbsp;" + item.getAdresseVorname() + "&nbsp;" + item.getAdresseNachname() + "<br>";
					}
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.lastOrders") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + orders +  "</td>";
					inhalt +="</tr>";
				}
				
				
           	inhalt +="</table>";
           	final String zeilen[] = ri.getComment().split("\\n");
           	final String rawZeilen[] = ri.getRaw().split("\\n");
           	for (int i = 0; i < zeilen.length;i++) {
           		try {
           		if(rawZeilen[i].indexOf("[[") != -1) {
	           			// Verweis auf Rezeptur
	           			int start,end,verweis;
	           			start = rawZeilen[i].indexOf("[[")+2;
	           			end = rawZeilen[i].indexOf("]]",start);
	           			final String f[] = zeilen[i].split("\\s");
	           			verweis=zeilen[i].indexOf(f[2]);
	           			if(verweis == -1) {
	           				inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " +
	           					"<a href=\"" + rawZeilen[i].substring(start,end) +  "\">" +
	           					zeilen[i] + "</a></div>";
	           			} else {

	           				inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " +
	           				zeilen[i].substring(0,verweis-1) + "&nbsp;" +
	       					"<a href=\"" + rawZeilen[i].substring(start,end) +  "\">" +
	       					zeilen[i].substring(verweis,zeilen[i].length()) +
	       					 "</a></div>";
	           			}
	           			//Hinweis vorhanden ?
	           			try {
	           				HinweisItem hi = rz.getDatabase().getRezeptur().getHinweis(Integer.parseInt(rawZeilen[i].substring(start,end)));
		           			if(hi != null) {
		    					SimpleDateFormat df;
		    		            df = new SimpleDateFormat("dd. MM yyyy");
		    					inhalt += "<tr>";
		    						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_user") + "</td>";
		    						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +hi.getUser() + "</td>";
		    					inhalt +="</tr>";
		    						inhalt += "<tr>";
		    						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_datum") + "</td>";
		    						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +df.format(hi.getDatum()) + "</td>";
		    					inhalt +="</tr>";
		    					inhalt += "<tr>";
		    						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis") + "</td>";
		    						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +hi.getHinweis() + "</td>";
		    				    inhalt +="</tr>";
		    				}
	           			}catch(Exception hie) {};
	           		} else {
	           			if (zeilen[i].trim().startsWith(BEMERKUNGEN_PREFIX)) {
	           			 inhalt +=  insertGfx("bemerkungen.png") + "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " + zeilen[i].substring(zeilen[i].indexOf("!!")+2) + "</div>";
	           			} else {
	           			 inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " + zeilen[i] + "</div>";
	           			}
	           		}
           		} catch (final Exception e) {
           			rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezepturAusgabeHTML-Line",e.getLocalizedMessage());
           		}
           	}
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {       
            displayNotFoundError(aPane);
        }
    }



    /** void rezepturAusgabe(int,JTextPane) gibt eine Rezeptur aus
     * aber nur die eingeschränkte Fassung für Clients...
     * */
    private void rezepturAusgabeClientHTML(int aKey,JEditorPane aPane){
        RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(aKey,true);
        String verweisListe = "";
        if (ri != null){
        	final SaldenItem s = rz.getDatabase().getRezeptur().getBestandsSaldo(ri.getID());
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
           	String tankliste = rz.getDatabase().getBuchungen().getBestandTanks(aKey,rz.getLocale().getString("ausgabe.tank"),rz.getOptionFactory().getOption("dbbuchung.tank_sb"),rz.getOptionFactory().getOption("dbbuchung.tank_se")).getCommentListeHTML();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("rezeptur.png") + ri.getTitel() + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ri.getErstelltToString()).replaceAll("%v",ri.getUser1()) ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ri.getGeaendertToString()).replaceAll("%v",ri.getUser2()) ;
           	inhalt += "</div>";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left border=0 >";
           		inhalt += "<tr>";
       					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">"  + rz.getLocale().getString("string_adressen") + "</td>";
           				inhalt += "<td " + insertStyle(DIV_ADRESSEN,fontsize) +">" +
           					"<a href=\"" + ri.getAdressListe().toVerbosePatternString() +  "\">" +
           					ri.getAdressListe().toVerboseString() + "</a></td>";
           		inhalt +="</tr>";
           		inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("string_stichworte") + "</td>";
	       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ri.getStichwortListe().toHTMLString() + "</td>";
       		    inhalt +="</tr>";
       		    // Verweis
       		    if(ri.getVerweis() != 0) {
       		    	inhalt += "<tr>";
       		    		inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("rezeptur.label_verweis") + "</td>";
       	                ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ri.getVerweis(),true);
       		    		inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + ri.getTitel() + "</td>";
				    inhalt +="</tr>";
       		    }
       		    verweisListe = rz.getDatabase().getRezeptur().dbGetVerweisListe(aKey);
       		    if(!verweisListe.equals("")) {
       		    	inhalt += "<tr>";
   		    			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.verweise") + "</td>";
   		    			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + verweisListe + "</td>";
   		    		inhalt +="</tr>";
       		    }
       		    // Stärke
           		inhalt += "<tr>";
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("ausgabe.staerke") + "</td>";
   					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)+ ">" + rz.getLocale().formatNumber(ri.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol")  + "</td>";
   				inhalt +="</tr>";
				//bestand-Meldebestand
           		inhalt += "<tr>";
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.bestand") + "</td>";
     			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><a href=\"((" + ri.getID()+  "))\">";
   				inhalt += rz.getLocale().getString("ausgabe.bestand_detail")
	   				.replaceAll("%l",rz.getLocale().formatNumber(s.getLiter(), OptionFactory.NF_NORMAL)  )
	   				.replaceAll("%k",rz.getLocale().formatNumber(s.getKg(), OptionFactory.NF_NORMAL)  )
	   				.replaceAll("%a",rz.getLocale().formatNumber(s.getLa(), OptionFactory.NF_NORMAL)  );
   				inhalt +="</a><br>"+tankliste+"</td>";
			    inhalt +="</tr>";
   				//litergewicht
                inhalt += "<tr>";
                    inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.litergewicht") + "</td>";
                    inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(ri.getLitergewicht(), OptionFactory.NF_LITERGEWICHT) + " " + rz.getDatabase().getEinheiten().dbGetLitergewichtString()+ "</td>";
                inhalt +="</tr>";
                //Volumen
                inhalt += "<tr>";
                    inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.volumen") + "</td>";
                    inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +rz.getLocale().formatNumber(1/ri.getLitergewicht(), OptionFactory.NF_LITERGEWICHT) + " " + rz.getDatabase().getEinheiten().dbGetVolumenString()+ "</td>";
                inhalt +="</tr>";
   				//Artikelnummer
           		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.artikelnummer") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + ri.getArtikelnummer() + "</td>";
				inhalt +="</tr>";

   				//Tank
       			if(rz.getDatabase().getTank().tankExists(ri.getTank().trim())) {
       				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.tank") + "</td>";
       				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + ri.getTTTHtml()+"</td>";
       			}else {
       				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.tank") + "</td>";
       				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +  ri.getTank() + "</td>";
       			}
				
       			/*
				 * Dokumente
				 */
				String documents = rz.getDatabase().getDocuments().getDocumentListeText(ri.getID(),true);
				if(!documents.equals("")) {
					documents =  "<a href=\"doc:" + ri.getID() + "\">" + documents + "</a>";
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dokumente") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + documents +  "</td>";
					inhalt +="</tr>";
				}
				//hinweis
				if(!ri.getHinweis().equals("")) {
					SimpleDateFormat df;
		            df = new SimpleDateFormat("dd. MM yyyy");
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_user") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +ri.getHinweis_user() + "</td>";
					inhalt +="</tr>";
						inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis_datum") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +df.format(ri.getHinweis_datum()) + "</td>";
					inhalt +="</tr>";
					inhalt += "<tr>";
						inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.hinweis") + "</td>";
						inhalt += "<td " + insertStyle(DIV_HINWEIS,fontsize)  + ">" +ri.getHinweis() + "</td>";
				    inhalt +="</tr>";
				   
				}
           	inhalt +="</table>";
            inhalt +="</div></body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    /** void waehrungsAusgabe(int,JTextPane) stellt eine Währung dar */
    public void waehrungsAusgabe(int aKey,JEditorPane aPane){
        setStyles();
        final CurrencyItem ci = rz.getDatabase().getCurrency().dbGetCurrency(aKey,true);
        if (ci != null){
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           	inhalt += insertGfx("dollar.png") + ci.getName() + "<br></div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
           		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ci.getGeaendertToString()).replaceAll("%v",ci.getUser1()) ;
           	inhalt += "</div>";
           	inhalt +="<table cellpadding=1 cellspacing=1 align=left border=0 >";
				//Artikelnummer
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("kalkulation.label_shortname") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +ci.getShortName()+ "</td>";
			inhalt +="</tr>";
				//Artikelnummer
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" +
					rz.getLocale().getString("kalkulation.label_rate").replaceAll("%s",rz.getDatabase().getCurrency().dbGetCurrency(1,true).getShortName())
					.replaceAll("%b",rz.getLocale().formatNumber(ci.getRate(),OptionFactory.NF_EXCHANGE))
					.replaceAll("%v",ci.getShortName()) +
					"</td>";
			inhalt +="</tr>";
       		inhalt += "</table>";
            inhalt +="</div></body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    public void herstellungAusgabe(HerstellungsItem hi,BuchungsListe bl, JEditorPane aPane){
        setStyles();
        BuchungsItem bi=null;
        final SimpleDateFormat df=new SimpleDateFormat("EEEE, dd. MMMM yyyy");
        final String fontName= rz.getFontFactory().getHBFont().getName();
        final int fontsize=rz.getFontFactory().getHBFont().getSize();
        String inhalt ="";
        final String color_abgang="#"+rz.getOptionFactory().getHexColor("herstellbuch.color_abgang");
        final String color_zugang="#"+rz.getOptionFactory().getHexColor("herstellbuch.color_zugang");
        final String color_losnummer="#"+rz.getOptionFactory().getHexColor("herstellbuch.color_losnummer");


        if ((hi != null) && (aPane != null)){
            try {
                inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
	            aPane.setEditable(true);
	            aPane.setText("");
	            bi = bl.getItem(0);
	            if((hi != null) && (bi != null)) {
	            	
	            	
	                inhalt += "<div style=\"color:"+color_headline_text+";background-color:" + color_headline_background + ";text-align:center;font-size:" + String.valueOf(fontsize +2) + ";font-weight:bold;font-color:" + color_losnummer+ "\">";
	                inhalt += rz.getLocale().getString("ausgabe.herstellung") + "&nbsp;"+ rz.getLocale().getString("ausgabe.herstellung_lager") + "&nbsp;" +  rz.getDatabase().getLager().dbGetLager(bi.getLager(), true) + "&nbsp;" + 
	                			rz.getLocale().getString("ausgabe.herstellung_steuerlager") + "&nbsp;" + bi.getStrSteuerlager()+ "<br>" +
	                			rz.getLocale().getString("ausgabe.herstellung_steuer_artikel") + "&nbsp;" + bi.getSteuer_artikel() + "&nbsp;" +
	                			rz.getLocale().getString("ausgabe.herstellung_sorte") + "&nbsp;" + bi.getStrSorte() + "<br>" + 
	                			bi.getBezeichnung() +  "&nbsp;" + rz.getLocale().getString("ausgabe.herstellung_losnummer") + "&nbsp;"+ bi.getLosnummer() + "<br>";
	                inhalt += df.format(hi.getDatum()) + " / " + hi.getUser() + "<br>";
	            	inhalt += bi.getComment().equals("") ? "": bi.getComment().replaceAll(",", ", ") + "<br>";
	            	inhalt += "<div style=\"color:#000000;background-color:#eeeeee;\">"+ rz.getLocale().getString("ausgabe.herstellung_tank") + "&nbsp;" + hi.getTankHTML() + "</div><br>";
	            	if(hi.isRProbe()) {
	            		inhalt+=rz.getLocale().getString("ausgabe.herstellung_rprobe") +"<br>";
	            	}
	                inhalt +="</div>";

	                inhalt +="<div style=\"text-align:center;font-size:"+ String.valueOf(fontsize+1) +"pt;font-weight:plain;color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_herstellung_text") + ";";
	                inhalt +="background-color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_herstellung_back") + ";position:relative;width:100%;height:" +String.valueOf((fontsize+1)*3)+ "px\">";
	                inhalt +=rz.getLocale().getString("ausgabe.herstellung_zugang")+ "&nbsp;";
	            	inhalt += rz.getLocale().formatNumber(bi.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol") + "<br>";
	            	inhalt += "<font color=\""  + (hi.getLiter() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getLiter(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_liter") + ", ";
	            	inhalt += "<font color=\""  + (hi.getKg() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getKg(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_kg") + ", ";
	            	inhalt += "<font color=\""  + (hi.getLa() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getLa(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_la") ;
	                inhalt +="</div>";

	                inhalt +="<div style=\"text-align:center;font-size:"+ String.valueOf(fontsize+1) +"pt;font-weight:plain;color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_schwund_text") + ";";
	                inhalt +="background-color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_schwund_back") + ";position:relative;width:100%;height:" +String.valueOf((fontsize+1)*3)+ "px\">";
	                inhalt +=rz.getLocale().getString("ausgabe.herstellung_schwund")+ "&nbsp;";
	            	inhalt += rz.getLocale().formatNumber(bi.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol") + "<br>";
	            	inhalt += "<font color=\"black\">" + rz.getLocale().formatNumber(Math.abs(hi.getLiter()-hi.getEndmenge_liter()), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_liter") + ", ";
	            	inhalt += "<font color=\"black\">" + rz.getLocale().formatNumber(Math.abs(hi.getKg()-hi.getEndmenge_kg()), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_kg") + ", ";
	            	inhalt += "<font color=\"black\">" + rz.getLocale().formatNumber(Math.abs(hi.getLa()-hi.getEndmenge_la()), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_la") ;
	                inhalt +="</div>";

	                inhalt +="<div style=\"text-align:center;font-size:" + String.valueOf(fontsize+1) + "pt;font-weight:bold;color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_endmenge_text") + ";";
	                inhalt +="background-color:" + rz.getOptionFactory().getHexColor("herstellbuch.color_endmenge_back") + ";position:relative;width:100%;height:" +String.valueOf((fontsize+1)*3)+ "px\">";
	                inhalt +=rz.getLocale().getString("ausgabe.herstellung_endmenge")+ "&nbsp;";
	            	inhalt += rz.getLocale().formatNumber(bi.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol") + "<br>";
	            	inhalt += "<font color=\""  + (hi.getEndmenge_liter() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getEndmenge_liter(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_liter") + ", ";
	            	inhalt += "<font color=\""  + (hi.getEndmenge_kg() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getEndmenge_kg(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_kg") + ", ";
	            	inhalt += "<font color=\""  + (hi.getEndmenge_la() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(hi.getEndmenge_la(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_la") ;
	                inhalt +="</div>";

	            }
	            if(rz.getDatabase().getDM().isConnected()) {
		            	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(bi.getLosnummer());
				    	if(dmliste != null && !dmliste.isEmpty()) {
				    		inhalt +=  rz.getDatabase().getDM().getDMListeHtml(dmliste,true);	
				    	}
	            }
	            inhalt += "<div><center><b>" + rz.getLocale().getString("ausgabe.herstellung.bewertung") + "</b>&nbsp;";
	            inhalt += rz.getDatabase().getBewertungen().getBewertungsLink(hi.getLosnummer(), hi.getBezeichnung(),false);
	            inhalt += "</center></div>";
                inhalt +="<ul style=\"list-style-type:disc;text-align:left;font-size:" + String.valueOf(fontsize) + "pt;font-weight:plain;font-color:black;\">";
	            for(int i = 1;i < bl.size();i++) {
	                bi = bl.getItem(i);
	                if(bi.getCode() != DBBuchung.CODE_SCHWUNDAUSGLEICH) {
	                    	inhalt += "<li><a href='suc:" + bi.getRezeptur_id() + "'>" + bi.getBezeichnung() + "</a>, <font color=\"" + color_losnummer+ "\">" + rz.getLocale().getString("ausgabe.herstellung_losnummer") + "&nbsp;<a href='lll:" + bi.getLosnummer() + "'>" + bi.getLosnummer() + "</a></font>&nbsp;";
	        	            inhalt += rz.getDatabase().getBewertungen().getBewertungsLink(bi.getLosnummer(), bi.getBezeichnung(),true) +" <br>";
	                    	final String cm = rz.getDatabase().getBuchungen().getComment(bi.getLosnummer());
	                    	if((cm != null) && !cm.equals("")){
	                    		inhalt += rz.getLocale().getString("ausgabe.herstellung_zugang_comment") + " " + cm.replaceAll(",", ", ")+"<br>";
	                    	}
	                    	inhalt += bi.getComment().equals("") ? "":rz.getLocale().getString("ausgabe.herstellung_comment_b")+" " + bi.getComment() + "<br>";
	                    	if(bi.getMischung() != 0) {
	                    		inhalt += rz.getLocale().getString("ausgabe.herstellung_mischung").replaceAll("%n", String.valueOf(bi.getMischung())) +  "&nbsp;&nbsp;<a href=\"CH:" + bi.getMischung() +"\">" +   rz.getAusgabeFactory().insertGfx("tracefenster.icon_chart.png",rz.getLocale().getString("ausgabe.herstellung.mischung.chart"))+"</a><br>";;
	                    	}
	                    	inhalt+= rz.getLocale().getString("ausgabe.herstellung_lager") + "&nbsp;" + rz.getDatabase().getLager().dbGetLager(bi.getLager(), true) +"<br>";
	                    	inhalt += rz.getLocale().getString("ausgabe.herstellung_steuerlager") + "&nbsp;" + bi.getStrSteuerlager()+ "<br>";
                				inhalt += rz.getLocale().getString("ausgabe.herstellung_steuer_artikel") + "&nbsp;" + bi.getSteuer_artikel() + "<br>" ;
                				inhalt += rz.getLocale().getString("ausgabe.herstellung_sorte") + "&nbsp;" + bi.getStrSorte() + "<br>" ;
	                    	
	                    	
	                    	inhalt += "<ul style =\"list-style-type:square\">";
	                    	if(bi.getStaerke() > 0) {
								inhalt += "<li>" + rz.getLocale().formatNumber(bi.getStaerke(), OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol") + "</li>";
							}
	                    	inhalt += "<li><font color=\""  + (bi.getLiter() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_liter") + "</li>";
	                    	inhalt += "<li><font color=\""  + (bi.getKg() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(bi.getKg(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_kg") + "</li>";
	                    	if(bi.getStaerke() > 0) {
								inhalt += "<li><font color=\""  + (bi.getLa() <0 ? color_abgang : color_zugang) +  "\">" + rz.getLocale().formatNumber(bi.getLa(), OptionFactory.NF_NORMAL) + "</font> " + rz.getLocale().getString("string_la") + "</li>";
							}
	                    	inhalt += "</ul>";
	                    inhalt +="</li>";
	                }
	            }
	            inhalt+="</ul>";
	            inhalt+="</div></body></html>";
	            aPane.setText(inhalt);
	            aPane.setCaretPosition(0);
	            aPane.setEditable(false);
	        } catch (final Exception e) {
	            aPane.setText("fehler:"+e.getLocalizedMessage());
	            aPane.setEditable(false);
	        }
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    /**
     * Ausgabe für das Statistikfenster
     */
    public void statistikAusgabe(StatistikItem si,int auswahl,JEditorPane aPane) {
    	int jahr,monat;
    	double summen[];
    	final String monate[] = new DateFormatSymbols().getMonths();
    	String inhalt = "";
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	if((si != null) && (aPane != null)) {
    		 inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            aPane.setEditable(true);
            aPane.setText("");
            // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            inhalt += si.getComboItem(auswahl).getHeadLine() + "</div>";
            inhalt += "<div " + this.insertStyle(DIV_ADRESSEN,fontsize) + ">";
            inhalt += si.getAuswahlString() + "</div><br>";
//          tabelle
    		inhalt +="<center><table style=\"border-width:3px;border-style:solid\"";
    		switch(auswahl) {
    			case 0:
    			case 1:
    			case 2:
    			case 3:
    			case 4:
    			case 5:
	    			//Jahres-Statistik, tabelle mit mehreren Spalten
	    			//Tabellenkopf
	    			inhalt += "<tr style=\"border-width:1px;border-style:solid\">";
	    			inhalt += "<td>&nbsp;</td>";
	    			summen = new double[si.getWerteListe().getLastYear() - si.getWerteListe().getFirstYear() + 1];
	    			for(int i =0;i < summen.length;i++) {
	    				summen[i] = 0.0;
	    			}
	    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
	    				inhalt += "<td style=\"border-width:1px;border-style:solid\">";
	    				inhalt += "<div style=\"font-size:" + fontsize + "pt;font-weight:bold;text-align:center\">" + String.valueOf(jahr) + "</div></td>";
	    			}
	    			inhalt += "</tr>";
	    			//tabellenzeilen
	    			for(monat = 0;monat <= 12;monat++) {
	    				inhalt += "<tr>";
	    				inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize + "pt;font-weight:bold\">" + monate[monat] + "</div></td>";
	    				for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
	    					inhalt += "<td style=\"border-width:1px;border-style:solid;text-align:right\">";
	    					inhalt += rz.isZero(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl)) ? "&nbsp;" :
	    						rz.getLocale().formatNumber(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl),OptionFactory.NF_ONE) + "&nbsp;" +si.getComboItem(auswahl).getY_Axis() ;
	    					summen[jahr-si.getWerteListe().getFirstYear()] += si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl);
	    					inhalt += "</td>";
	    				}
	    				inhalt += "</tr>";
	    			}
	    			inhalt += "<tr>";
					inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize +"pt;font-weight:bold\">"+ rz.getLocale().getString("stgrafik.string_summe")  + "</div></td>";
	    			for(jahr = 0;jahr <summen.length;jahr++) {
	    				inhalt += "<td style=\"border-width:1px;border-style:solid\">";
	    				inhalt += "<div style=\"font-size:" + fontsize + "pt;font-weight:bold;text-align:center\">" +
	    				rz.getLocale().formatNumber(summen[jahr],OptionFactory.NF_ONE) +
	    					"&nbsp;" + si.getComboItem(auswahl).getY_Axis() + "</td>" +
	    					"</div></td>";
	    			}
	    			inhalt += "</tr>";
	    			break;
    			case 6:
    			case 7:
    			case 8:
    			case 9:
    			case 10:
    			case 11:
	    			summen = new double[1];
	    			summen[0]=0.0;
	    			//Monats-Statistik, zweispaltig
	    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
	    				for(monat = 0;monat < 12;monat++) {
	    					inhalt += "<tr>";
	    					inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize +"pt;font-weight:bold\">" + monate[monat] + "&nbsp;" + String.valueOf(jahr) + "</div></td>";
	    					inhalt += "<td style=\"border-width:1px;border-style:solid;text-align:right\">";
	    					inhalt += rz.isZero(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl)) ? "&nbsp;" :
	    						rz.getLocale().formatNumber(si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl),OptionFactory.NF_ONE) +
	    						"&nbsp;" + si.getComboItem(auswahl).getY_Axis() ;
	    					summen[0] += si.getValue(si.getWerteListe().getItem(jahr,monat+1),auswahl) ;
	    					inhalt += "</td></tr>";
	    				}
	    			}
					inhalt +="<tr>";
						inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize +"pt;font-weight:bold\">"+ rz.getLocale().getString("stgrafik.string_summe")  + "</div></td>";
						inhalt +=   "<td style=\"border-width:1px;border-style:solid;text-align:right\">";
						inhalt += rz.getLocale().formatNumber(summen[0],OptionFactory.NF_ONE) +
							"&nbsp;" + si.getComboItem(auswahl).getY_Axis() + "</td>";
					inhalt+="</tr>";
					break;
    			case 12:
    			case 13:
    			case 14:
    			case 15:
    			case 16:
    			case 17:
    				// Statistik nach Jahr, 2spaltig:
    				double summe=0.0;
	    			for(jahr = si.getWerteListe().getFirstYear();jahr <= si.getWerteListe().getLastYear();jahr++) {
    					double la_v =0.0,la_n=0.0,liter_v=0.0,liter_n=0.0,kg_v=0.0,kg_n =0.0;
	    				for(monat = 0;monat < 12;monat++) {
	    					final WerteItem wi = si.getWerteListe().getItem(jahr,monat+1);
							la_v += wi.getLa_1();
							la_n += wi.getLa_2();
							liter_v += wi.getLiter_1();
							liter_n += wi.getLiter_2();
							kg_v += wi.getKg_1();
							kg_n += wi.getKg_2();
	    				}
	    				double value=0.0;
						switch (auswahl) {
							case 12:value =la_v;break;
							case 13:value=la_n;break;
							case 14:value=liter_v;break;
							case 15:value=liter_n;break;
							case 16:value=kg_v;break;
							case 17:value=kg_n;break;
						}
    					inhalt += "<tr>";
    					inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize +"pt;font-weight:bold\">" + String.valueOf(jahr) + "</div></td>";
    					inhalt += "<td style=\"border-width:1px;border-style:solid;text-align:right\">";
    					summe+=value;
						if(rz.isZero(value)) {
							inhalt+="";
						}else {
							inhalt += rz.getLocale().formatNumber(value,OptionFactory.NF_ONE) +"&nbsp;" + si.getComboItem(auswahl).getY_Axis();
						}
						inhalt +="</td></tr>";
	    			}
					inhalt +="<tr>";
					inhalt +="<td style=\"border-width:1px;border-style:solid\"><div style=\"font-size:" + fontsize +"pt;font-weight:bold\">"+ rz.getLocale().getString("stgrafik.string_summe")  + "</div></td>";
					inhalt +=   "<td style=\"border-width:1px;border-style:solid;text-align:right;font-weight:bold\">";
					inhalt += rz.getLocale().formatNumber(summe,OptionFactory.NF_ONE) +
						"&nbsp;" + si.getComboItem(auswahl).getY_Axis() + "</td>";
				inhalt+="</tr>";
    			break;
    		}
    		inhalt +="</table></center>";


            inhalt+="</body></html>";
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}
        else {
            displayNotFoundError(aPane);
        }
    }

    /** inventurausgabe(int,JTextPane) gibt eine Notiz aus */
    public void inventurAusgabe(int aKey,JEditorPane aPane){
    	final InventurSummenItem is = new InventurSummenItem();
    	final InventurItem ii = rz.getDatabase().getInventur().getInventur(aKey);
        if (ii != null){
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            inhalt += ii.getBezeichnung();
            inhalt +="</div>";
           	// erstellt
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
       		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ii.getErstelltToString()).replaceAll("%v",ii.getUser_1()) ;
           	inhalt += "</div>";
           	//geändert
           	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
           	inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ii.getGeaendertToString()).replaceAll("%v",ii.getUser_2()) ;
            //bemerkungen
            inhalt += "<div " + this.insertStyle(DIV_NORMAL,fontsize) + ">";
            inhalt += ii.getBemerkungen().replaceAll("\\n","<br>");
            inhalt +="</div>";
            inhalt += "<div " + this.insertStyle(DIV_NORMAL,fontsize) + ">";
            inhalt +="<center><b>" + rz.getLocale().getString("inventurfenster.label_raumliste") + "</b></center>";
           	inhalt += "<table>";
           		for(int i = 0;i < ii.getRaumliste().size();i++) {
           			inhalt += "<tr>" + ii.getRaumliste().getItem(i).getBezeichnung() + "</tr>";
           		}
           	inhalt +="</table></div>";
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize+2) + ">";
            inhalt +="<center>" + rz.getLocale().getString("inventurausgabe.summe")+"</center>";
           	inhalt +="<table>";
           		rz.getDatabase().getInventur().getInventurSumme(ii.getId(),is);
           		inhalt += "<tr><td>" + rz.getLocale().formatNumber(is.getSummeLiter20(),OptionFactory.NF_INVENTUR) + "</td><td>" + rz.getLocale().getString("inventurausgabe.liter20")+"</td></tr>";
          		inhalt += "<tr><td>" + rz.getLocale().formatNumber(is.getSummeLa(),OptionFactory.NF_INVENTUR) + "</td><td>" + rz.getLocale().getString("inventurausgabe.la")+"</td></tr>";
           		inhalt +="</table></div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
        }
        else {
            displayNotFoundError(aPane);
        }
    }

    /**acid(int,JTextPane) gibt ein SäureItem aus */
    public void acidAusgabe(int aKey,JEditorPane aPane){
    	final AcidItem ai = rz.getDatabase().getAcid().getAcid(aKey);
    	if (ai != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            	inhalt += ai.getName();
            inhalt +="</div>";
            inhalt += "<div " + this.insertStyle(DIV_NORMAL,fontsize) + ">";
            inhalt += "<table>";
            	inhalt += "<tr><td>" + rz.getLocale().getString("ausgabe.acid_factor")+"</td>";
            	inhalt += "<td>" + rz.getLocale().formatNumber(ai.getFactor(),OptionFactory.NF_NORMAL) + "</td></tr>";
            inhalt +="</table>";
            inhalt +="</div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    /** gibt eine Laborwertberechnung aus */
    public void laborwertBerechnungAusgabe(RechenItem ri,LaborwertValueListe li, LaborwertItem lw,JEditorPane aPane){
    	if (li != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            double value =0.0;
            final String einheit = lw.getStrEinheit1();
            final String laborwert = lw.getBezeichnung();
            switch(li.getEinheit()) {
            	case RzPro.EINHEIT_KG:value =li.getValue_kg();break;
            	case RzPro.EINHEIT_LITER:value =li.getValue_liter();break;
            	case RzPro.EINHEIT_LA:value =li.getValue_la();break;
            }
            if(lw.isFix()) {
            	inhalt +="<br><center>"+rz.getLocale().getString("ausgabe.laborwertberechnung.fix").replaceAll("%s",laborwert)+ "</center><br>";
            }else {
            inhalt += rz.getLocale().getString("ausgabe.laborwertberechnung_titelzeile")
            	.replaceAll("%v", rz.getLocale().formatNumber(value, OptionFactory.NF_NORMAL))
            	.replaceAll("%e",einheit)
            	.replaceAll("%l",laborwert)
            	.replaceAll("%menge",rz.getLocale().formatNumber(ri.getGesamtLiter(),OptionFactory.NF_NORMAL))
            	.replaceAll("%rezeptur",ri.getRezeptur().getTitel());

	            inhalt += rz.getLocale().getString("ausgabe.laborwertberechnung_ergebnis_la")
	        	.replaceAll("%la",rz.getLocale().formatNumber( li.getSumme_la(),OptionFactory.NF_NORMAL))
	        	.replaceAll("%v",rz.getLocale().formatNumber(  value/li.getSumme_la()  ,OptionFactory.NF_NORMAL))
	        	.replaceAll("%e",einheit).replaceAll("%a",laborwert);
	
	            inhalt += rz.getLocale().getString("ausgabe.laborwertberechnung_ergebnis_liter")
	            	.replaceAll("%liter",rz.getLocale().formatNumber( li.getSumme_liter(),OptionFactory.NF_NORMAL))
	            	.replaceAll("%v",rz.getLocale().formatNumber(  value/li.getSumme_liter()  ,OptionFactory.NF_NORMAL))
	            	.replaceAll("%e",einheit).replaceAll("%a",laborwert);
	
	            inhalt += rz.getLocale().getString("ausgabe.laborwertberechnung_ergebnis_kg")
	        	.replaceAll("%kg",rz.getLocale().formatNumber( li.getSumme_kg(),OptionFactory.NF_NORMAL))
	        	.replaceAll("%v",rz.getLocale().formatNumber(  value/li.getSumme_kg()  ,OptionFactory.NF_NORMAL))
	        	.replaceAll("%e",einheit).replaceAll("%a",laborwert);
            }
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    /**acid(int,JTextPane) gibt ein LaborwertItem aus */
    public void laborwertAusgabe(int aKey,JEditorPane aPane){
    	final LaborwertItem ai = rz.getDatabase().getLaborwerte().getWert(aKey);
    	if (ai != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            	inhalt += ai.getBezeichnung();
            inhalt +="</div>";
            inhalt += "<div " + this.insertStyle(DIV_NORMAL,fontsize) + ">";
            if(ai.isFix()) {
            	inhalt += "<br>" + rz.getLocale().getString("ausgabe.laborwert_fix");
            }else {
	            inhalt += "<br>" + rz.getLocale().getString("ausgabe.laborwert_messwert")
	            	.replaceAll("%e1",rz.getDatabase().getEinheiten().getEinheit(ai.getEinheit1()).getName())
	            	.replaceAll("%e2",rz.getDatabase().getEinheiten().getGrundEinheit(ai.getEinheit2()).getName());
            }
            inhalt += "<br><br>" +ai.getBemerkungen();
            inhalt +="</div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }


    /**acid(int,JTextPane) gibt ein SäureItem aus */
    public void deklarationsListenAusgabe(int aKey,JEditorPane aPane){
    	final DeklarationsItem di = rz.getDatabase().getDeklarationen().getDeklaration(aKey);
    	if (di != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            	inhalt += di.getName();
            inhalt +="</div>";
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
       		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",di.getErstelltToString()).replaceAll("%v",di.getUser_1()) ;
	       	inhalt += "</div>";
	       	//geändert
	       	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
	       		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",di.getGeaendertToString()).replaceAll("%v",di.getUser_2()) ;
	       	inhalt += "</div>";

            inhalt += "<div " + this.insertStyle(DIV_NORMAL,fontsize) + ">";
            	inhalt += di.getDeklaration();
            inhalt +="</div>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    /**
     * Lagerfenster
     */
    public void lagerAusgabe(int aKey,JEditorPane aPane) {
    	final LagerItem li = rz.getDatabase().getLager().dbGetLager(aKey, true);
    	if (li != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
            	inhalt += li.getName();
            inhalt +="</div>";
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
       		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",li.getErstelltToString()).replaceAll("%v",li.getUser1()) ;
	       	inhalt += "</div>";
	       	//geändert
	       	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
	       		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",li.getGeaendertToString()).replaceAll("%v",li.getUser2()) ;
	       	inhalt += "</div>";
            inhalt += "<table>";
        		inhalt += "<tr>";
        			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.lager_liste")+"</td>";
        			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + String.valueOf(li.getListe()) + "</td>";
        		inhalt += "</tr>";
        		inhalt += "<tr>";
    				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.lager_ersatztext")+"</td>";
    				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + li.getErsatztext() + "</td>";
    			inhalt += "</tr>";
        		inhalt += "<tr>";
    				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.lager_comment")+"</td>";
    				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"+ li.getComment().replaceAll("\n","<br>") + "</td>";
    			inhalt += "</tr>";
        		inhalt += "<tr>";
    				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">"  + rz.getLocale().getString("ausgabe.lager_hg")+"</td>";
    				inhalt +=  "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + "&nbsp;<span style=\"background-color:#" +  li.getHg()+"; \">"  + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+ "</span></td>";
    			inhalt += "</tr>";
        		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">"  + rz.getLocale().getString("ausgabe.lager_vg")+"</td>";
					inhalt +=  "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + "&nbsp;<span style=\"background-color:#" +  li.getVg()+"; \">"  + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"+ "</span></td>";
				inhalt += "</tr>";
    			inhalt +="</table>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    /**
     * Lagerfenster
     */
    public void statistikListenAusgabe(BuchungsItem bi,JEditorPane aPane,boolean client) {
        final SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    	final StatistikListenItem	sl = rz.getDatabase().getBuchungen().getStatistikListe(bi);
    	if (sl != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getTableFont().getName();
        	final int fontsize = rz.getFontFactory().getTableFont().getSize();
    		String td = "<td style=\"border-style:solid;border-color:#aaaaaa;border-width:1px;white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize) +" \">";
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
            // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE_LEFT,fontsize+2) + ">";
            	inhalt += rz.getLocale().getString("ausgabe.statistikliste_header") ;
            inhalt +="</div>";
        	inhalt += "<table>";
	        	inhalt +="<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_rezeptur")+"</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + "<a href=\"rrr:"  + String.valueOf(sl.getListe().getItem(0).getRezeptur_id()) + "\">" + sl.getListe().getItem(0).getBezeichnung() + "</a></td>";
		    	inhalt +="</tr>";
		    	if(rz.getDatabase().getDM().isConnected()) {
		    	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(bi.getLosnummer());
			    	if(dmliste != null && !dmliste.isEmpty()) {
			    		inhalt += "<tr>";
			    		inhalt += "<td></td><td>" +  rz.getDatabase().getDM().getDMListeHtml(dmliste,true) + "</td>";	
			    		inhalt += "</tr>";		
			    	}
		    	}
		    	int mischung = rz.getDatabase().getMischungen().getMischungFromLosnummer(bi.getLosnummer());
		    	if(mischung != 0) {
		    		inhalt +="<tr>";
		    			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_mischung")+"</td>";
		    			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  +"<a href=\"MM:" + String.valueOf(mischung) + "\">" + String.valueOf(mischung)  + "</a></td>";
		    	inhalt +="</tr>";
		    	}
	        	inhalt +="<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_staerke")+"</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  +
						(rz.isZero(sl.getListe().getItem(0).getStaerke())?"":rz.getLocale().formatNumber(sl.getListe().getItem(0).getStaerke(),OptionFactory.NF_NORMAL)) + "</td>";
		    	inhalt +="</tr>";

		        inhalt +="<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_gesamt_rest")+"</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  +
					rz.getLocale().getString("ausgabe.statistikliste_gesamt_rest_menge")
						.replaceAll("%l", rz.getLocale().formatNumber(sl.getGesamtRestLiter(),OptionFactory.NF_NORMAL))
						.replaceAll("%k", rz.getLocale().formatNumber(sl.getGesamtRestKg(),OptionFactory.NF_NORMAL))
						.replaceAll("%a", rz.getLocale().formatNumber(sl.getGesamtRestLa(),OptionFactory.NF_NORMAL))
						+ "</td>";
					inhalt +="</tr>";

            	inhalt +="<tr>";
    				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_erste_buchung")+"</td>";
    				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + df.format(sl.getListe().getItem(0).getDatum()) + "</td>";
            	inhalt +="</tr>";
            	inhalt +="<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_letzte_buchung")+"</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + df.format(sl.getListe().getItem(sl.getListe().size()-1).getDatum()) + "</td>";
        	inhalt +="</tr>";
        	inhalt +="<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_losnummer")+"</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><b>"  + sl.getLosnummern() + "</b></td>";
			inhalt +="</tr>";

        	inhalt +="<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_zugang")+"</td>";
			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  +
				rz.getLocale().getString("ausgabe.statistikliste_zugang_menge")
					.replaceAll("%l", rz.getLocale().formatNumber(sl.getLiter(),OptionFactory.NF_NORMAL))
					.replaceAll("%k", rz.getLocale().formatNumber(sl.getKg(),OptionFactory.NF_NORMAL))
					.replaceAll("%a", rz.getLocale().formatNumber(sl.getLa(),OptionFactory.NF_NORMAL))
					+ "</td>";
			inhalt +="</tr>";

        	inhalt +="<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_rest")+"</td>";
				if(rz.isZero(sl.getListe().getItem(0).getRest_liter()) && rz.isZero(sl.getListe().getItem(0).getRest_la())){
					inhalt += td + rz.getLocale().getString("ausgabe.statistikliste_kein_rest") + "</td>";
				} else {
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  +
						rz.getLocale().getString("ausgabe.statistikliste_rest_menge")
							.replaceAll("%l", rz.getLocale().formatNumber(sl.getRest_liter(),OptionFactory.NF_NORMAL))
							.replaceAll("%k", rz.getLocale().formatNumber(sl.getRest_kg(),OptionFactory.NF_NORMAL))
							.replaceAll("%a", rz.getLocale().formatNumber(sl.getRest_la(),OptionFactory.NF_NORMAL))
							+ "</td>";
				}
			inhalt +="</tr>";
        	inhalt +="<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_bemerkungen")+"</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><a href=\"BB:" + String.valueOf(sl.getListe().getItem(0).getId()) + "\">" + sl.getListe().getItem(0).getComment() + "</a></td>";
			inhalt +="</tr>";
			if(bi.getTyp() == DBBuchung.TYP_ZUGANG) {
				inhalt +="<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_probe")+"</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + "><a href=\"PP:" +bi.getRezeptur_id()+  ":" +bi.getHerstellungProbe() + ":" + bi.getLosnummer()  + "\">"+ (bi.getHerstellungProbe().equals("")?rz.getLocale().getString("ausgabe.statistikliste_probe_bearbeiten") :bi.getHerstellungProbe())  +  "</a></td>";
				inhalt +="</tr>";	
			}
        	inhalt +="<tr>";
			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)  + ">" + rz.getLocale().getString("ausgabe.statistikliste_bewertungen")+"</td>";
            inhalt += rz.getDatabase().getBewertungen().getBewertungsLink(bi.getLosnummer(), bi.getBezeichnung(),false);
			inhalt +="</tr>";
            inhalt += "</table>";
            if(!client) {
	            String hr="";
	            for (int i = 0;i < sl.getListe().size();i++) {
	            	 hr += (sl.getListe().getItem(i).getHerstellung_losnummer() == null?"":
	            		 "^" + sl.getListe().getItem(i).getHerstellung_losnummer() + "$|");
	            }
	            if(hr.endsWith("|")) {
					hr = hr.substring(0,hr.length()-1);
				}
		    	inhalt += "<a href=\"LL:" + hr + "\">" +rz.getLocale().getString("ausgabe.statistik_href") + "</a><br>";
            }
            inhalt += "<table style=\"border-style:solid;border-width:1px;border-color:#aaaaaa;white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize) +"\">";
            	inhalt +="<tr>";
            	    inhalt += "<td></td>";
            		inhalt += td + rz.getLocale().getString("statistik.tableheader_id") +"</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_code") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_hlosnummer") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_datum") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_benutzer") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_liter") +   "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_kg") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_la") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_rest_liter") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_rest_kg") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_rest_la") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_bemerkungen") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_mhd") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_adressliste") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_steuerartikel") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_sorte") + "</td>";
	            	inhalt += td + rz.getLocale().getString("statistik.tableheader_steuerlager") + "</td>";
            	inhalt +="</tr>";
            	for(int i = 0;i < sl.getListe().size();i++) {
            		final BuchungsItem bi1 = sl.getListe().getItem(i);
            		final String bgcolor = "#" + (bi1.getLiter() < 0 ?
            					rz.getOptionFactory().getHexColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT)) :
			                    rz.getOptionFactory().getHexColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN)));
            		if(bi.getId() == bi1.getId()) {
            			td = "<td style=\"border-style:solid;border-color:#0000ff;border-width:1px;background-color:"+bgcolor+";white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize)+" \">";
            		} else {
            			td = "<td style=\"border-style:solid;border-color:aaaaaa;border-width:1px;background-color:"+bgcolor+";white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize)+"\">";
            		}
            		Calendar c = Calendar.getInstance();
            		c.setTime(bi1.getDatum());
            		// Buchung
            		inhalt += "<tr>";
            			inhalt += td + (bi.getId()==bi1.getId()?insertGfx("ausgabe.statistik_markierung.png"):"") + "</td>";
	            		inhalt += td + String.valueOf(bi1.getId()) +"</td>";            			
	            		inhalt += td + rz.getDatabase().getBuchungen().getCodeToString(bi1.getCode()) +"</td>";
	            		if(!client) {
	            			inhalt += td + (bi1.getHerstellung_losnummer()== null?"":
	            				"<a href=\"LA:" + bi1.getHerstellung_losnummer()+"\">" + bi1.getHerstellung_losnummer() + "</a>" )+ "</td>";
	            		} else {
	            			inhalt += td + (bi1.getHerstellung_losnummer()== null?"":
	            			 bi1.getHerstellung_losnummer() )+ "</td>";
	            		}
	            		inhalt += td + df.format(bi1.getDatum())  +" ("  +rz.getDatabase().getKalender().getYear20(c)+rz.getDatabase().getKalender().getDate20(c)+  ")</td>";
	            		inhalt += td + bi1.getUser()  + "</td>";
	            		inhalt += td +  (rz.isZero(bi1.getLiter())?"":rz.getLocale().formatNumber(bi1.getLiter(),OptionFactory.NF_NORMAL))+ "</td>";
	            		inhalt += td +  (rz.isZero(bi1.getKg())?"":rz.getLocale().formatNumber(bi1.getKg(),OptionFactory.NF_NORMAL)) + "</td>";
	            		inhalt += td +  (rz.isZero(bi1.getLa())?"":rz.getLocale().formatNumber(bi1.getLa(),OptionFactory.NF_NORMAL)) + "</td>";
	            		inhalt += td +  (rz.isZero(bi1.getRest_liter())?"":rz.getLocale().formatNumber(bi1.getRest_liter(),OptionFactory.NF_NORMAL)) + "</td>";
	            		inhalt += td + (rz.isZero(bi1.getRest_kg())?"":rz.getLocale().formatNumber(bi1.getRest_kg(),OptionFactory.NF_NORMAL)) + "</td>";
	            		inhalt += td + (rz.isZero(bi1.getRest_la())?"":rz.getLocale().formatNumber(bi1.getRest_la(),OptionFactory.NF_NORMAL))  + "</td>";
	            		inhalt += td + bi1.getComment()  + "</td>";
	            		inhalt += td;
	            		if(bi1.getMhdLong()!=0) {
	            			inhalt += rz.getDatabase().getBuchungen().getMhdStringHtml(bi1.getMhdLong());
	            		}
	            		inhalt+="</td>";
	            		inhalt += td + (bi1.getAdressliste() != null?bi1.getAdressliste().toVerboseString():"") + "</td>";
	            		inhalt += td + (bi1.getSteuer_artikel()) + "</td>";
	            		inhalt += td + (bi1.getStrSorte()) + "</td>";
	            		inhalt += td + (bi1.getStrSteuerlager()) + "</td>";
	            		
            		inhalt +="</tr>";
            	}
            inhalt +="</table>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }
    /**
     * Ausstattung
     */
    public void ausstattungsAusgabe(int aKey,JEditorPane aPane) {
    	final AusstattungsItem	ai = rz.getDatabase().getAusstattung().getAusstattung(aKey);
    	if (ai != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           		inhalt += insertGfx("ausstattung.png") + ai.getTitel() + "<br></div>";
            inhalt +="</div>";
           	inhalt += "<div " + insertStyle(DIV_ERSTELLT,fontsize) + ">";
       		inhalt += rz.getLocale().getString("string_erstellt").replaceAll("%s",ai.getErstelltToString()).replaceAll("%v",ai.getUser1()) ;
	       	inhalt += "</div>";
	       	//geändert
	       	inhalt += "<div " + insertStyle(DIV_GEAENDERT,fontsize) + ">";
       		if(rz.getDatabase().getChanges().isChanges(ai.getID())) {
       			inhalt += "<a href=\"cha:" + ai.getID() + "\"><b>" +rz.getLocale().getString("ausgabe.aenderungen") +  "</b>&nbsp;&nbsp;"+ insertGfx("auswahl.action_changes.png")+ "&nbsp;&nbsp;</a>";
       		}
	       		inhalt += rz.getLocale().getString("string_geaendert").replaceAll("%s",ai.getGeaendertToString()).replaceAll("%v",ai.getUser2()) ;
	       	inhalt += "</div>";
	     	inhalt +="<table cellpadding=1 cellspacing=1 align=left >";
       		inhalt += "<tr>";
   					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">"  + rz.getLocale().getString("string_adressen") + "</td>";
       				inhalt += "<td " + insertStyle(DIV_ADRESSEN,fontsize) +">" +
       					"<a href=\"" + ai.getAdressListe().toVerbosePatternString()+  "\">" +
       					ai.getAdressListe().toVerboseString() + "</a></td>";
       		inhalt +="</tr>";
       		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize)+ ">" + rz.getLocale().getString("string_stichworte") + "</td>";
       				inhalt += "<td " +insertStyle(DIV_STICHWORTE,fontsize) + ">" + ai.getStichwortListe().toHTMLString() + "</td>";
   		    inhalt +="</tr>";
   		    //Gebindegröße
       		inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ausstattung_gebindegroesse") + "</td>";
       			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +
       				rz.getLocale().formatNumber(ai.getGebindegroesse(), OptionFactory.NF_NORMAL) + " " +
       				rz.getLocale().getString("string_liter") + "</td> ";
       			inhalt +="</tr>";
       		    //Gebindegewicht
           		inhalt += "<tr>";
           			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ausstattung_gebindegewicht") + "</td>";
           			inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +
           				rz.getLocale().formatNumber(ai.getGebindeGewicht(), OptionFactory.NF_NORMAL) + " " +
           				rz.getLocale().getString("string_kg") + "</td> " +"</td> ";
           			inhalt +="</tr>";
			//Preis
       		inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.preis") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" +
	                	rz.getLocale().formatNumber(ai.getPreis(), OptionFactory.NF_NORMAL) + " "  +
	                	rz.getDatabase().getCurrency().dbGetCurrency( ai.getWaehrung(),true).getName() + "</td>";
		    inhalt +="</tr>";
			//Artikelnummer
       		inhalt += "<tr>";
				inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.artikelnummer") + "</td>";
				inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">" + ai.getArtikelnummer() + "</td>";
			inhalt +="</tr>";
			//Anzeige
       		inhalt += "<tr>";
       			inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.ausstattung_anzeige") + "</td>";
       			if(ai.getListe()) {
       				inhalt += "<td>" + rz.getLocale().getString("string_ja") + "</td>";
       			} else {
       				inhalt += "<td>" + rz.getLocale().getString("string_nein") + "</td>";
       			}
       			/*
				 * Dokumente
				 */
				String documents = rz.getDatabase().getDocuments().getDocumentListeText(ai.getID(),true);
				if(!documents.equals("")) {
					documents =  "<a href=\"doc:" + ai.getID() + "\">" + documents + "</a>";
					inhalt += "<tr>";
					inhalt += "<td " + insertStyle(DIV_MARKUP,fontsize) + ">" + rz.getLocale().getString("ausgabe.dokumente") + "</td>";
					inhalt += "<td " + insertStyle(DIV_NORMAL,fontsize)  + ">"  + documents +  "</td>";
					inhalt +="</tr>";
				}
       			
			inhalt +="</tr>";
			inhalt +="</table>";
			//text
			final String zeilen[] 			= ai.getComment().split("\\n");
           	final String rawZeilen[] 	= ai.getRaw().split("\\n");
           	for (int i = 0; i < zeilen.length;i++) {
           		try {
           		if(rawZeilen[i].indexOf("[[") != -1) {
	           			// Verweis auf Rezeptur
	           			int start,end,verweis;
	           			start = rawZeilen[i].indexOf("[[")+2;
	           			end = rawZeilen[i].indexOf("]]",start);
	           			final String f[] = zeilen[i].split("\\s");
	           			verweis=zeilen[i].indexOf(f[2]);
	           				inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " +
	           				zeilen[i].substring(0,verweis-1) + "&nbsp;" +
	       					"<a href=\"" + rawZeilen[i].substring(start,end) +  "\">" +
	       					zeilen[i].substring(verweis,zeilen[i].length()) +
	       					 "</a></div>";
	           		} else {
           				inhalt += "<div " + insertStyle(DIV_NORMAL,fontsize) + "> " +
       					zeilen[i] + "</div>";
	           		}
           		} catch (final Exception e) {
           			rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"ausstattungsAusgabeHTML-Line",e.getLocalizedMessage());
           		}
           	}
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    /**
     * Ausstattung
     */
    public void ausstattungsBerechnungsAusgabe(AusstattungsItem ai,String zielWaehrung,JEditorPane aPane) {
    	if (ai != null) {
        	String inhalt;
        	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
        	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
             // Überschrift
            inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
           		inhalt += insertGfx("ausstattung.png") + ai.getTitel() + "<br></div>";
            inhalt +="</div>";
            inhalt += "<table style=\"border-style:solid;border-width:1px;border-color:#aaaaaa;white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize) +"\">";
            	inhalt +="<tr style=\"border-style:solid;border-width:1px;border-color:#aaaaaa;white-space:nowrap;font-family:" + fontName + ";font-size:"+String.valueOf(fontsize) +"\">";
            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_bezeichnung")+"</td>";
            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_einzelpreis")+"</td>";
            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_faktor") + "</td>";
            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_gesamtpreis")+"</td>";
            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_gewicht_header")+"</td>";
            		inhalt +="</tr>";
            	for(int i = 0;i < ai.getZeilenListe().size();i++) {
            		inhalt +="<tr>";
	            		inhalt +="<td>" + ai.getZeilenListe().getItem(i).getName()+"</td>";
	            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_einzelpreis_zeile")
	            			.replaceAll("%p",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getEinzelPreis(), OptionFactory.NF_NORMAL))
	            			.replaceAll("%w",ai.getZeilenListe().getItem(i).getWQuelle().getName())
	            			+"</td>";
	            		if(ai.getZeilenListe().getItem(i).getMode() == AusstattungsZeile.MODE_MAL) {
	            			inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_mode_mal_faktor")
	            				.replaceAll("%s",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getFactor(), OptionFactory.NF_NORMAL))
	            			+ "</td>";
	            		} else {
	            			inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_mode_plus_faktor")
            					.replaceAll("%s",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getFactor(), OptionFactory.NF_NORMAL))
            			+ "</td>";
	            		}
	            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_gesamtpreis_zeile")
	            			.replaceAll("%p",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getZeilenPreis(), OptionFactory.NF_NORMAL))
	            			.replaceAll("%w",ai.getZeilenListe().getItem(i).getWZiel().getName())
	            		+"</td>";
	            		inhalt +="<td>" + rz.getLocale().getString("ausgabe.as_rechnen_gesamtgewicht_zeile")
            				.replaceAll("%g",rz.getLocale().formatNumber(ai.getZeilenListe().getItem(i).getZeilenGewicht(), OptionFactory.NF_NORMAL)) + " "
            				+ rz.getLocale().getString("string_kg")
            		+"</td>";
            		inhalt +="</tr>";
            	}
            inhalt += "</table>";
            inhalt += "<center>";
				inhalt += "<div " + insertStyle(DIV_BOLD,fontsize+2)+ ">" + rz.getLocale().getString("ausgabe.as_rechnen_gewicht")
					.replaceAll("%g",rz.getLocale().formatNumber(ai.getGesamtGewicht(), OptionFactory.NF_NORMAL)) + " "
					+ rz.getLocale().getString("string_kg")
				+ "</td>";
				inhalt += "<div " + insertStyle(DIV_BOLD,fontsize+2)+ ">" + rz.getLocale().getString("ausgabe.as_rechnen_summe")
	            			.replaceAll("%p",rz.getLocale().formatNumber(ai.getGesamtPreis(), OptionFactory.NF_NORMAL))
	            			.replaceAll("%w",zielWaehrung)
				+ "</td>";
            inhalt +="</center>";
            inhalt +="</body></html>";
            aPane.setEditable(true);
            aPane.setText(inhalt);
            aPane.setCaretPosition(0);
            aPane.setEditable(false);
    	}else {
            displayNotFoundError(aPane);
    	}
    }

    public void VerbrauchsAusgabe(VerbrauchsListe vl,JEditorPane aPane,boolean alignment) {
    	String inhalt;
    	String bold="";
    	String plain="";

    	String table1 = "";
    	String table2  = "";
    	
    	final String fontName = rz.getFontFactory().getErgebnisFont().getName();
    	final int fontsize = rz.getFontFactory().getErgebnisFont().getSize();
    	if (vl != null) {
	            inhalt = "<html><head></head><body color="+color_text+" bgcolor="+color_background + "><div style=\"font-family:"+fontName + ";\">";
	            // Überschrift
	           inhalt += "<div " + this.insertStyle(DIV_HEADLINE,fontsize) + ">";
	           		if ((vl.getRezepturListe() != null) && vl.getRezepturListe().isEmpty()) {
	           			inhalt += vl.getBezeichnung() + "</div>";
	          		} else {
	          			for(int i = 0;i < vl.getRezepturListe().size();i++) {
	          				inhalt += vl.getRezepturListe().get(i) + "<br>";
	          			}
	          			inhalt += "</div>";
	          		}

	           inhalt +="</div>";
	           

				table1 += "<center><h3><b>"+ rz.getLocale().getString("ausgabe.label_verbrauch_zugang") + "</center></b></h3><br>";						
				table1 +="<table cellpadding=5 cellspacing=5 align=\"right\" border=1  bgcolor=\"#ccffcc\">";
					table1 += "<tr>";
					table1 +="<td align=\"center\"><b>" + rz.getLocale().getString("ausgabe.label_jahr") + "</b></td>";
					table1 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_liter") + "</b></td>";
					table1 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_kg") + "</b></td>";
					table1 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_la") + "</b></td>";
					table1 += "</tr>";
					for(int i = 0; i < vl.getZugangsListe().size();i++    ) {
						final VerbrauchsItem vi=vl.getZugang(i);
						table1 +="<tr>";
						if(vi.getYear()==0) {
							bold="<b>";
							plain ="</b>";
							table1 +="<td align=\"right\">" + bold +rz.getLocale().getString("ausgabe.label_verbrauch_insgesamt" ) + plain+"</td>";
						}else {
							bold="";
							plain="";
							table1 +="<td align=\"right\">" + vi.getYear() +  "</td>";
						}
						table1 +="<td align=\"right\">" + bold + (rz.isZero(vi.getLiter())?"":rz.getLocale().formatNumber(vi.getLiter(), OptionFactory.NF_ONE) )+ plain + "</td>";
						table1 +="<td align=\"right\">" + bold + (rz.isZero(vi.getKg())?"":rz.getLocale().formatNumber(vi.getKg(), OptionFactory.NF_ONE) )+ plain + "</td>";
						table1 +="<td align=\"right\">" + bold + (rz.isZero(vi.getLa())?"":rz.getLocale().formatNumber(vi.getLa(), OptionFactory.NF_ONE)) + plain +  "</td>";
						table1 +="</tr>";
					}
				table1 +="</table>";


			table2 += "<center><h3><b>"+ rz.getLocale().getString("ausgabe.label_verbrauch_abgang") + "</center></b></h3><br>";				
			table2 +="<table cellpadding=5 cellspacing=5 align=\"right\" border=1  bgcolor=\"#ffcccc \">";
				table2 += "<tr>";
				table2 +="<td align=\"center\"><b>" + rz.getLocale().getString("ausgabe.label_jahr") + "</b></td>";
				table2 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_liter") + "</b></td>";
				table2 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_kg") + "</b></td>";
				table2 +="<td align=\"center\"><b>" + rz.getLocale().getString("string_la") + "</b></td>";
				table2 += "</tr>";
				for(int i = 0; i < vl.getAbgangsListe().size();i++    ) {
					final VerbrauchsItem vi=vl.getAbgang(i);
					table2 +="<tr>";
					if(vi.getYear()==0) {
						bold="<b>";
						plain ="</b>";
						table2 +="<td align=\"right\">" + bold +rz.getLocale().getString("ausgabe.label_verbrauch_insgesamt" ) + plain + "</td>";
					}else {
						bold="";
						plain="";
						table2 +="<td align=\"right\">" + vi.getYear() +  "</td>";
					}
					table2 +="<td align=\"right\">" + bold + (rz.isZero(vi.getLiter())?"":rz.getLocale().formatNumber(-vi.getLiter(), OptionFactory.NF_ONE)) +  plain + "</td>";
					table2 +="<td align=\"right\">" + bold + (rz.isZero(vi.getKg())?"":rz.getLocale().formatNumber(-vi.getKg(), OptionFactory.NF_ONE)) + plain + "</td>";
					table2 +="<td align=\"right\">" + bold +(rz.isZero(vi.getLa())?"":rz.getLocale().formatNumber(-vi.getLa(), OptionFactory.NF_ONE)) + plain + "</td>";
					table2 +="</tr>";
			}
			table2 +="</table>";
			
			
			inhalt  += "<table cellpadding=1 cellspacing=1 align=\"center\" border=0 ><tr>";
				if(alignment) {
					//links-rechts
					inhalt +="<td>" + table1 + "</td><td>" + table2 + "</td>";
				} else {
					inhalt +="<tr><td>" + table1 + "</td></tr><tr><td>" + table2 + "</td></tr>";					
				}
			inhalt += "</table>";
			
	        inhalt +="</body></html>";
	        aPane.setEditable(true);
	        aPane.setText(inhalt);
	        aPane.setCaretPosition(0);
	        aPane.setEditable(false);
		}
    	else {
            displayNotFoundError(aPane);
    	}
    }
}