/*
 * Created on 10.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.ausgabe;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class AuftragslisteDrucken extends ReportAusgabe {

    int 							key;
    public static final String		DEFAULT_ORIENTATION="portrait";
    Auftragsliste					liste;
    boolean						eigene;
    /**
     *
     */
    public AuftragslisteDrucken(RzPro r,Object liste,boolean eigene, String optionKey,java.awt.Window w) {
        super(r,null,optionKey,w);
        rz = r;
        this.optionKey=optionKey;
        this.eigene=eigene;
        this.liste = (Auftragsliste)liste;
    }



    /** liefert ein TableModel
     * @param aKey Primärschlüssel einer Rezeptur/Verweis
     */
    @Override
	public void  createModel(){
        tableModel modell = null;
        modell = new tableModel();
        Date now=new Date();
        SimpleDateFormat kw=new SimpleDateFormat("w");
        SimpleDateFormat wd=new SimpleDateFormat("EEEE");        
        if(modell != null) {
	        if(liste != null && !liste.isEmpty()){
	            final Date datum = new Date();
	            for (int i =0;i < liste.size();i++) {
	            	AuftragsItem ai = liste.getItem(i);
	            	if(eigene) {
	            		if(ai.isEigen()) {
			            	modell.addItem(
			            			rz.getDatabase().dbGetUser(),
			                		datum,
			                		ai.getBezeichnung(),
			                		rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_liter"),
			                		rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE)+ " " +rz.getLocale().getString("string_liter") + " "+ai.getBezeichnung(),
			                		ai.getFaellig().getTime(),
			                		rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2],
			                		ai.getErstellt_datum().getTime(),
			                		ai.getErstellt_user(),
			                		ai.getGeaendert_datum().getTime(),
			                		ai.getGeaendert_user(),
			                		ai.getArbeit_user(),
			                		ai.isErledigt(),
			                		ai.getErledigt_datum().getTime(),
			                		ai.getErledigt_user(),
			                		"KW "+kw.format(now),
			                		"KW "+kw.format(ai.getFaellig().getTime())+", "+wd.format(ai.getFaellig().getTime()),
			                		ai.getComment()
			            			);
	            		}
	            	} else {
		            	modell.addItem(
		            			rz.getDatabase().dbGetUser(),
		                		datum,
		                		ai.getBezeichnung(),
		                		rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_liter"),
		                		rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE)+ " " +rz.getLocale().getString("string_liter") + " "+ai.getBezeichnung(),
		                		ai.getFaellig().getTime(),
		                		rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2],
		                		ai.getErstellt_datum().getTime(),
		                		ai.getErstellt_user(),
		                		ai.getGeaendert_datum().getTime(),
		                		ai.getGeaendert_user(),
		                		ai.getArbeit_user(),
		                		ai.isErledigt(),
		                		ai.getErledigt_datum().getTime(),
		                		ai.getErledigt_user(),
		                		"KW "+kw.format(now),
		                		"KW "+kw.format(ai.getFaellig().getTime())+", "+wd.format(ai.getFaellig().getTime()),
		                		ai.getComment()
		                		);
	            	}
	            }
	        }
	        report = getReport();
	        report.setDataFactory(new org.jfree.report.TableDataFactory ("default", modell));
	        report.setQuery ("default");
        }
    }


    private class tableModel extends AbstractTableModel{

        private final String[] COLUMN_NAMES = {
        		"user",
        		"datum",
        		"bezeichnung",
        		"menge",
        		"menge_bezeichnung",
        		"faellig_datum",
        		"faellig_string",
        		"erstellt_datum",
        		"erstellt_user",
        		"geaendert_datum",
        		"geaendert_user",
        		"arbeit_user",
        		"erledigt",
        		"erledigt_datum",
        		"erledigt_user",
        		"datum_kw",
        		"faellig_kw",
        		"bemerkungen"
        	};

              private final Class[] COLUMN_TYPE = {
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  Date.class,
            		  String.class,
            		  Date.class,
            		  String.class,
            		  Date.class,
            		  String.class,
            		  String.class,
            		  boolean.class,
            		  Date.class,
            		  String.class,
            		  String.class,
            		  String.class,
            		  String.class
              };

              private final ArrayList liste;

        tableModel() {
            liste = new ArrayList();
        }

        public void addItem (
        		String user,
        		Date datum,
        		String bezeichnung,
        		String menge,
        		String menge_bezeichnung,
        		Date faellig_datum,
        		String faellig_string,
        		Date erstellt_datum,
        		String erstellt_user,
        		Date geaendert_datum,
        		String geaendert_user,
        		String arbeit_user,
        		boolean erledigt,
        		Date erledigt_datum,
        		String erledigt_user,
        		String datum_kw,
        		String faellig_kw,
        		String bemerkungen
                )
        {
            	liste.add (new Object[] {
            			user,
                		datum,
                		bezeichnung,
                		menge,
                		menge_bezeichnung,
                		faellig_datum,
                		faellig_string,
                		erstellt_datum,
                		erstellt_user,
                		geaendert_datum,
                		geaendert_user,
                		arbeit_user,
                		erledigt,
                		erledigt_datum,
                		erledigt_user,
                		datum_kw,
                		faellig_kw,
                		bemerkungen
                		});
        }

        @Override
		public Class getColumnClass (final int columnIndex)
        {
          return COLUMN_TYPE[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_TYPE.length;
        }

        @Override
		public String getColumnName (final int columnIndex)
        {
          return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount ()
        {
          return liste.size();
        }

        public Object getValueAt (final int rowIndex, final int columnIndex)
        {
          final Object[] l = (Object[])liste.get (rowIndex);
          return l[columnIndex];
        }
    }
}

