/*
 * Created on 02.11.2004
 *
 */
package de.lunqual.rzpro;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import de.lunqual.rzpro.ausgabe.AusgabeFactory;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBFactory;
import de.lunqual.rzpro.designs.DesignFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.splash.SplashFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.fonts.FontFactory;
import de.lunqual.rzpro.hilfefactory.HilfeFactory;
import de.lunqual.rzpro.items.fenster.FensterItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.localefactory.LocaleFactory;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.tafel.TafelFactory;

/**
 * @author labor
 *
 * Rezeptubuch Client-Programm.
 * enthält nur eine einfachere Rezepturen-Auswahl, die Möglichkeit Abgänge
 * zu buchen und die eigenen Buchungen zu bearbeiten
 *
 */
public class RzClient extends RzPro {

    //Const
    // Application allgemein
    public static final String      	APP_NAME            = "Rezeptbuch Pro Client";
    public static final int         	APP_VERSION         = 4;
    public static final int         	APP_MAJOR           = 2;
    public static final int         	APP_MINOR           = 0;
    public static final String			APP_BUILD			= "24.12.2025";

    // maximale Länger der Strings in der Datenbank
    public static final int         	STRING_SIZE         		= 255;
    //nach xxx millisekunden läuft der Timer für listen ab
    public static final int         	LIST_TIMEOUT        		= 250;
    // nach xxx millisekunden läuft der Timer im Zutatendialog ab
    public static final int			ZUTATEN_TIMEOUT		= 125;

    // soll Garbage Collection bei jedem "Sperren" erfolgen ?
    public static final String      DEFAULT_GC_HANDLING = "yes";

    // Diese Zahl wird als 0 betrachtet. Die Dezimalstellen sollten so gewählt werden, wie die
    // allgemeine Zahlendarstellung erfordert. Normalerweise wird auf 4 Dezimalstellen gerechnet,
    // DOUBLE_NULL sollte dann also 0.0001 sein. Dafür wird eine Option gesetzt, diese Definition hier ist
    // nur die Vorgabe !
    public static final double 	DOUBLE_NULL = 0.0001;

    // Voreinstellungen
    public static final int         OPTION_KALKULATION_DEFAULT_CURRENCY = 1;
    public static final int         CURRENCY_DEFAULT_SCALE = 4;
    public static final int         OPTION_REZEPTUR_DEFAULT_EINHEIT = 1;

    public static final String     DATEFORMAT_NORMAL   		= "dd.MM.yyyy H:mm:ss";
    public static final String     DATEFORMAT          			= "EEEEE, d. MMMMM yyyy ";

    // fundamentale Rezepturtypen
    public static final int         TYP_ID_REZEPT       			= 1;
    public static final int         TYP_ID_NOTIZ        				= 2;
    public static final int		  TYP_ID_VERWEIS    				= 3;
    //Zahlenformate


    // fundamentale Zeilentypen
    public static final String      TYP_COMMENT         			= "0";
    public static final String      TYP_CALC            				= "1";
    // einheiten
    public static final int			EINHEIT_COMMENT			= 0;
    public static final int         	EINHEIT_LITER       			= 1;
    public static final int         	EINHEIT_KG          				= 2;
    public static final int         	EINHEIT_LA          				= 3;
    public static final int			EINHEIT_STAERKE				= 4;
    public static final int			EINHEIT_EXTRAKT				= 5;
    public static final int 			EINHEIT_FAKTOR				= 6;

    LogFactory         	log;
    DesignFactory		design;
    OptionFactory      	options;
    FontFactory         	fonts;
    LocaleFactory      	locale;
    FensterFactory    	fenster;
    DBFactory           	database;
    DialogControl       	dialog;
    AusgabeFactory  	ausgabe;
    ReportFactory      	report;
    HilfeFactory        	hilfe;
    TafelFactory        	tafel;
    Timer   							inactivityTimer;
	 AWTEventListener 		tm;	
	private static final long eventMask = AWTEvent.MOUSE_MOTION_EVENT_MASK   + AWTEvent.MOUSE_EVENT_MASK  + AWTEvent.KEY_EVENT_MASK;
    
    double					nullValue = DOUBLE_NULL;

    /**  gibt an, ob das Programm
     * gerade gestartet wurde oder
     * ob es schon läuft
     * wird zum Sperren/Entsperren
     * gebraucht
     */
    boolean             	startup = true;

    static SplashFenster		splash;
    /**
     * Creates a new instance of rzpro
     */
    public RzClient(String[] args){
    	super();
    }

	public void initInactivityTimer() {
		if(inactivityTimer != null) {
			inactivityTimer.stop();
			inactivityTimer = null;
		}
		if(tm != null) {
			Toolkit.getDefaultToolkit().removeAWTEventListener(tm);
			tm = null;
		}
		int value = getOptionFactory().getOption("default.inactivity.timeout",OptionFactory.DEFAULT_INACTIVITY_TIMEOUT);
		if(value > 0) {
			setupTM();
			this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", "timeout set to " + value + " minutes");
			inactivityTimer = new Timer(value * 1000 * 60, new ActionListener() {
	            public void actionPerformed(ActionEvent evt) {
	                 inactivityTimerEvent();
	            }
		    });
			inactivityTimer.start();
		}else {
			this.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "kernel", "no timeout set");
		}
	}
	
	private void setupTM(){
		 tm = new AWTEventListener()
			{
			    public void eventDispatched(AWTEvent e)
			    {
			    	if(inactivityTimer != null) {
			    		if(inactivityTimer.isRunning())inactivityTimer.restart();
			    	}
			    }
		 };
		 if(tm != null) {
			Toolkit.getDefaultToolkit().addAWTEventListener(tm,eventMask);
		 }
	}
	
	private  void inactivityTimerEvent() {
		inactivityTimer.stop();
		FensterItem fi = getFensterFactory().getFensterListe().getFensterItem(FensterFactory.FENSTER_LOGIN);
		if(fi == null) {
			JRzFrame frame = getFensterFactory().getFensterListe().getActive();
			if(frame != null) {
				getFensterFactory().getFensterListe().sperren(frame);
			}
		} 
		inactivityTimer.start();
	}
    
    /** das Programm starten.. alle nötigen Klassen instanzieren  */
    @Override
	public void openApp(){
        log         	= new LogFactory(this);
        splash.setStatus(5);
        design 		= new DesignFactory(this);
        splash.setStatus(10);
        options     	= new OptionFactory(this);
        log.initLog();
        splash.setStatus(15);
        locale      	= new LocaleFactory(this); // Sprache    ;
        splash.setStatus(25);
        database   = new DBFactory(this);
        splash.setStatus(30);
        fonts       	= new FontFactory(this);
        splash.setStatus(40);
        fenster    	= new FensterFactory(this);
        splash.setStatus(50);
        dialog      	= new DialogControl(this);
        splash.setStatus(60);
        ausgabe    = new AusgabeFactory(this);
        splash.setStatus(70);
        report      	= new ReportFactory(this);
        splash.setStatus(80);
        hilfe       	= new HilfeFactory(this);
        splash.setStatus(90);
        tafel       	= new TafelFactory(this);
        splash.setStatus(95);
        // NullValue setzen;
        nullValue = options.getDouble("nff.null",DOUBLE_NULL);
        // Loginfenster anzeigen

        fenster.getFensterListe().createWindow(FensterFactory.FENSTER_LOGIN,true,null);
    }

    /**
     * Nachrichten über Login-OK, Login-Abbruch oder Programm beenden !
     * @param msg
     */

    @Override
	public void sysMessage(final MessageItem msg) {
        switch (msg.getMsgCode()){
            case MessageItem.MSG_LOGIN_OK:
            	// falls das AnmeldeEinstellungs-Fenster noch offen steht, sollte es geschlossen werden
            	getFensterFactory().getFensterListe().disposeFrame( String.valueOf(FensterFactory.FENSTER_LOGIN_EINSTELLUNGEN) + FensterFactory.WINDOW_SEPARATOR + "0");
                if(startup){
                    fenster.getFensterListe().disposeFrame((JRzFrame)msg.getData());
                    fenster.getFensterListe().createWindow(FensterFactory.FENSTER_ABGANGCLIENT_AUSWAHL,true,null);
                    startup=false;
                }
                else {
                    fenster.getFensterListe().disposeFrame((JRzFrame)msg.getData());
                    fenster.getFensterListe().entSperren();
                }
        		initInactivityTimer();
                break;
            case MessageItem.MSG_LOGIN_CANCEL :
                closeApp();
                break;
            case MessageItem.MSG_QUIT :
                log.logMessage(LogFactory.LOG_MESSAGE,"RzPro","quit Program");
                closeApp();
                break;
        }
    }


    /** getVersionString gibt den Namen und die Version zurück  */
    @Override
	public String getVersionString(){
        return APP_NAME + " (" + APP_VERSION + "." + APP_MAJOR + "." + APP_MINOR + "/" + APP_BUILD+ ")";
    }


    /** aufräumen und Programm beenden */
    @Override
	public void closeApp(){
        database.dbClose();
        fenster.disposeAllWindows();
        options.cleanUp();
        log=null;
        options = null;
        locale = null;
        fenster = null;
        fonts = null;
        database = null;
        dialog = null;
        ausgabe = null;
        report = null;
        hilfe = null;
        tafel = null;
        disposeSplash(); // vorsichtshalber
        System.exit(0);
    }

    @Override
	public boolean isZero(final double value) {
        return Math.abs(value) < nullValue;
    }

    @Override
	public void setWaitCursor(final Window w){
        if(w != null) {
			w.setCursor(Cursor.getPredefinedCursor( Cursor.WAIT_CURSOR));
		}
    }

    public boolean isMain() {
    	return false;
    }
    
    @Override
	public void setFreeCursor(final Window w) {
      if(w != null) {
		w.setCursor(Cursor.getPredefinedCursor( Cursor.DEFAULT_CURSOR));
	}
    }
    @Override
	public LogFactory       getLogFactory(){return log;}
    @Override
	public DesignFactory  getDesignFactory() {return design;}
    @Override
	public OptionFactory    getOptionFactory(){return options;}
    @Override
	public LocaleFactory    getLocale(){return locale;}
    @Override
	public FensterFactory   getFensterFactory(){return fenster;}
    @Override
	public FontFactory      getFontFactory(){return fonts;}
    @Override
	public DBFactory        getDatabase(){return database;}
    @Override
	public DialogControl    getDialogFactory(){return dialog;}
    @Override
	public AusgabeFactory   getAusgabeFactory(){return ausgabe;}
    @Override
	public ReportFactory    getReportFactory(){return report;}
    @Override
	public HilfeFactory     getHilfeFactory(){return hilfe;}
    @Override
	public TafelFactory     getTafelFactory(){return tafel;}

    @Override
	public void disposeSplash() {
    	if(splash != null) {
    		splash.dispose();
    		splash = null;
    	}
    }

    @Override
	public void setSplashStatus(final int percent) {
    	if(splash != null) {
    		splash.setStatus(percent);
    	}
    }

    /** @param args the command line arguments   */
    public static void main(final String[] args) {
    	splash=new SplashFenster();
        final RzPro r = new RzClient(args);
        r.openApp();
    }
}
